// Copyright (c) 2015, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.
library initialize.static_loader;

import 'dart:collection' show Queue;
import 'package:initialize/initialize.dart';

/// This represents an annotation/declaration pair.
class InitEntry<T> {
  /// The annotation instance.
  final Initializer<T> meta;

  /// The target of the annotation to pass to initialize.
  final T target;

  InitEntry(this.meta, this.target);
}

/// Set of initializers that are invoked by `run`.  This is initialized with
/// code automatically generated by the transformer.
Queue<InitEntry> initializers = new Queue<InitEntry>();

/// Returns initializer functions matching the supplied filters and removes them
/// from `initializers` so they won't be ran again.
Queue<Function> loadInitializers(
    {List<Type> typeFilter, InitializerFilter customFilter, Uri from}) {
  if (from != null) {
    throw 'The `from` option is not supported in deploy mode.';
  }
  Queue<Function> result = new Queue<Function>();

  var matchesFilters = (initializer) {
    if (typeFilter != null &&
        !typeFilter.any((t) => initializer.meta.runtimeType == t)) {
      return false;
    }
    if (customFilter != null && !customFilter(initializer.meta)) {
      return false;
    }
    return true;
  };

  result.addAll(initializers
      .where(matchesFilters)
      .map((i) => () => i.meta.initialize(i.target)));

  initializers.removeWhere(matchesFilters);

  return result;
}
