// Copyright (c) 2012, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

part of sha256_test;

// Standard test vectors from:
//   http://csrc.nist.gov/groups/STM/cavp/documents/shs/shabytetestvectors.zip

const sha256_short_inputs = const [
const [ ],
const [ 0xd3 ],
const [ 0x11, 0xaf ],
const [ 0xb4, 0x19, 0x0e ],
const [ 0x74, 0xba, 0x25, 0x21 ],
const [ 0xc2, 0x99, 0x20, 0x96, 0x82 ],
const [ 0xe1, 0xdc, 0x72, 0x4d, 0x56, 0x21 ],
const [ 0x06, 0xe0, 0x76, 0xf5, 0xa4, 0x42, 0xd5 ],
const [ 0x57, 0x38, 0xc9, 0x29, 0xc4, 0xf4, 0xcc, 0xb6 ],
const [ 0x33, 0x34, 0xc5, 0x80, 0x75, 0xd3, 0xf4, 0x13, 0x9e ],
const [ 0x74, 0xcb, 0x93, 0x81, 0xd8, 0x9f, 0x5a, 0xa7, 0x33, 0x68 ],
const [ 0x76, 0xed, 0x24, 0xa0, 0xf4, 0x0a, 0x41, 0x22, 0x1e, 0xbf, 0xcf ],
const [ 0x9b, 0xaf, 0x69, 0xcb, 0xa3, 0x17, 0xf4, 0x22, 0xfe, 0x26, 0xa9, 0xa0 ],
const [ 0x68, 0x51, 0x1c, 0xdb, 0x2d, 0xbb, 0xf3, 0x53, 0x0d, 0x7f, 0xb6, 0x1c, 0xbc ],
const [ 0xaf, 0x39, 0x7a, 0x8b, 0x8d, 0xd7, 0x3a, 0xb7, 0x02, 0xce, 0x8e, 0x53, 0xaa, 0x9f ],
const [ 0x29, 0x4a, 0xf4, 0x80, 0x2e, 0x5e, 0x92, 0x5e, 0xb1, 0xc6, 0xcc, 0x9c, 0x72, 0x4f, 0x09 ],
const [ 0x0a, 0x27, 0x84, 0x7c, 0xdc, 0x98, 0xbd, 0x6f, 0x62, 0x22, 0x0b, 0x04, 0x6e, 0xdd, 0x76, 0x2b ],
const [ 0x1b, 0x50, 0x3f, 0xb9, 0xa7, 0x3b, 0x16, 0xad, 0xa3, 0xfc, 0xf1, 0x04, 0x26, 0x23, 0xae, 0x76, 0x10 ],
const [ 0x59, 0xeb, 0x45, 0xbb, 0xbe, 0xb0, 0x54, 0xb0, 0xb9, 0x73, 0x34, 0xd5, 0x35, 0x80, 0xce, 0x03, 0xf6, 0x99 ],
const [ 0x58, 0xe5, 0xa3, 0x25, 0x9c, 0xb0, 0xb6, 0xd1, 0x2c, 0x83, 0xf7, 0x23, 0x37, 0x9e, 0x35, 0xfd, 0x29, 0x8b, 0x60 ],
const [ 0xc1, 0xef, 0x39, 0xce, 0xe5, 0x8e, 0x78, 0xf6, 0xfc, 0xdc, 0x12, 0xe0, 0x58, 0xb7, 0xf9, 0x02, 0xac, 0xd1, 0xa9, 0x3b ],
const [ 0x9c, 0xab, 0x7d, 0x7d, 0xca, 0xec, 0x98, 0xcb, 0x3a, 0xc6, 0xc6, 0x4d, 0xd5, 0xd4, 0x47, 0x0d, 0x0b, 0x10, 0x3a, 0x81, 0x0c ],
const [ 0xea, 0x15, 0x7c, 0x02, 0xeb, 0xaf, 0x1b, 0x22, 0xde, 0x22, 0x1b, 0x53, 0xf2, 0x35, 0x39, 0x36, 0xd2, 0x35, 0x9d, 0x1e, 0x1c, 0x97 ],
const [ 0xda, 0x99, 0x9b, 0xc1, 0xf9, 0xc7, 0xac, 0xff, 0x32, 0x82, 0x8a, 0x73, 0xe6, 0x72, 0xd0, 0xa4, 0x92, 0xf6, 0xee, 0x89, 0x5c, 0x68, 0x67 ],
const [ 0x47, 0x99, 0x13, 0x01, 0x15, 0x6d, 0x1d, 0x97, 0x7c, 0x03, 0x38, 0xef, 0xbc, 0xad, 0x41, 0x00, 0x41, 0x33, 0xae, 0xfb, 0xca, 0x6b, 0xcf, 0x7e ],
const [ 0x2e, 0x7e, 0xa8, 0x4d, 0xa4, 0xbc, 0x4d, 0x7c, 0xfb, 0x46, 0x3e, 0x3f, 0x2c, 0x86, 0x47, 0x05, 0x7a, 0xff, 0xf3, 0xfb, 0xec, 0xec, 0xa1, 0xd2, 0x00 ],
const [ 0x47, 0xc7, 0x70, 0xeb, 0x45, 0x49, 0xb6, 0xef, 0xf6, 0x38, 0x1d, 0x62, 0xe9, 0xbe, 0xb4, 0x64, 0xcd, 0x98, 0xd3, 0x41, 0xcc, 0x1c, 0x09, 0x98, 0x1a, 0x7a ],
const [ 0xac, 0x4c, 0x26, 0xd8, 0xb4, 0x3b, 0x85, 0x79, 0xd8, 0xf6, 0x1c, 0x98, 0x07, 0x02, 0x6e, 0x83, 0xe9, 0xb5, 0x86, 0xe1, 0x15, 0x9b, 0xd4, 0x3b, 0x85, 0x19, 0x37 ],
const [ 0x07, 0x77, 0xfc, 0x1e, 0x1c, 0xa4, 0x73, 0x04, 0xc2, 0xe2, 0x65, 0x69, 0x28, 0x38, 0x10, 0x9e, 0x26, 0xaa, 0xb9, 0xe5, 0xc4, 0xae, 0x4e, 0x86, 0x00, 0xdf, 0x4b, 0x1f ],
const [ 0x1a, 0x57, 0x25, 0x1c, 0x43, 0x1d, 0x4e, 0x6c, 0x2e, 0x06, 0xd6, 0x52, 0x46, 0xa2, 0x96, 0x91, 0x50, 0x71, 0xa5, 0x31, 0x42, 0x5e, 0xcf, 0x25, 0x59, 0x89, 0x42, 0x2a, 0x66 ],
const [ 0x9b, 0x24, 0x5f, 0xda, 0xd9, 0xba, 0xeb, 0x89, 0x0d, 0x9c, 0x0d, 0x0e, 0xff, 0x81, 0x6e, 0xfb, 0x4c, 0xa1, 0x38, 0x61, 0x0b, 0xc7, 0xd7, 0x8c, 0xb1, 0xa8, 0x01, 0xed, 0x32, 0x73 ],
const [ 0x95, 0xa7, 0x65, 0x80, 0x9c, 0xaf, 0x30, 0xad, 0xa9, 0x0a, 0xd6, 0xd6, 0x1c, 0x2b, 0x4b, 0x30, 0x25, 0x0d, 0xf0, 0xa7, 0xce, 0x23, 0xb7, 0x75, 0x3c, 0x91, 0x87, 0xf4, 0x31, 0x9c, 0xe2 ],
const [ 0x09, 0xfc, 0x1a, 0xcc, 0xc2, 0x30, 0xa2, 0x05, 0xe4, 0xa2, 0x08, 0xe6, 0x4a, 0x8f, 0x20, 0x42, 0x91, 0xf5, 0x81, 0xa1, 0x27, 0x56, 0x39, 0x2d, 0xa4, 0xb8, 0xc0, 0xcf, 0x5e, 0xf0, 0x2b, 0x95 ],
const [ 0x05, 0x46, 0xf7, 0xb8, 0x68, 0x2b, 0x5b, 0x95, 0xfd, 0x32, 0x38, 0x5f, 0xaf, 0x25, 0x85, 0x4c, 0xb3, 0xf7, 0xb4, 0x0c, 0xc8, 0xfa, 0x22, 0x9f, 0xbd, 0x52, 0xb1, 0x69, 0x34, 0xaa, 0xb3, 0x88, 0xa7 ],
const [ 0xb1, 0x2d, 0xb4, 0xa1, 0x02, 0x55, 0x29, 0xb3, 0xb7, 0xb1, 0xe4, 0x5c, 0x6d, 0xbc, 0x7b, 0xaa, 0x88, 0x97, 0xa0, 0x57, 0x6e, 0x66, 0xf6, 0x4b, 0xf3, 0xf8, 0x23, 0x61, 0x13, 0xa6, 0x27, 0x6e, 0xe7, 0x7d ],
const [ 0xe6, 0x8c, 0xb6, 0xd8, 0xc1, 0x86, 0x6c, 0x0a, 0x71, 0xe7, 0x31, 0x3f, 0x83, 0xdc, 0x11, 0xa5, 0x80, 0x9c, 0xf5, 0xcf, 0xbe, 0xed, 0x1a, 0x58, 0x7c, 0xe9, 0xc2, 0xc9, 0x2e, 0x02, 0x2a, 0xbc, 0x16, 0x44, 0xbb ],
const [ 0x4e, 0x3d, 0x8a, 0xc3, 0x6d, 0x61, 0xd9, 0xe5, 0x14, 0x80, 0x83, 0x11, 0x55, 0xb2, 0x53, 0xb3, 0x79, 0x69, 0xfe, 0x7e, 0xf4, 0x9d, 0xb3, 0xb3, 0x99, 0x26, 0xf3, 0xa0, 0x0b, 0x69, 0xa3, 0x67, 0x74, 0x36, 0x60, 0x00 ],
const [ 0x03, 0xb2, 0x64, 0xbe, 0x51, 0xe4, 0xb9, 0x41, 0x86, 0x4f, 0x9b, 0x70, 0xb4, 0xc9, 0x58, 0xf5, 0x35, 0x5a, 0xac, 0x29, 0x4b, 0x4b, 0x87, 0xcb, 0x03, 0x7f, 0x11, 0xf8, 0x5f, 0x07, 0xeb, 0x57, 0xb3, 0xf0, 0xb8, 0x95, 0x50 ],
const [ 0xd0, 0xfe, 0xfd, 0x96, 0x78, 0x7c, 0x65, 0xff, 0xa7, 0xf9, 0x10, 0xd6, 0xd0, 0xad, 0xa6, 0x3d, 0x64, 0xd5, 0xc4, 0x67, 0x99, 0x60, 0xe7, 0xf0, 0x6a, 0xeb, 0x8c, 0x70, 0xdf, 0xef, 0x95, 0x4f, 0x8e, 0x39, 0xef, 0xdb, 0x62, 0x9b ],
const [ 0xb7, 0xc7, 0x9d, 0x7e, 0x5f, 0x1e, 0xec, 0xcd, 0xfe, 0xdf, 0x0e, 0x7b, 0xf4, 0x3e, 0x73, 0x0d, 0x44, 0x7e, 0x60, 0x7d, 0x8d, 0x14, 0x89, 0x82, 0x3d, 0x09, 0xe1, 0x12, 0x01, 0xa0, 0xb1, 0x25, 0x80, 0x39, 0xe7, 0xbd, 0x48, 0x75, 0xb1 ],
const [ 0x64, 0xcd, 0x36, 0x3e, 0xcc, 0xe0, 0x5f, 0xdf, 0xda, 0x24, 0x86, 0xd0, 0x11, 0xa3, 0xdb, 0x95, 0xb5, 0x20, 0x6a, 0x19, 0xd3, 0x05, 0x40, 0x46, 0x81, 0x9d, 0xd0, 0xd3, 0x67, 0x83, 0x95, 0x5d, 0x7e, 0x5b, 0xf8, 0xba, 0x18, 0xbf, 0x73, 0x8a ],
const [ 0x6a, 0xc6, 0xc6, 0x3d, 0x61, 0x8e, 0xaf, 0x00, 0xd9, 0x1c, 0x5e, 0x28, 0x07, 0xe8, 0x3c, 0x09, 0x39, 0x12, 0xb8, 0xe2, 0x02, 0xf7, 0x8e, 0x13, 0x97, 0x03, 0x49, 0x8a, 0x79, 0xc6, 0x06, 0x7f, 0x54, 0x49, 0x7c, 0x61, 0x27, 0xa2, 0x39, 0x10, 0xa6 ],
const [ 0xd2, 0x68, 0x26, 0xdb, 0x9b, 0xae, 0xaa, 0x89, 0x26, 0x91, 0xb6, 0x89, 0x00, 0xb9, 0x61, 0x63, 0x20, 0x8e, 0x80, 0x6a, 0x1d, 0xa0, 0x77, 0x42, 0x9e, 0x45, 0x4f, 0xa0, 0x11, 0x84, 0x09, 0x51, 0xa0, 0x31, 0x32, 0x7e, 0x60, 0x5a, 0xb8, 0x2e, 0xcc, 0xe2 ],
const [ 0x3f, 0x7a, 0x05, 0x9b, 0x65, 0xd6, 0xcb, 0x02, 0x49, 0x20, 0x4a, 0xac, 0x10, 0xb9, 0xf1, 0xa4, 0xac, 0x9e, 0x58, 0x68, 0xad, 0xeb, 0xbe, 0x93, 0x5a, 0x9e, 0xb5, 0xb9, 0x01, 0x9e, 0x1c, 0x93, 0x8b, 0xfc, 0x4e, 0x5c, 0x53, 0x78, 0x99, 0x7a, 0x39, 0x47, 0xf2 ],
const [ 0x60, 0xff, 0xcb, 0x23, 0xd6, 0xb8, 0x8e, 0x48, 0x5b, 0x92, 0x0a, 0xf8, 0x1d, 0x10, 0x83, 0xf6, 0x29, 0x1d, 0x06, 0xac, 0x8c, 0xa3, 0xa9, 0x65, 0xb8, 0x59, 0x14, 0xbc, 0x2a, 0xdd, 0x40, 0x54, 0x4a, 0x02, 0x7f, 0xca, 0x93, 0x6b, 0xbd, 0xe8, 0xf3, 0x59, 0x05, 0x1c ],
const [ 0x9e, 0xcd, 0x07, 0xb6, 0x84, 0xbb, 0x9e, 0x0e, 0x66, 0x92, 0xe3, 0x20, 0xce, 0xc4, 0x51, 0x0c, 0xa7, 0x9f, 0xcd, 0xb3, 0xa2, 0x21, 0x2c, 0x26, 0xd9, 0x0d, 0xf6, 0x5d, 0xb3, 0x3e, 0x69, 0x2d, 0x07, 0x3c, 0xc1, 0x74, 0x84, 0x0d, 0xb7, 0x97, 0x50, 0x4e, 0x48, 0x2e, 0xef ],
const [ 0x9d, 0x64, 0xde, 0x71, 0x61, 0x89, 0x58, 0x84, 0xe7, 0xfa, 0x3d, 0x6e, 0x9e, 0xb9, 0x96, 0xe7, 0xeb, 0xe5, 0x11, 0xb0, 0x1f, 0xe1, 0x9c, 0xd4, 0xa6, 0xb3, 0x32, 0x2e, 0x80, 0xaa, 0xf5, 0x2b, 0xf6, 0x44, 0x7e, 0xd1, 0x85, 0x4e, 0x71, 0x00, 0x1f, 0x4d, 0x54, 0xf8, 0x93, 0x1d ],
const [ 0xc4, 0xad, 0x3c, 0x5e, 0x78, 0xd9, 0x17, 0xec, 0xb0, 0xcb, 0xbc, 0xd1, 0xc4, 0x81, 0xfc, 0x2a, 0xaf, 0x23, 0x2f, 0x7e, 0x28, 0x97, 0x79, 0xf4, 0x0e, 0x50, 0x4c, 0xc3, 0x09, 0x66, 0x2e, 0xe9, 0x6f, 0xec, 0xbd, 0x20, 0x64, 0x7e, 0xf0, 0x0e, 0x46, 0x19, 0x9f, 0xbc, 0x48, 0x2f, 0x46 ],
const [ 0x4e, 0xef, 0x51, 0x07, 0x45, 0x9b, 0xdd, 0xf8, 0xf2, 0x4f, 0xc7, 0x65, 0x6f, 0xd4, 0x89, 0x6d, 0xa8, 0x71, 0x1d, 0xb5, 0x04, 0x00, 0xc0, 0x16, 0x48, 0x47, 0xf6, 0x92, 0xb8, 0x86, 0xce, 0x8d, 0x7f, 0x4d, 0x67, 0x39, 0x50, 0x90, 0xb3, 0x53, 0x4e, 0xfd, 0x7b, 0x0d, 0x29, 0x8d, 0xa3, 0x4b ],
const [ 0x04, 0x7d, 0x27, 0x58, 0xe7, 0xc2, 0xc9, 0x62, 0x3f, 0x9b, 0xdb, 0x93, 0xb6, 0x59, 0x7c, 0x5e, 0x84, 0xa0, 0xcd, 0x34, 0xe6, 0x10, 0x01, 0x4b, 0xcb, 0x25, 0xb4, 0x9e, 0xd0, 0x5c, 0x7e, 0x35, 0x6e, 0x98, 0xc7, 0xa6, 0x72, 0xc3, 0xdd, 0xdc, 0xae, 0xb8, 0x43, 0x17, 0xef, 0x61, 0x4d, 0x34, 0x2f ],
const [ 0x3d, 0x83, 0xdf, 0x37, 0x17, 0x2c, 0x81, 0xaf, 0xd0, 0xde, 0x11, 0x51, 0x39, 0xfb, 0xf4, 0x39, 0x0c, 0x22, 0xe0, 0x98, 0xc5, 0xaf, 0x4c, 0x5a, 0xb4, 0x85, 0x24, 0x06, 0x51, 0x0b, 0xc0, 0xe6, 0xcf, 0x74, 0x17, 0x69, 0xf4, 0x44, 0x30, 0xc5, 0x27, 0x0f, 0xda, 0xe0, 0xcb, 0x84, 0x9d, 0x71, 0xcb, 0xab ],
const [ 0x33, 0xfd, 0x9b, 0xc1, 0x7e, 0x2b, 0x27, 0x1f, 0xa0, 0x4c, 0x6b, 0x93, 0xc0, 0xbd, 0xea, 0xe9, 0x86, 0x54, 0xa7, 0x68, 0x2d, 0x31, 0xd9, 0xb4, 0xda, 0xb7, 0xe6, 0xf3, 0x2c, 0xd5, 0x8f, 0x2f, 0x14, 0x8a, 0x68, 0xfb, 0xe7, 0xa8, 0x8c, 0x5a, 0xb1, 0xd8, 0x8e, 0xdc, 0xcd, 0xde, 0xb3, 0x0a, 0xb2, 0x1e, 0x5e ],
const [ 0x77, 0xa8, 0x79, 0xcf, 0xa1, 0x1d, 0x7f, 0xca, 0xc7, 0xa8, 0x28, 0x2c, 0xc3, 0x8a, 0x43, 0xdc, 0xf3, 0x76, 0x43, 0xcc, 0x90, 0x98, 0x37, 0x21, 0x3b, 0xd6, 0xfd, 0x95, 0xd9, 0x56, 0xb2, 0x19, 0xa1, 0x40, 0x6c, 0xbe, 0x73, 0xc5, 0x2c, 0xd5, 0x6c, 0x60, 0x0e, 0x55, 0xb7, 0x5b, 0xc3, 0x7e, 0xa6, 0x96, 0x41, 0xbc ],
const [ 0x45, 0xa3, 0xe6, 0xb8, 0x65, 0x27, 0xf2, 0x0b, 0x45, 0x37, 0xf5, 0xaf, 0x96, 0xcf, 0xc5, 0xad, 0x87, 0x77, 0xa2, 0xdd, 0xe6, 0xcf, 0x75, 0x11, 0x88, 0x6c, 0x55, 0x90, 0xec, 0xe2, 0x4f, 0xc6, 0x1b, 0x22, 0x67, 0x39, 0xd2, 0x07, 0xda, 0xbf, 0xe3, 0x2b, 0xa6, 0xef, 0xd9, 0xff, 0x4c, 0xd5, 0xdb, 0x1b, 0xd5, 0xea, 0xd3 ],
const [ 0x25, 0x36, 0x2a, 0x4b, 0x9d, 0x74, 0xbd, 0xe6, 0x12, 0x8c, 0x4f, 0xdc, 0x67, 0x23, 0x05, 0x90, 0x09, 0x47, 0xbc, 0x3a, 0xda, 0x9d, 0x9d, 0x31, 0x6e, 0xbc, 0xf1, 0x66, 0x7a, 0xd4, 0x36, 0x31, 0x89, 0x93, 0x72, 0x51, 0xf1, 0x49, 0xc7, 0x2e, 0x06, 0x4a, 0x48, 0x60, 0x8d, 0x94, 0x0b, 0x75, 0x74, 0xb1, 0x7f, 0xef, 0xc0, 0xdf ],
const [ 0x3e, 0xbf, 0xb0, 0x6d, 0xb8, 0xc3, 0x8d, 0x5b, 0xa0, 0x37, 0xf1, 0x36, 0x3e, 0x11, 0x85, 0x50, 0xaa, 0xd9, 0x46, 0x06, 0xe2, 0x68, 0x35, 0xa0, 0x1a, 0xf0, 0x50, 0x78, 0x53, 0x3c, 0xc2, 0x5f, 0x2f, 0x39, 0x57, 0x3c, 0x04, 0xb6, 0x32, 0xf6, 0x2f, 0x68, 0xc2, 0x94, 0xab, 0x31, 0xf2, 0xa3, 0xe2, 0xa1, 0xa0, 0xd8, 0xc2, 0xbe, 0x51 ],
const [ 0x2d, 0x52, 0x44, 0x7d, 0x12, 0x44, 0xd2, 0xeb, 0xc2, 0x86, 0x50, 0xe7, 0xb0, 0x56, 0x54, 0xba, 0xd3, 0x5b, 0x3a, 0x68, 0xee, 0xdc, 0x7f, 0x85, 0x15, 0x30, 0x6b, 0x49, 0x6d, 0x75, 0xf3, 0xe7, 0x33, 0x85, 0xdd, 0x1b, 0x00, 0x26, 0x25, 0x02, 0x4b, 0x81, 0xa0, 0x2f, 0x2f, 0xd6, 0xdf, 0xfb, 0x6e, 0x6d, 0x56, 0x1c, 0xb7, 0xd0, 0xbd, 0x7a ],
const [ 0x4c, 0xac, 0xe4, 0x22, 0xe4, 0xa0, 0x15, 0xa7, 0x54, 0x92, 0xb3, 0xb3, 0xbb, 0xfb, 0xdf, 0x37, 0x58, 0xea, 0xff, 0x4f, 0xe5, 0x04, 0xb4, 0x6a, 0x26, 0xc9, 0x0d, 0xac, 0xc1, 0x19, 0xfa, 0x90, 0x50, 0xf6, 0x03, 0xd2, 0xb5, 0x8b, 0x39, 0x8c, 0xad, 0x6d, 0x6d, 0x9f, 0xa9, 0x22, 0xa1, 0x54, 0xd9, 0xe0, 0xbc, 0x43, 0x89, 0x96, 0x82, 0x74, 0xb0 ],
const [ 0x86, 0x20, 0xb8, 0x6f, 0xbc, 0xaa, 0xce, 0x4f, 0xf3, 0xc2, 0x92, 0x1b, 0x84, 0x66, 0xdd, 0xd7, 0xba, 0xca, 0xe0, 0x7e, 0xef, 0xef, 0x69, 0x3c, 0xf1, 0x77, 0x62, 0xdc, 0xab, 0xb8, 0x9a, 0x84, 0x01, 0x0f, 0xc9, 0xa0, 0xfb, 0x76, 0xce, 0x1c, 0x26, 0x59, 0x3a, 0xd6, 0x37, 0xa6, 0x12, 0x53, 0xf2, 0x24, 0xd1, 0xb1, 0x4a, 0x05, 0xad, 0xdc, 0xca, 0xbe ],
const [ 0xd1, 0xbe, 0x3f, 0x13, 0xfe, 0xba, 0xfe, 0xfc, 0x14, 0x41, 0x4d, 0x9f, 0xb7, 0xf6, 0x93, 0xdb, 0x16, 0xdc, 0x1a, 0xe2, 0x70, 0xc5, 0xb6, 0x47, 0xd8, 0x0d, 0xa8, 0x58, 0x35, 0x87, 0xc1, 0xad, 0x8c, 0xb8, 0xcb, 0x01, 0x82, 0x43, 0x24, 0x41, 0x1c, 0xa5, 0xac, 0xe3, 0xca, 0x22, 0xe1, 0x79, 0xa4, 0xff, 0x49, 0x86, 0xf3, 0xf2, 0x11, 0x90, 0xf3, 0xd7, 0xf3 ],
const [ 0xf4, 0x99, 0xcc, 0x3f, 0x6e, 0x3c, 0xf7, 0xc3, 0x12, 0xff, 0xdf, 0xba, 0x61, 0xb1, 0x26, 0x0c, 0x37, 0x12, 0x9c, 0x1a, 0xfb, 0x39, 0x10, 0x47, 0x19, 0x33, 0x67, 0xb7, 0xb2, 0xed, 0xeb, 0x57, 0x92, 0x53, 0xe5, 0x1d, 0x62, 0xba, 0x6d, 0x91, 0x1e, 0x7b, 0x81, 0x8c, 0xca, 0xe1, 0x55, 0x3f, 0x61, 0x46, 0xea, 0x78, 0x0f, 0x78, 0xe2, 0x21, 0x9f, 0x62, 0x93, 0x09 ],
const [ 0x6d, 0xd6, 0xef, 0xd6, 0xf6, 0xca, 0xa6, 0x3b, 0x72, 0x9a, 0xa8, 0x18, 0x6e, 0x30, 0x8b, 0xc1, 0xbd, 0xa0, 0x63, 0x07, 0xc0, 0x5a, 0x2c, 0x0a, 0xe5, 0xa3, 0x68, 0x4e, 0x6e, 0x46, 0x08, 0x11, 0x74, 0x86, 0x90, 0xdc, 0x2b, 0x58, 0x77, 0x59, 0x67, 0xcf, 0xcc, 0x64, 0x5f, 0xd8, 0x20, 0x64, 0xb1, 0x27, 0x9f, 0xdc, 0xa7, 0x71, 0x80, 0x3d, 0xb9, 0xdc, 0xa0, 0xff, 0x53 ],
const [ 0x65, 0x11, 0xa2, 0x24, 0x2d, 0xdb, 0x27, 0x31, 0x78, 0xe1, 0x9a, 0x82, 0xc5, 0x7c, 0x85, 0xcb, 0x05, 0xa6, 0x88, 0x7f, 0xf2, 0x01, 0x4c, 0xf1, 0xa3, 0x1c, 0xb9, 0xba, 0x5d, 0xf1, 0x69, 0x5a, 0xad, 0xb2, 0x5c, 0x22, 0xb3, 0xc5, 0xed, 0x51, 0xc1, 0x0d, 0x04, 0x7d, 0x25, 0x6b, 0x8e, 0x34, 0x42, 0x84, 0x2a, 0xe4, 0xe6, 0xc5, 0x25, 0xf8, 0xd7, 0xa5, 0xa9, 0x44, 0xaf, 0x2a ],
const [ 0xe2, 0xf7, 0x6e, 0x97, 0x60, 0x6a, 0x87, 0x2e, 0x31, 0x74, 0x39, 0xf1, 0xa0, 0x3f, 0xcd, 0x92, 0xe6, 0x32, 0xe5, 0xbd, 0x4e, 0x7c, 0xbc, 0x4e, 0x97, 0xf1, 0xaf, 0xc1, 0x9a, 0x16, 0xfd, 0xe9, 0x2d, 0x77, 0xcb, 0xe5, 0x46, 0x41, 0x6b, 0x51, 0x64, 0x0c, 0xdd, 0xb9, 0x2a, 0xf9, 0x96, 0x53, 0x4d, 0xfd, 0x81, 0xed, 0xb1, 0x7c, 0x44, 0x24, 0xcf, 0x1a, 0xc4, 0xd7, 0x5a, 0xce, 0xeb ],
const [ 0x5a, 0x86, 0xb7, 0x37, 0xea, 0xea, 0x8e, 0xe9, 0x76, 0xa0, 0xa2, 0x4d, 0xa6, 0x3e, 0x7e, 0xd7, 0xee, 0xfa, 0xd1, 0x8a, 0x10, 0x1c, 0x12, 0x11, 0xe2, 0xb3, 0x65, 0x0c, 0x51, 0x87, 0xc2, 0xa8, 0xa6, 0x50, 0x54, 0x72, 0x08, 0x25, 0x1f, 0x6d, 0x42, 0x37, 0xe6, 0x61, 0xc7, 0xbf, 0x4c, 0x77, 0xf3, 0x35, 0x39, 0x03, 0x94, 0xc3, 0x7f, 0xa1, 0xa9, 0xf9, 0xbe, 0x83, 0x6a, 0xc2, 0x85, 0x09 ],
];

const sha256_short_mds = const [
'e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855',
'28969cdfa74a12c82f3bad960b0b000aca2ac329deea5c2328ebc6f2ba9802c1',
'5ca7133fa735326081558ac312c620eeca9970d1e70a4b95533d956f072d1f98',
'dff2e73091f6c05e528896c4c831b9448653dc2ff043528f6769437bc7b975c2',
'b16aa56be3880d18cd41e68384cf1ec8c17680c45a02b1575dc1518923ae8b0e',
'f0887fe961c9cd3beab957e8222494abb969b1ce4c6557976df8b0f6d20e9166',
'eca0a060b489636225b4fa64d267dabbe44273067ac679f20820bddc6b6a90ac',
'3fd877e27450e6bbd5d74bb82f9870c64c66e109418baa8e6bbcff355e287926',
'963bb88f27f512777aab6c8b1a02c70ec0ad651d428f870036e1917120fb48bf',
'078da3d77ed43bd3037a433fd0341855023793f9afd08b4b08ea1e5597ceef20',
'73d6fad1caaa75b43b21733561fd3958bdc555194a037c2addec19dc2d7a52bd',
'044cef802901932e46dc46b2545e6c99c0fc323a0ed99b081bda4216857f38ac',
'fe56287cd657e4afc50dba7a3a54c2a6324b886becdcd1fae473b769e551a09b',
'af53430466715e99a602fc9f5945719b04dd24267e6a98471f7a7869bd3b4313',
'd189498a3463b18e846b8ab1b41583b0b7efc789dad8a7fb885bbf8fb5b45c5c',
'dcbaf335360de853b9cddfdafb90fa75567d0d3d58af8db9d764113aef570125',
'80c25ec1600587e7f28b18b1b18e3cdc89928e39cab3bc25e4d4a4c139bcedc4',
'd5c30315f72ed05fe519a1bf75ab5fd0ffec5ac1acb0daf66b6b769598594509',
'32c38c54189f2357e96bd77eb00c2b9c341ebebacc2945f97804f59a93238288',
'9b5b37816de8fcdf3ec10b745428708df8f391c550ea6746b2cafe019c2b6ace',
'6dd52b0d8b48cc8146cebd0216fbf5f6ef7eeafc0ff2ff9d1422d6345555a142',
'44d34809fc60d1fcafa7f37b794d1d3a765dd0d23194ebbe340f013f0c39b613',
'9df5c16a3f580406f07d96149303d8c408869b32053b726cf3defd241e484957',
'672b54e43f41ee77584bdf8bf854d97b6252c918f7ea2d26bc4097ea53a88f10',
'feeb4b2b59fec8fdb1e55194a493d8c871757b5723675e93d3ac034b380b7fc9',
'76e3acbc718836f2df8ad2d0d2d76f0cfa5fea0986be918f10bcee730df441b9',
'6733809c73e53666c735b3bd3daf87ebc77c72756150a616a194108d71231272',
'0e6e3c143c3a5f7f38505ed6adc9b48c18edf6dedf11635f6e8f9ac73c39fe9e',
'ffb4fc03e054f8ecbc31470fc023bedcd4a406b9dd56c71da1b660dcc4842c65',
'c644612cd326b38b1c6813b1daded34448805aef317c35f548dfb4a0d74b8106',
'c0e29eeeb0d3a7707947e623cdc7d1899adc70dd7861205ea5e5813954fb7957',
'a4139b74b102cf1e2fce229a6cd84c87501f50afa4c80feacf7d8cf5ed94f042',
'4f44c1c7fbebb6f9601829f3897bfd650c56fa07844be76489076356ac1886a4',
'b31ad3cd02b10db282b3576c059b746fb24ca6f09fef69402dc90ece7421cbb7',
'1c38bf6bbfd32292d67d1d651fd9d5b623b6ec1e854406223f51d0df46968712',
'c2684c0dbb85c232b6da4fb5147dd0624429ec7e657991edd95eda37a587269e',
'bf9d5e5b5393053f055b380baed7e792ae85ad37c0ada5fd4519542ccc461cf3',
'd1f8bd684001ac5a4b67bbf79f87de524d2da99ac014dec3e4187728f4557471',
'49ba38db85c2796f85ffd57dd5ec337007414528ae33935b102d16a6b91ba6c1',
'725e6f8d888ebaf908b7692259ab8839c3248edd22ca115bb13e025808654700',
'32caef024f84e97c30b4a7b9d04b678b3d8a6eb2259dff5b7f7c011f090845f8',
'4bb33e7c6916e08a9b3ed6bcef790aaaee0dcf2e7a01afb056182dea2dad7d63',
'3ac7ac6bed82fdc8cd15b746f0ee7489158192c238f371c1883c9fe90b3e2831',
'bfce809534eefe871273964d32f091fe756c71a7f512ef5f2300bcd57f699e74',
'1d26f3e04f89b4eaa9dbed9231bb051eef2e8311ad26fe53d0bf0b821eaf7567',
'0ffeb644a49e787ccc6970fe29705a4f4c2bfcfe7d19741c158333ff6982cc9c',
'd048ee1524014adf9a56e60a388277de194c694cc787fc5a1b554ea9f07abfdf',
'50dbf40066f8d270484ee2ef6632282dfa300a85a8530eceeb0e04275e1c1efd',
'7c5d14ed83dab875ac25ce7feed6ef837d58e79dc601fb3c1fca48d4464e8b83',
'7d53eccd03da37bf58c1962a8f0f708a5c5c447f6a7e9e26137c169d5bdd82e4',
'99dc772e91ea02d9e421d552d61901016b9fd4ad2df4a8212c1ec5ba13893ab2',
'cefdae1a3d75e792e8698d5e71f177cc761314e9ad5df9602c6e60ae65c4c267',
'c99d64fa4dadd4bc8a389531c68b4590c6df0b9099c4d583bc00889fb7b98008',
'4d12a849047c6acd4b2eee6be35fa9051b02d21d50d419543008c1d82c427072',
'f8e4ccab6c979229f6066cc0cb0cfa81bb21447c16c68773be7e558e9f9d798d',
'6595a2ef537a69ba8583dfbf7f5bec0ab1f93ce4c8ee1916eff44a93af5749c4',
'cfb88d6faf2de3a69d36195acec2e255e2af2b7d933997f348e09f6ce5758360',
'4d54b2d284a6794581224e08f675541c8feab6eefa3ac1cfe5da4e03e62f72e4',
'dba490256c9720c54c612a5bd1ef573cd51dc12b3e7bd8c6db2eabe0aacb846b',
'02804978eba6e1de65afdbc6a6091ed6b1ecee51e8bff40646a251de6678b7ef',
'0b66c8b4fefebc8dc7da0bbedc1114f228aa63c37d5c30e91ab500f3eadfcec5',
'c464a7bf6d180de4f744bb2fe5dc27a3f681334ffd54a9814650e60260a478e3',
'd6859c0b5a0b66376a24f56b2ab104286ed0078634ba19112ace0d6d60a9c1ae',
'18041bd4665083001fba8c5411d2d748e8abbfdcdfd9218cb02b68a78e7d4c23',
'42e61e174fbb3897d6dd6cef3dd2802fe67b331953b06114a65c772859dfc1aa',
];
