// Copyright (c) 2014, the Dart project authors.  Please see the AUTHORS file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library pub_tests;

import 'package:pub/src/exit_codes.dart' as exit_codes;

import '../../test_pub.dart';

main() {
  integration('fails if there are extra arguments', () {
    schedulePub(args: ["cache", "add", "foo", "bar", "baz"],
        error: """
            Unexpected arguments "bar" and "baz".
            
            Usage: pub cache add <package> [--version <constraint>] [--all]
            -h, --help       Print this usage information.
                --all        Install all matching versions.
            -v, --version    Version constraint.

            Run "pub help" to see global options.
            See http://dartlang.org/tools/pub/cmd/pub-cache.html for detailed documentation.
            """,
        exitCode: exit_codes.USAGE);
  });
}
