// Copyright (c) 2013, the Dart project authors.  Please see the AUTHORS d.file
// for details. All rights reserved. Use of this source code is governed by a
// BSD-style license that can be found in the LICENSE file.

library pub_tests;

import '../descriptor.dart' as d;
import '../test_pub.dart';
import 'utils.dart';

main() {
  integration("gets first if a dependency is not in the lock file", () {
    d.dir("foo", [
      d.libPubspec("foo", "0.0.1"),
      d.libDir("foo")
    ]).create();

    // Create a lock file without "foo".
    d.dir(appPath, [
      d.appPubspec()
    ]).create();
    pubGet();

    // Add it to the pubspec.
    d.dir(appPath, [
      d.appPubspec({
        "foo": {"path": "../foo"}
      })
    ]).create();

    pubGet();
    pubServe();
    requestShouldSucceed("packages/foo/foo.dart", 'main() => "foo";');
    endPubServe();
  });
}
