## 1.3.4

* No longer say that stack chains aren't supported on dart2js now that
  [sdk#15171][] is fixed. Note that this fix only applies to Dart 1.12.

[sdk#15171]: https://github.com/dart-lang/sdk/issues/15171

## 1.3.3

* When a `null` stack trace is passed to a completer or stream controller in
  nested `Chain.capture()` blocks, substitute the inner block's chain rather
  than the outer block's.

* Add support for empty chains and chains of empty traces to `Chain.parse()`.

* Don't crash when parsing stack traces from Dart VM stack overflows.

## 1.3.2

* Don't crash when running `Trace.terse` on empty stack traces.

## 1.3.1

* Support more types of JavaScriptCore stack frames.

## 1.3.0

* Support stack traces generated by JavaScriptCore. They can be explicitly
  parsed via `new Trace.parseJSCore` and `new Frame.parseJSCore`.

## 1.2.4

* Fix a type annotation in `LazyTrace`.

## 1.2.3

* Fix a crash in `Chain.parse`.

## 1.2.2

* Don't print the first folded frame of terse stack traces. This frame
  is always just an internal isolate message handler anyway. This
  improves the readability of stack traces, especially in stack chains.

* Remove the line numbers and specific files in all terse folded frames, not
  just those from core libraries.

* Make padding consistent across all stack traces for `Chain.toString()`.

## 1.2.1

* Add `terse` to `LazyTrace.foldFrames()`.

* Further improve stack chains when using the VM's async/await implementation.

## 1.2.0

* Add a `terse` argument to `Trace.foldFrames()` and `Chain.foldFrames()`. This
  allows them to inherit the behavior of `Trace.terse` and `Chain.terse` without
  having to duplicate the logic.

## 1.1.3

* Produce nicer-looking stack chains when using the VM's async/await
  implementation.

## 1.1.2

* Support VM frames without line *or* column numbers, which async/await programs
  occasionally generate.

* Replace `<<anonymous closure>_async_body>` in VM frames' members with the
  terser `<async>`.

## 1.1.1

* Widen the SDK constraint to include 1.7.0-dev.4.0.

## 1.1.0

* Unify the parsing of Safari and Firefox stack traces. This fixes an error in
  Firefox trace parsing.

* Deprecate `Trace.parseSafari6_0`, `Trace.parseSafari6_1`,
  `Frame.parseSafari6_0`, and `Frame.parseSafari6_1`.

* Add `Frame.parseSafari`.

## 1.0.3

* Use `Zone.errorCallback` to attach stack chains to all errors without the need
  for `Chain.track`, which is now deprecated.

## 1.0.2

* Remove a workaround for [issue 17083][].

[issue 17083]: http://code.google.com/p/dart/issues/detail?id=17083

## 1.0.1

* Synchronous errors in the [Chain.capture] callback are now handled correctly.

## 1.0.0

* No API changes, just declared stable.

## 0.9.3+2

* Update the dependency on path.

* Improve the formatting of library URIs in stack traces.

## 0.9.3+1

* If an error is thrown in `Chain.capture`'s `onError` handler, that error is
  handled by the parent zone. This matches the behavior of `runZoned` in
  `dart:async`.

## 0.9.3

* Add a `Chain.foldFrames` method that parallels `Trace.foldFrames`.

* Record anonymous method frames in IE10 as "<fn>".
