# ContextSDK Unity Plugin

The ContextSDK Unity Plugin allows you to use the full feature set of ContextSDK in your Unity games.

## Installation

1. Drag the ContextSDK.xcframework into your `Assets/Plugins/iOS` folder.
2. Drag the `ContextSDKBinding.cs` next to it.
3. At a place running before any ContextSDK access initialize the SDK:

```
ContextSDKBinding.SetupWithAPIBackend("YOUR_LICENSE_KEY_HERE");
```

4. Finally you're ready to use ContextSDK:

```
ContextSDKBinding.Optimize("your_flow", delegate (Context context) {
    // Show your prompt here and log the outcome.
    context.Log(Outcome.Positive);
});
```

For more information check out the full docs at: https://docs.contextsdk.com/basics/getting-started#unity
