/*
 * Decompiled with CFR 0.152.
 */
package io.flutter.embedding.engine.image;

import android.graphics.Bitmap;
import android.graphics.ColorSpace;
import android.graphics.ImageDecoder;
import android.util.Size;
import androidx.annotation.RequiresApi;
import io.flutter.Log;
import io.flutter.embedding.engine.image.FlutterImageDecoder;
import io.flutter.embedding.engine.image.ImageDecoder;
import io.flutter.embedding.engine.image.Metadata;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(value=28)
class ImageDecoderDefaultImpl
implements ImageDecoder {
    private static final String TAG = "FlutterImageDecoderImplDefault";
    private final FlutterImageDecoder.HeaderListener listener;

    public ImageDecoderDefaultImpl(FlutterImageDecoder.HeaderListener listener) {
        this.listener = listener;
    }

    @Override
    public Bitmap decodeImage(ByteBuffer buffer, Metadata metadata) {
        ImageDecoder.Source source = android.graphics.ImageDecoder.createSource((ByteBuffer)buffer);
        try {
            return android.graphics.ImageDecoder.decodeBitmap((ImageDecoder.Source)source, (decoder, info, src) -> {
                decoder.setTargetColorSpace(ColorSpace.get((ColorSpace.Named)ColorSpace.Named.SRGB));
                decoder.setAllocator(1);
                if (this.listener != null) {
                    Size size = info.getSize();
                    this.listener.onImageHeader(size.getWidth(), size.getHeight());
                }
            });
        }
        catch (IOException e) {
            Log.e(TAG, "Failed to decode image", e);
            return null;
        }
    }
}

