/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika;

import java.lang.reflect.Type;
import ma.glasnost.orika.MappedTypePair;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.TypeFactory;

public interface MappingStrategy
extends MappedTypePair<Object, Object> {
    public Object map(Object var1, Object var2, MappingContext var3);

    public static final class Key {
        private final Class<?> rawSourceType;
        private final Type sourceType;
        private final Type destinationType;
        private final boolean destinationProvided;
        private final int hashCode;

        public Key(Class<?> rawSourceType, Type sourceType, Type destinationType, boolean destinationProvided) {
            this.rawSourceType = rawSourceType;
            this.sourceType = sourceType;
            this.destinationType = destinationType;
            this.destinationProvided = destinationProvided;
            this.hashCode = this.computeHashCode();
        }

        public Class<?> getRawSourceType() {
            return this.rawSourceType;
        }

        public Type getSourceType() {
            return this.sourceType;
        }

        public Type getDestinationType() {
            return this.destinationType;
        }

        public boolean isDestinationProvided() {
            return this.destinationProvided;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private int computeHashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.destinationProvided ? 1231 : 1237);
            result = 31 * result + (this.destinationType == null ? 0 : this.destinationType.hashCode());
            result = 31 * result + (this.rawSourceType == null ? 0 : this.rawSourceType.hashCode());
            result = 31 * result + (this.sourceType == null ? 0 : this.sourceType.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            if (this.destinationProvided != other.destinationProvided) {
                return false;
            }
            if (this.getDestinationType() == null ? other.destinationType != null : !this.destinationType.equals(other.destinationType)) {
                return false;
            }
            if (this.getRawSourceType() == null ? other.rawSourceType != null : !this.rawSourceType.equals(other.rawSourceType)) {
                return false;
            }
            return !(this.getSourceType() == null ? other.sourceType != null : !this.sourceType.equals(other.sourceType));
        }

        public String toString() {
            StringBuilder out = new StringBuilder("{");
            Class<?> srcType = this.rawSourceType == null ? this.sourceType : this.rawSourceType;
            String srcName = TypeFactory.nameOf(srcType, this.destinationType);
            String dstName = TypeFactory.nameOf(this.destinationType, srcType);
            out.append("source: ").append(srcName).append(", ").append("dest: ").append(dstName).append(", ").append("in-place:").append(this.destinationProvided).append("}");
            return out.toString();
        }
    }
}

