/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import ma.glasnost.orika.converter.BidirectionalConverter;
import ma.glasnost.orika.metadata.TypeFactory;

abstract class BuiltinBidirectionalConverter<C, D>
extends BidirectionalConverter<C, D> {
    private final String description;
    private volatile Reversed<D, C> reversed;

    public BuiltinBidirectionalConverter() {
        String srcName = TypeFactory.nameOf(this.sourceType, this.destinationType);
        String dstName = TypeFactory.nameOf(this.destinationType, this.sourceType);
        this.description = "builtin:" + this.getClass().getSimpleName() + "<" + srcName + ", " + dstName + ">";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BidirectionalConverter<D, C> reverse() {
        if (this.reversed == null) {
            BuiltinBidirectionalConverter builtinBidirectionalConverter = this;
            synchronized (builtinBidirectionalConverter) {
                if (this.reversed == null) {
                    this.reversed = new Reversed(this);
                }
            }
        }
        return this.reversed;
    }

    @Override
    public String toString() {
        return this.description;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BuiltinBidirectionalConverter that = (BuiltinBidirectionalConverter)o;
        return this.description != null ? this.description.equals(that.description) : that.description == null;
    }

    private static class Reversed<D, C>
    extends BidirectionalConverter.Reversed<D, C> {
        private final String description;

        public Reversed(BidirectionalConverter<C, D> bidi) {
            super(bidi);
            String srcName = TypeFactory.nameOf(this.getAType(), this.getBType());
            String dstName = TypeFactory.nameOf(this.getBType(), this.getAType());
            this.description = "builtin:reversed:" + bidi.getClass().getSimpleName() + "<" + srcName + ", " + dstName + ">";
        }

        @Override
        public String toString() {
            return this.description;
        }
    }
}

