/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.converter.builtin;

import ma.glasnost.orika.CustomConverter;
import ma.glasnost.orika.MappingContext;
import ma.glasnost.orika.metadata.Type;

public class WrapperToPrimitiveConverter
extends CustomConverter<Object, Object> {
    @Override
    public boolean canConvert(Type<?> sourceType, Type<?> destinationType) {
        return sourceType.isWrapperFor(destinationType);
    }

    @Override
    public Object convert(Object source, Type<? extends Object> destinationType, MappingContext context) {
        if (Character.TYPE == destinationType.getRawType()) {
            return Character.valueOf(((Character)source).charValue());
        }
        if (Byte.TYPE == destinationType.getRawType()) {
            return (byte)((Byte)source);
        }
        if (Short.TYPE == destinationType.getRawType()) {
            return (short)((Short)source);
        }
        if (Integer.TYPE == destinationType.getRawType()) {
            return (int)((Integer)source);
        }
        if (Long.TYPE == destinationType.getRawType()) {
            return (long)((Long)source);
        }
        if (Float.TYPE == destinationType.getRawType()) {
            return Float.valueOf(((Float)source).floatValue());
        }
        if (Double.TYPE == destinationType.getRawType()) {
            return (double)((Double)source);
        }
        if (Boolean.TYPE == destinationType.getRawType()) {
            return (boolean)((Boolean)source);
        }
        return null;
    }
}

