/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import ma.glasnost.orika.DefaultFieldMapper;
import ma.glasnost.orika.MappedTypePair;
import ma.glasnost.orika.Mapper;
import ma.glasnost.orika.MapperBase;
import ma.glasnost.orika.MapperFactory;
import ma.glasnost.orika.MappingException;
import ma.glasnost.orika.MappingHint;
import ma.glasnost.orika.impl.Specifications;
import ma.glasnost.orika.impl.UtilityResolver;
import ma.glasnost.orika.metadata.ClassMap;
import ma.glasnost.orika.metadata.ClassMapBuilderFactory;
import ma.glasnost.orika.metadata.FieldMap;
import ma.glasnost.orika.metadata.FieldMapBuilder;
import ma.glasnost.orika.metadata.MapperKey;
import ma.glasnost.orika.metadata.MappingDirection;
import ma.glasnost.orika.metadata.NestedElementProperty;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.metadata.Type;
import ma.glasnost.orika.metadata.TypeFactory;
import ma.glasnost.orika.property.PropertyResolver;
import ma.glasnost.orika.property.PropertyResolverStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassMapBuilder<A, B>
implements MappedTypePair<A, B> {
    private final Map<String, Property> aProperties;
    private final Map<String, Property> bProperties;
    private final Set<String> propertiesCacheA;
    private final Set<String> propertiesCacheB;
    private final Type<A> aType;
    private final Type<B> bType;
    private final Set<FieldMap> fieldsMapping;
    private final Set<MapperKey> usedMappers;
    private Mapper<A, B> customizedMapper;
    private String[] constructorA;
    private String[] constructorB;
    private final PropertyResolverStrategy propertyResolver;
    private final MapperFactory mapperFactory;
    private final DefaultFieldMapper[] defaults;
    private Boolean sourcesMappedOnNull;
    private Boolean destinationsMappedOnNull;
    private Boolean favorsExtension;
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassMapBuilder.class);
    private static volatile WeakReference<PropertyResolverStrategy> defaultPropertyResolver;

    protected ClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper ... defaults) {
        if (aType == null) {
            throw new MappingException("[aType] is required");
        }
        if (bType == null) {
            throw new MappingException("[bType] is required");
        }
        this.mapperFactory = mapperFactory;
        this.propertyResolver = propertyResolver;
        this.defaults = defaults;
        this.aProperties = propertyResolver.getProperties(aType);
        this.bProperties = propertyResolver.getProperties(bType);
        this.propertiesCacheA = new LinkedHashSet<String>();
        this.propertiesCacheB = new LinkedHashSet<String>();
        this.aType = aType;
        this.bType = bType;
        this.fieldsMapping = new LinkedHashSet<FieldMap>();
        this.usedMappers = new LinkedHashSet<MapperKey>();
    }

    protected Map<String, Property> getPropertyExpressions(Type<?> type) {
        PropertyResolverStrategy propertyResolver = this.getPropertyResolver();
        HashMap<String, Property> properties = new HashMap<String, Property>();
        LinkedHashMap<String, Property> toProcess = new LinkedHashMap<String, Property>(propertyResolver.getProperties(type));
        if (type.isMap() || type.isList() || type.isArray()) {
            Property selfReferenceProperty = new Property.Builder().name("").getter("").setter(" = %s").type(TypeFactory.valueOf(type)).build((PropertyResolver)propertyResolver);
            toProcess.put("", selfReferenceProperty);
        }
        while (!toProcess.isEmpty()) {
            Map.Entry<String, Property> entry = toProcess.entrySet().iterator().next();
            if (!entry.getKey().equals("class")) {
                Property owningProperty = entry.getValue();
                Type<?> propertyType = owningProperty.getType();
                if (!propertyType.isImmutable()) {
                    String key;
                    NestedElementProperty elementProp;
                    Map<String, Property> valueProperties;
                    Map<String, Property> props = propertyResolver.getProperties(propertyType);
                    if (propertyType.isMap()) {
                        valueProperties = this.getPropertyExpressions(propertyType.getNestedType(1));
                        for (Map.Entry<String, Property> prop : valueProperties.entrySet()) {
                            elementProp = new NestedElementProperty(entry.getValue(), prop.getValue(), propertyResolver);
                            key = entry.getKey() + "{" + prop.getKey() + "}";
                            toProcess.put(key, elementProp);
                        }
                    } else if (propertyType.isList()) {
                        valueProperties = this.getPropertyExpressions(propertyType.getNestedType(0));
                        for (Map.Entry<String, Property> prop : valueProperties.entrySet()) {
                            elementProp = new NestedElementProperty(owningProperty, prop.getValue(), propertyResolver);
                            key = entry.getKey() + "{" + prop.getValue().getExpression() + "}";
                            toProcess.put(key, elementProp);
                        }
                    } else if (propertyType.isArray()) {
                        valueProperties = this.getPropertyExpressions(propertyType.getComponentType());
                        for (Map.Entry<String, Property> prop : valueProperties.entrySet()) {
                            elementProp = new NestedElementProperty(entry.getValue(), prop.getValue(), propertyResolver);
                            key = entry.getKey() + "{" + prop.getKey() + "}";
                            toProcess.put(key, elementProp);
                        }
                    } else if (!props.isEmpty()) {
                        for (Map.Entry<String, Property> property : props.entrySet()) {
                            if (property.getKey().equals("class")) continue;
                            String expression = entry.getKey() + "." + property.getKey();
                            toProcess.put(expression, this.resolveProperty(type, expression));
                        }
                    } else {
                        properties.put(entry.getKey(), this.resolveProperty(type, entry.getKey()));
                    }
                } else {
                    properties.put(entry.getKey(), this.resolveProperty(type, entry.getKey()));
                }
            }
            toProcess.remove(entry.getKey());
        }
        return properties;
    }

    @Deprecated
    private ClassMapBuilder(Type<A> aType, Type<B> bType) {
        this(aType, bType, null, ClassMapBuilder.getDefaultPropertyResolver(), new DefaultFieldMapper[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static PropertyResolverStrategy getDefaultPropertyResolver() {
        if (defaultPropertyResolver != null && defaultPropertyResolver.get() != null) return (PropertyResolverStrategy)defaultPropertyResolver.get();
        Class<ClassMapBuilder> clazz = ClassMapBuilder.class;
        synchronized (ClassMapBuilder.class) {
            if (defaultPropertyResolver != null && defaultPropertyResolver.get() != null) return (PropertyResolverStrategy)defaultPropertyResolver.get();
            defaultPropertyResolver = new WeakReference<PropertyResolverStrategy>(UtilityResolver.getDefaultPropertyResolverStrategy());
            // ** MonitorExit[var0] (shouldn't be in output)
            return (PropertyResolverStrategy)defaultPropertyResolver.get();
        }
    }

    public ClassMapBuilder<A, B> field(String fieldNameA, String fieldNameB) {
        return this.fieldMap(fieldNameA, fieldNameB).add();
    }

    public ClassMapBuilder<A, B> fieldAToB(String fieldNameA, String fieldNameB) {
        return this.fieldMap(fieldNameA, fieldNameB).aToB().add();
    }

    public ClassMapBuilder<A, B> fieldBToA(String fieldNameB, String fieldNameA) {
        return this.fieldMap(fieldNameA, fieldNameB).bToA().add();
    }

    public FieldMapBuilder<A, B> fieldMap(String a) {
        return this.fieldMap(a, a);
    }

    public FieldMapBuilder<A, B> fieldMap(String a, boolean byDefault) {
        return this.fieldMap(a, a, byDefault);
    }

    public FieldMapBuilder<A, B> fieldMap(String fieldNameA, String fieldNameB) {
        return this.fieldMap(fieldNameA, fieldNameB, false);
    }

    public FieldMapBuilder<A, B> fieldMap(String fieldNameA, String fieldNameB, boolean byDefault) {
        try {
            FieldMapBuilder fieldMapBuilder = new FieldMapBuilder(this, fieldNameA, fieldNameB, byDefault, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
            return fieldMapBuilder;
        }
        catch (MappingException e) {
            String msg = this.getClass().getSimpleName() + ".map(" + this.aType + ", " + this.bType + ").field('" + fieldNameA + "', '" + fieldNameB + "'): Error: " + e.getLocalizedMessage();
            throw new MappingException(msg, e);
        }
    }

    public FieldMapBuilder<A, B> fieldMap(Property fieldA, Property fieldB, boolean byDefault) {
        return new FieldMapBuilder(this, fieldA, fieldB, byDefault, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
    }

    public FieldMapBuilder<A, B> fieldMap(String fieldNameA, Property fieldB, boolean byDefault) {
        return new FieldMapBuilder(this, this.resolvePropertyForA(fieldNameA), fieldB, byDefault, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
    }

    public FieldMapBuilder<A, B> fieldMap(Property fieldA, String fieldNameB, boolean byDefault) {
        return new FieldMapBuilder(this, fieldA, this.resolvePropertyForB(fieldNameB), byDefault, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
    }

    public FieldMapBuilder<A, B> fieldMap(Property.Builder fieldA, Property.Builder fieldB, boolean byDefault) {
        return new FieldMapBuilder(this, fieldA.build((PropertyResolver)this.propertyResolver), fieldB.build((PropertyResolver)this.propertyResolver), byDefault, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
    }

    public FieldMapBuilder<A, B> fieldMap(String fieldNameA, Property.Builder fieldB, boolean byDefault) {
        return new FieldMapBuilder(this, this.resolvePropertyForA(fieldNameA), fieldB.build((PropertyResolver)this.propertyResolver), byDefault, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
    }

    public FieldMapBuilder<A, B> fieldMap(Property.Builder fieldA, String fieldNameB, boolean byDefault) {
        return new FieldMapBuilder(this, fieldA.build((PropertyResolver)this.propertyResolver), this.resolvePropertyForB(fieldNameB), byDefault, this.sourcesMappedOnNull, this.destinationsMappedOnNull);
    }

    public ClassMapBuilder<A, B> field(Property fieldA, Property fieldB) {
        return this.fieldMap(fieldA, fieldB, false).add();
    }

    public ClassMapBuilder<A, B> field(String fieldNameA, Property fieldB) {
        return this.fieldMap(fieldNameA, fieldB, false).add();
    }

    public ClassMapBuilder<A, B> field(Property fieldA, String fieldNameB) {
        return this.fieldMap(fieldA, fieldNameB, false).add();
    }

    public ClassMapBuilder<A, B> field(Property.Builder fieldA, Property.Builder fieldB) {
        return this.fieldMap(fieldA, fieldB, false).add();
    }

    public ClassMapBuilder<A, B> field(String fieldNameA, Property.Builder fieldB) {
        return this.fieldMap(fieldNameA, fieldB, false).add();
    }

    public ClassMapBuilder<A, B> field(Property.Builder fieldA, String fieldNameB) {
        return this.fieldMap(fieldA, fieldNameB, false).add();
    }

    public ClassMapBuilder<A, B> exclude(String fieldName) {
        if (this.propertyResolver.existsProperty(this.getAType(), fieldName) && this.propertyResolver.existsProperty(this.getBType(), fieldName)) {
            return this.fieldMap(fieldName).exclude().add();
        }
        return this;
    }

    @Deprecated
    public final ClassMapBuilder<A, B> customize(MapperBase<A, B> legacyCustomizedMapper) {
        this.customize(new MapperBase.MapperBaseAdapter<A, B>(legacyCustomizedMapper));
        return this;
    }

    public ClassMapBuilder<A, B> customize(Mapper<A, B> customizedMapper) {
        this.customizedMapper = customizedMapper;
        return this;
    }

    public <X, Y> ClassMapBuilder<A, B> use(Class<?> aParentClass, Class<?> bParentClass) {
        Type<?> aParentType = TypeFactory.valueOf(aParentClass);
        Type<?> bParentType = TypeFactory.valueOf(bParentClass);
        return this.use(aParentType, bParentType);
    }

    public <X, Y> ClassMapBuilder<A, B> use(Type<?> aParentType, Type<?> bParentType) {
        if (!aParentType.isAssignableFrom(this.aType)) {
            throw new MappingException(this.aType.getSimpleName() + " is not a subclass of " + aParentType.getSimpleName());
        }
        if (!bParentType.isAssignableFrom(this.bType)) {
            throw new MappingException(this.bType.getSimpleName() + " is not a subclass of " + bParentType.getSimpleName());
        }
        this.usedMappers.add(new MapperKey(aParentType, bParentType));
        return this;
    }

    public ClassMapBuilder<A, B> byDefault(DefaultFieldMapper ... withDefaults) {
        return this.byDefault(MappingDirection.BIDIRECTIONAL, withDefaults);
    }

    public ClassMapBuilder<A, B> byDefault(MappingDirection direction, DefaultFieldMapper ... withDefaults) {
        DefaultFieldMapper[] defaults = withDefaults.length == 0 ? this.getDefaultFieldMappers() : withDefaults;
        for (String propertyName : this.getPropertiesForTypeA()) {
            if (this.getMappedPropertiesForTypeA().contains(propertyName)) continue;
            if (this.getPropertiesForTypeB().contains(propertyName)) {
                if (this.getMappedPropertiesForTypeB().contains(propertyName) || propertyName.equals("class")) continue;
                this.fieldMap(propertyName, true).direction(direction).add();
                continue;
            }
            Property prop = this.resolvePropertyForA(propertyName);
            for (DefaultFieldMapper defaulter : defaults) {
                String suggestion = defaulter.suggestMappedField(propertyName, prop.getType());
                if (suggestion == null || !this.getPropertiesForTypeB().contains(suggestion) || this.getMappedPropertiesForTypeB().contains(suggestion)) continue;
                this.fieldMap(propertyName, suggestion, true).direction(direction).add();
            }
        }
        return this;
    }

    @Deprecated
    public final ClassMapBuilder<A, B> byDefault(MappingHint hint0, MappingHint ... mappingHints) {
        MappingHint[] hints = new MappingHint[mappingHints.length + 1];
        hints[0] = hint0;
        if (mappingHints.length > 0) {
            System.arraycopy(mappingHints, 0, hints, 1, mappingHints.length);
        }
        return this.byDefault(hints);
    }

    @Deprecated
    public final ClassMapBuilder<A, B> byDefault(MappingHint[] mappingHints) {
        for (String propertyName : this.aProperties.keySet()) {
            if (this.propertiesCacheA.contains(propertyName)) continue;
            if (this.bProperties.containsKey(propertyName)) {
                if (this.propertiesCacheB.contains(propertyName) || propertyName.equals("class")) continue;
                this.fieldMap(propertyName).add();
                continue;
            }
            Property prop = this.aProperties.get(propertyName);
            for (MappingHint hint : mappingHints) {
                String suggestion = hint.suggestMappedField(propertyName, (Class<?>)prop.getType().getRawType());
                if (suggestion == null || !this.bProperties.containsKey(suggestion) || this.propertiesCacheB.contains(suggestion)) continue;
                this.fieldMap(propertyName, suggestion).add();
            }
        }
        return this;
    }

    public ClassMap<A, B> toClassMap() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("ClassMap created:\n\t" + this.describeClassMap());
        }
        return new ClassMap<A, B>(this.aType, this.bType, this.fieldsMapping, this.customizedMapper, this.usedMappers, this.constructorA, this.constructorB, this.sourcesMappedOnNull, this.destinationsMappedOnNull, this.favorsExtension);
    }

    public ClassMapBuilder<A, B> mapNulls(boolean destinationsMappedOnNull) {
        this.destinationsMappedOnNull = destinationsMappedOnNull;
        return this;
    }

    public ClassMapBuilder<A, B> mapNullsInReverse(boolean sourcesMappedOnNull) {
        this.sourcesMappedOnNull = sourcesMappedOnNull;
        return this;
    }

    public ClassMapBuilder<A, B> favorExtension(boolean favorsExtension) {
        this.favorsExtension = favorsExtension;
        return this;
    }

    public void register() {
        if (this.mapperFactory == null) {
            throw new IllegalStateException("register() is not supported from deprecated static ClassMapBuilder.map(..) instances");
        }
        this.mapperFactory.registerClassMap(this);
    }

    protected String describeClassMap() {
        StringBuilder output = new StringBuilder();
        output.append(this.getClass().getSimpleName() + ".map(" + this.aType + ", " + this.bType + ")");
        for (FieldMap f : this.fieldsMapping) {
            if (f.isExcluded()) {
                output.append("\n\t .exclude('" + f.getSourceName() + "')");
                continue;
            }
            String dir = "";
            if (f.getDirection() == MappingDirection.A_TO_B) {
                dir = "AToB";
            } else if (f.getDirection() == MappingDirection.B_TO_A) {
                dir = "BToA";
            }
            output.append("\n\t .field" + dir + "( " + f.getSource() + ", " + f.getDestination() + " )");
        }
        if (this.constructorA != null) {
            output.append("\n\t .constructorA(" + Arrays.toString(this.constructorA) + ")");
        }
        if (this.constructorB != null) {
            output.append("\n\t .constructorB(" + Arrays.toString(this.constructorB) + ")");
        }
        return output.toString();
    }

    public static final <A, B> ClassMapBuilder<A, B> map(Class<A> aType, Class<B> bType) {
        return new ClassMapBuilder<A, B>(TypeFactory.valueOf(aType), TypeFactory.valueOf(bType));
    }

    public static final <A, B> ClassMapBuilder<A, B> map(Type<A> aType, Type<B> bType) {
        return new ClassMapBuilder<A, B>(aType, bType);
    }

    public static final <A, B> ClassMapBuilder<A, B> map(Class<A> aType, Type<B> bType) {
        return new ClassMapBuilder<A, B>(TypeFactory.valueOf(aType), bType);
    }

    public static final <A, B> ClassMapBuilder<A, B> map(Type<A> aType, Class<B> bType) {
        return new ClassMapBuilder<A, B>(aType, TypeFactory.valueOf(bType));
    }

    protected boolean isNestedPropertyExpression(String expression) {
        return expression.indexOf(46) != -1;
    }

    protected Property resolveProperty(java.lang.reflect.Type type, String expr) {
        return this.propertyResolver.getProperty(type, expr);
    }

    protected Property resolvePropertyForA(String expr) {
        return this.resolveProperty(this.aType, expr);
    }

    protected Property resolvePropertyForB(String expr) {
        return this.resolveProperty(this.bType, expr);
    }

    @Override
    public Type<A> getAType() {
        return this.aType;
    }

    @Override
    public Type<B> getBType() {
        return this.bType;
    }

    protected void addFieldMap(FieldMap fieldMap) {
        this.getMappedFields().add(fieldMap);
        this.getMappedPropertiesForTypeA().add(fieldMap.getSourceExpression());
        this.getMappedPropertiesForTypeB().add(fieldMap.getDestinationExpression());
        if (fieldMap.is(Specifications.aManyToOneElementMap())) {
            this.getMappedPropertiesForTypeA().add(fieldMap.getSource().getContainer().getExpression());
        } else if (fieldMap.is(Specifications.aOneToManyElementMap())) {
            this.getMappedPropertiesForTypeB().add(fieldMap.getDestination().getContainer().getExpression());
        } else if (fieldMap.is(Specifications.aMultiOccurrenceElementMap())) {
            this.getMappedPropertiesForTypeA().add(fieldMap.getSource().getContainer().getExpression());
            this.getMappedPropertiesForTypeB().add(fieldMap.getDestination().getContainer().getExpression());
        }
    }

    protected Set<String> getMappedPropertiesForTypeA() {
        return this.propertiesCacheA;
    }

    protected Set<String> getMappedPropertiesForTypeB() {
        return this.propertiesCacheB;
    }

    protected Set<FieldMap> getMappedFields() {
        return this.fieldsMapping;
    }

    protected Set<String> getPropertiesForTypeA() {
        return this.aProperties.keySet();
    }

    protected Set<String> getPropertiesForTypeB() {
        return this.bProperties.keySet();
    }

    protected DefaultFieldMapper[] getDefaultFieldMappers() {
        return this.defaults;
    }

    protected PropertyResolverStrategy getPropertyResolver() {
        return this.propertyResolver;
    }

    public ClassMapBuilder<A, B> constructorA(String ... args) {
        this.constructorA = (String[])args.clone();
        return this;
    }

    public ClassMapBuilder<A, B> constructorB(String ... args) {
        this.constructorB = (String[])args.clone();
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getAType() + ", " + this.getBType() + "]";
    }

    public static class Factory
    extends ClassMapBuilderFactory {
        @Override
        protected <A, B> ClassMapBuilder<A, B> newClassMapBuilder(Type<A> aType, Type<B> bType, MapperFactory mapperFactory, PropertyResolverStrategy propertyResolver, DefaultFieldMapper[] defaults) {
            return new ClassMapBuilder<A, B>(aType, bType, mapperFactory, propertyResolver, defaults);
        }
    }
}

