/*
 * Decompiled with CFR 0.152.
 */
package ma.glasnost.orika.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import ma.glasnost.orika.metadata.Property;
import ma.glasnost.orika.property.PropertyResolver;

public class NestedProperty
extends Property {
    private final Property[] path;
    private final Property tail;

    public NestedProperty(String expression, Property property, Property[] path) {
        super(expression, property.getName(), property.getGetter(), property.getSetter(), property.getType(), property.getElementType(), property.getContainer());
        this.path = NestedProperty.collapse(property.getPath(), path);
        this.tail = property;
    }

    private static Property[] collapse(Property[] primaryPath, Property[] path) {
        ArrayList<Property> collapsed = new ArrayList<Property>();
        collapsed.addAll(Arrays.asList(path));
        collapsed.addAll(Arrays.asList(primaryPath));
        for (int i = 0; i < collapsed.size(); ++i) {
            Property p = (Property)collapsed.get(i);
            if (!(p instanceof NestedProperty)) continue;
            collapsed.remove(i);
            for (Property element : p.getPath()) {
                collapsed.add(i++, element);
            }
            Property tail = ((NestedProperty)p).tail;
            collapsed.add(i, tail);
        }
        return collapsed.toArray(path);
    }

    @Override
    public NestedProperty copy() {
        Property[] copyPath = new Property[this.path.length];
        int count = this.path.length;
        for (int i = 0; i < count; ++i) {
            copyPath[i] = this.path[i].copy();
        }
        NestedProperty copy = new NestedProperty(this.getExpression(), super.copy(), copyPath);
        return copy;
    }

    @Override
    public Property[] getPath() {
        return this.path;
    }

    @Override
    public boolean hasPath() {
        return true;
    }

    @Override
    public boolean equals(Object other) {
        return super.equals(other);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isListElement() {
        return this.tail.isListElement();
    }

    @Override
    public boolean isArrayElement() {
        return this.tail.isArrayElement();
    }

    @Override
    public boolean isMapKey() {
        return this.tail.isMapKey();
    }

    static class Builder
    extends Property.Builder {
        private Property.Builder parent;

        Builder(Property.Builder parent, String name) {
            super(null, name);
            this.parent = parent;
        }

        @Override
        public Property build(PropertyResolver propertyResolver) {
            Property[] path;
            Property parentProperty = this.parent.build(propertyResolver);
            if (parentProperty instanceof NestedProperty) {
                path = ((NestedProperty)parentProperty).getPath();
                System.arraycopy(path, 0, path, 0, path.length + 1);
                path[path.length - 1] = parentProperty;
            } else {
                path = new Property[]{parentProperty};
            }
            this.owningType(parentProperty.getType());
            Property p = super.build(propertyResolver);
            return new NestedProperty("", p, path);
        }
    }
}

