/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gantt.jsonutil;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.effectivecompany.app.sst.SoGanttData;
import de.effectivecompany.app.sst.SoGanttDataset;
import de.effectivecompany.gantt.jsonutil.SoGanttDatasetAdapter;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.List;

public class SoGanttDataAdapter
implements JsonSerializer<SoGanttData> {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public JsonElement serialize(SoGanttData gantt, Type type, JsonSerializationContext jsonSerializationContext) {
        return SoGanttDataAdapter.getAsJsonObject(gantt);
    }

    public static JsonObject getAsJsonObject(SoGanttData gantt) {
        JsonObject jsonDataObject = new JsonObject();
        if (gantt != null) {
            jsonDataObject.add("datasets", (JsonElement)SoGanttDatasetAdapter.getAsJsonArray((List<SoGanttDataset>)gantt.getDatasetList()));
            jsonDataObject.add("calendars", (JsonElement)SoGanttDatasetAdapter.getAsJsonArray((List<SoGanttDataset>)gantt.getCalendarList()));
            if (gantt.getGantt_range_min() != null && gantt.getGantt_range_min().getDate() != null) {
                jsonDataObject.addProperty("min", sdf.format(gantt.getGantt_range_min().getDate()));
            }
            if (gantt.getGantt_range_max() != null && gantt.getGantt_range_max().getDate() != null) {
                jsonDataObject.addProperty("max", sdf.format(gantt.getGantt_range_max().getDate()));
            }
            if (gantt.getGantt_draggable() != null && gantt.getGantt_draggable().getData() != null) {
                jsonDataObject.addProperty("draggable", gantt.getGantt_draggable().toString());
            }
        }
        return jsonDataObject;
    }
}

