/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gantt.jsonutil;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.effectivecompany.app.sst.SoGanttDataset;
import de.effectivecompany.app.sst.SoGanttTask;
import de.effectivecompany.gantt.jsonutil.SoGanttTaskAdapter;
import java.lang.reflect.Type;
import java.util.List;

public class SoGanttDatasetAdapter
implements JsonSerializer<SoGanttDataset> {
    public JsonElement serialize(SoGanttDataset dataset, Type type, JsonSerializationContext jsonSerializationContext) {
        return SoGanttDatasetAdapter.getAsJsonObject(dataset);
    }

    public static JsonArray getAsJsonArray(List<SoGanttDataset> datasets) {
        JsonArray jsonArray = new JsonArray();
        for (SoGanttDataset dataset : datasets) {
            jsonArray.add((JsonElement)SoGanttDatasetAdapter.getAsJsonObject(dataset));
        }
        return jsonArray;
    }

    private static JsonObject getAsJsonObject(SoGanttDataset dataset) {
        JsonObject jsonDataObject = new JsonObject();
        jsonDataObject.addProperty("id", dataset.getId().getData());
        jsonDataObject.addProperty("stext", dataset.getStext().getData());
        if (dataset.getColor() != null) {
            jsonDataObject.addProperty("color", dataset.getColor().toString());
        }
        jsonDataObject.add("taskList", (JsonElement)SoGanttTaskAdapter.getAsJsonArray((List<SoGanttTask>)dataset.getTaskList()));
        return jsonDataObject;
    }
}

