/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gantt.jsonutil;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.effectivecompany.app.doc.DcDocCooCce;
import de.effectivecompany.app.prd.DcPrdDocOprCce;
import de.effectivecompany.app.sst.SoGanttTask;
import java.awt.Color;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.List;

public class SoGanttTaskAdapter
implements JsonSerializer<SoGanttTask> {
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public JsonElement serialize(SoGanttTask task, Type type, JsonSerializationContext jsonSerializationContext) {
        return SoGanttTaskAdapter.getAsJsonObject(task);
    }

    public static JsonArray getAsJsonArray(List<SoGanttTask> tasks) {
        JsonArray jsonArray = new JsonArray();
        for (SoGanttTask task : tasks) {
            jsonArray.add((JsonElement)SoGanttTaskAdapter.getAsJsonObject(task));
        }
        return jsonArray;
    }

    private static JsonObject getAsJsonObject(SoGanttTask task) {
        JsonObject jsonDataObject = new JsonObject();
        jsonDataObject.addProperty("id", task.getId().getData());
        jsonDataObject.addProperty("parentid", task.getParentid().getData());
        jsonDataObject.addProperty("childid", task.getChildid().getData());
        jsonDataObject.addProperty("start", sdf.format(task.getStart().getDate()));
        jsonDataObject.addProperty("end", sdf.format(task.getEnd().getDate()));
        jsonDataObject.addProperty("stext", task.getStext().getData());
        jsonDataObject.addProperty("tooltip", task.getTooltip().getData());
        if (task.getProgress().getData() != null) {
            jsonDataObject.addProperty("progress", (Number)task.getProgress().getData());
        }
        if (task.getBo() != null && task.getBo() instanceof DcPrdDocOprCce && ((DcPrdDocOprCce)task.getBo()).getChanged().getData() != null) {
            jsonDataObject.addProperty("changed", ((DcPrdDocOprCce)task.getBo()).getChanged().getData());
        }
        if (task.getBo() != null && task.getBo() instanceof DcDocCooCce && ((DcDocCooCce)task.getBo()).getChanged().getData() != null) {
            jsonDataObject.addProperty("changed", ((DcDocCooCce)task.getBo()).getChanged().getData());
        }
        if (task.getSetup().getData() != null) {
            jsonDataObject.addProperty("setup", (Number)task.getSetup().getData());
        }
        if (task.getColor() != null) {
            jsonDataObject.addProperty("red", (Number)task.getColor().getRed());
            jsonDataObject.addProperty("blue", (Number)task.getColor().getBlue());
            jsonDataObject.addProperty("green", (Number)task.getColor().getGreen());
        }
        if (task.getColorMap() != null) {
            task.getColorMap().entrySet().forEach(entry -> {
                JsonObject jsonColorbject = new JsonObject();
                jsonColorbject.addProperty("red", (Number)((Color)entry.getValue()).getRed());
                jsonColorbject.addProperty("blue", (Number)((Color)entry.getValue()).getBlue());
                jsonColorbject.addProperty("green", (Number)((Color)entry.getValue()).getGreen());
                jsonDataObject.add((String)entry.getKey() + "Color", (JsonElement)jsonColorbject);
            });
        }
        if (task.getIs_searched() != null) {
            jsonDataObject.addProperty("is_searched", task.getIs_searched().getData());
        }
        if (task.getBo() != null && task.getBo() instanceof DcPrdDocOprCce && ((DcPrdDocOprCce)task.getBo()).getSchstat().getData() != null) {
            jsonDataObject.addProperty("schstat", (Number)((DcPrdDocOprCce)task.getBo()).getSchstat().getData());
        }
        if (task.getBo() != null && task.getBo() instanceof DcDocCooCce && ((DcDocCooCce)task.getBo()).getSchstat().getData() != null) {
            jsonDataObject.addProperty("schstat", (Number)((DcDocCooCce)task.getBo()).getSchstat().getData());
        }
        return jsonDataObject;
    }
}

