/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.graph.gui;

import de.effectivecompany.graph.gui.GraphListener;
import de.effectivecompany.graph.jsonutils.SoGraphEdgeAdapter;
import de.effectivecompany.graph.jsonutils.SoGraphElementAdapter;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.data.graph.Graph;
import de.effectivecompany.gui.manager.EFCPropertyManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import org.cef.CefApp;
import org.cef.CefClient;
import org.cef.CefSettings;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefContextMenuParams;
import org.cef.callback.CefMenuModel;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefContextMenuHandler;
import org.cef.handler.CefContextMenuHandlerAdapter;
import org.cef.handler.CefDisplayHandler;
import org.cef.handler.CefDisplayHandlerAdapter;
import org.cef.handler.CefLifeSpanHandler;
import org.cef.handler.CefLifeSpanHandlerAdapter;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.cef.handler.CefMessageRouterHandler;
import org.cef.handler.CefMessageRouterHandlerAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphView
extends EFCPanel {
    public static Logger logger = LoggerFactory.getLogger(GraphView.class);
    private Graph graph;
    private CefClient client;
    private CefBrowser browser;
    private List<GraphListener> listeners = new ArrayList<GraphListener>();
    private CefMessageRouter msgRouter;
    private JPanel p = new JPanel(new BorderLayout());
    private boolean isLoaded = false;

    public GraphView() {
        super("");
        this.client = CefApp.getInstance().createClient();
        this.client.addDisplayHandler((CefDisplayHandler)new CefDisplayHandlerAdapter(){

            public boolean onConsoleMessage(CefBrowser browser, CefSettings.LogSeverity level, String message, String source, int line) {
                switch (level) {
                    case LOGSEVERITY_DEFAULT: 
                    case LOGSEVERITY_INFO: {
                        logger.info(message);
                        break;
                    }
                    case LOGSEVERITY_ERROR: 
                    case LOGSEVERITY_FATAL: {
                        if (message != null && !message.contains("setData is not defined")) {
                            EFCDesktop.reportError(message, null);
                            break;
                        }
                        logger.error(message);
                        break;
                    }
                    case LOGSEVERITY_WARNING: {
                        logger.warn(message);
                    }
                }
                return false;
            }
        });
        this.client.addLifeSpanHandler((CefLifeSpanHandler)new CefLifeSpanHandlerAdapter(){

            public boolean doClose(CefBrowser browser) {
                browser.doClose();
                return false;
            }
        });
        this.msgRouter = CefMessageRouter.create();
        this.msgRouter.addHandler((CefMessageRouterHandler)new CefMessageRouterHandlerAdapter(){

            public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
                if (request != null && !request.isEmpty()) {
                    if (request.equals("layoutstop")) {
                        GraphView.this.isLoaded = true;
                        GraphView.this.setLocked(false);
                    } else {
                        StringTokenizer to = new StringTokenizer(request, ",");
                        for (GraphListener hl : GraphView.this.listeners) {
                            hl.onSelection(to.nextToken(), to.nextToken());
                        }
                    }
                }
                return super.onQuery(browser, frame, queryId, request, persistent, callback);
            }
        }, true);
        this.client.addMessageRouter(this.msgRouter);
        this.client.addLoadHandler((CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadEnd(CefBrowser browser, CefFrame frame, int httpStatusCode) {
                if (browser.getURL() != null && !browser.getURL().isEmpty() && !browser.getURL().equals("about:blank")) {
                    GraphView.this.fillGraph();
                }
            }

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                super.onLoadError(browser, frame, errorCode, errorText, failedUrl);
                GraphView.this.setLocked(false);
            }
        });
        this.browser = this.client.createBrowser("about:blank", true, false);
        this.client.addContextMenuHandler((CefContextMenuHandler)new CefContextMenuHandlerAdapter(){

            public void onBeforeContextMenu(CefBrowser browser, CefFrame frame, CefContextMenuParams params, CefMenuModel model) {
                model.clear();
            }
        });
        this.browser.createImmediately();
        this.p.add(this.browser.getUIComponent(), "Center");
        this.add((Component)this.p, "Center");
    }

    public void addGraphLIstener(GraphListener listener) {
        this.listeners.add(listener);
    }

    public void setLocked(boolean isLocked) {
        if (isLocked) {
            this.setCursor(new Cursor(3));
        } else {
            this.setCursor(new Cursor(0));
        }
        this.browser.getUIComponent().setEnabled(!isLocked);
    }

    public void setData(Graph graph) {
        this.graph = graph;
        if (this.isLoaded) {
            this.fillGraph();
        } else {
            this.browser.loadURL(this.getGraphURL());
        }
    }

    private String getGraphURL() {
        return EFCPropertyManager.getClientProperties().getProperty("efcserver.protocol") + "://" + EFCPropertyManager.getClientProperties().getProperty("efcserver.serverName") + ":" + EFCPropertyManager.getClientProperties().getProperty("efcserver.httpPort") + EFCPropertyManager.getClientProperties().getProperty("efcserver.contextPath") + "/resources/graph.html";
    }

    private void fillGraph() {
        if (this.browser != null && this.graph != null) {
            String data = "setData(" + SoGraphElementAdapter.getAsJsonArray(this.graph.getElements()).toString() + "," + SoGraphEdgeAdapter.getAsJsonArray(this.graph.getEdges()).toString() + ")";
            this.browser.executeJavaScript(data, "", 0);
        }
    }

    @Override
    public void terminate() {
        this.removeAll();
        this.client.removeMessageRouter(this.msgRouter);
        this.client.dispose();
    }
}

