/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.graph.jsonutils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import de.effectivecompany.app.sst.SoGraphElement;
import java.lang.reflect.Type;
import java.util.List;

public class SoGraphElementAdapter
implements JsonSerializer<SoGraphElement> {
    public JsonElement serialize(SoGraphElement visEdge, Type type, JsonSerializationContext jsonSerializationContext) {
        return SoGraphElementAdapter.getAsJsonObject(visEdge);
    }

    public static JsonArray getAsJsonArray(List<SoGraphElement> nodes) {
        JsonArray jsonArray = new JsonArray();
        for (SoGraphElement visNode : nodes) {
            jsonArray.add((JsonElement)SoGraphElementAdapter.getAsJsonObject(visNode));
        }
        return jsonArray;
    }

    private static JsonObject getAsJsonObject(SoGraphElement visNode) {
        JsonObject jsonDataObject = new JsonObject();
        try {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("id", visNode.getElementid().getData());
            if (visNode.getParentelementid() != null && visNode.getParentelementid().getData() != null && !visNode.getParentelementid().getData().isEmpty()) {
                jsonObject.addProperty("parent", visNode.getParentelementid().getData());
            }
            if (visNode.getStext() != null && visNode.getStext().getData() != null) {
                jsonObject.addProperty("label", visNode.getStext().getData());
            }
            if (visNode.getColor() != null) {
                jsonObject.addProperty("red", (Number)visNode.getColor().getRed());
                jsonObject.addProperty("blue", (Number)visNode.getColor().getBlue());
                jsonObject.addProperty("green", (Number)visNode.getColor().getGreen());
            }
            if (visNode.getIsroot() != null && visNode.getIsroot().getData() != null) {
                jsonObject.addProperty("isroot", visNode.getIsroot().getData());
            }
            if (visNode.getIsselected() != null && visNode.getIsselected().getData() != null) {
                jsonDataObject.addProperty("selected", visNode.getIsselected().getData());
            }
            jsonDataObject.addProperty("group", "nodes");
            jsonDataObject.add("data", (JsonElement)jsonObject);
            if (visNode.getBo() != null) {
                JsonArray array = new JsonArray();
                if (visNode.getBo()._isDeleted()) {
                    array.add("IS_DELETED");
                } else {
                    array.add(visNode.getBo().getClass().getSimpleName());
                }
                jsonDataObject.add("classes", (JsonElement)array);
            }
        }
        catch (Throwable th) {
            System.out.println(th);
        }
        return jsonDataObject;
    }
}

