/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui;

import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.util.logging.Level;
import javafx.animation.FadeTransition;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Duration;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.springframework.security.authentication.AuthenticationManager;

public class SplashScreen
extends Stage {
    private Pane splashLayout;
    private ProgressBar loadProgress;
    private Label progressText = new Label();

    public SplashScreen() {
        super(StageStyle.UNDECORATED);
        Image image = EFCLookAndFeelManager.ICON_SPLASH;
        ImageView splash = new ImageView(image);
        this.loadProgress = new ProgressBar();
        this.loadProgress.setPrefWidth(image.getWidth());
        this.splashLayout = new VBox();
        this.splashLayout.getChildren().addAll((Object[])new Node[]{splash});
        this.progressText.setAlignment(Pos.CENTER);
        Task<AuthenticationManager> appLoadingTask = new Task<AuthenticationManager>(){

            protected AuthenticationManager call() throws InterruptedException {
                AuthenticationManager manager = (AuthenticationManager)SpringHelper.getBean((String)"authenticationManager");
                return manager;
            }
        };
        this.showSplash(appLoadingTask);
        appLoadingTask.setOnSucceeded(taskEvent -> {
            if (taskEvent.getSource().valueProperty().get() != null) {
                // empty if block
            }
        });
        appLoadingTask.setOnFailed(taskEvent -> {
            String message = taskEvent.getSource().getException().getMessage();
            Throwable ex = taskEvent.getSource().getException();
            EFCThreadUtil.doLater(() -> {
                JXErrorPane.showDialog(null, (ErrorInfo)new ErrorInfo("Error", message, null, "some cat", ex, Level.SEVERE, null));
                System.exit(0);
            });
        });
        new Thread((Runnable)appLoadingTask).start();
    }

    private void showSplash(Task<AuthenticationManager> task) {
        this.progressText.textProperty().bind((ObservableValue)task.messageProperty());
        this.loadProgress.progressProperty().bind((ObservableValue)task.progressProperty());
        task.stateProperty().addListener((observableValue, oldState, newState) -> {
            if (newState == Worker.State.SUCCEEDED) {
                this.loadProgress.progressProperty().unbind();
                this.loadProgress.setProgress(1.0);
                FadeTransition fadeSplash = new FadeTransition(Duration.seconds((double)10.0), (Node)this.splashLayout);
                fadeSplash.setOnFinished(actionEvent -> this.close());
                fadeSplash.play();
            }
        });
        Scene splashScene = new Scene((Parent)this.splashLayout);
        this.setScene(splashScene);
        this.sizeToScene();
        this.show();
        Rectangle2D primScreenBounds = Screen.getPrimary().getVisualBounds();
        this.setX((primScreenBounds.getWidth() - this.getWidth()) / 2.0);
        this.setY((primScreenBounds.getHeight() - this.getHeight()) / 2.0);
        this.toFront();
    }
}

