/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.actions;

import de.effectivecompany.gui.components.EFCActionAccelerator;
import de.effectivecompany.gui.constants.EFCActionAcceleratorKey;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EFCAbstractAction
extends AbstractAction
implements EFCActionAccelerator {
    private static final long serialVersionUID = -5193477826601650400L;
    private static Logger logger = LoggerFactory.getLogger(EFCAbstractAction.class);
    protected ActionHandler actionHandler;

    public EFCAbstractAction() {
    }

    public EFCAbstractAction(String title) {
        super(title);
    }

    public EFCAbstractAction(String title, Icon icon) {
        super(title, icon);
        if (EFCLookAndFeelManager.SIZE_MULTIPLIER != 1.0) {
            ImageIcon newicon = (ImageIcon)this.getValue("SmallIcon");
            newicon = new ImageIcon(newicon.getImage().getScaledInstance((int)((double)newicon.getIconWidth() * EFCLookAndFeelManager.SIZE_MULTIPLIER), (int)((double)newicon.getIconHeight() * EFCLookAndFeelManager.SIZE_MULTIPLIER), 4));
            this.putValue("SmallIcon", newicon);
        }
    }

    public void setActionHandler(ActionHandler actionHandler) {
        this.actionHandler = actionHandler;
    }

    public void removeActionHandler() {
        this.actionHandler = null;
    }

    public ActionHandler getActionHandler() {
        return this.actionHandler;
    }

    protected void processAction(String ident, Object context) {
        if (this.actionHandler != null) {
            this.actionHandler.handleAction(ident, context);
        } else {
            logger.error("NO ACTION HANDLER SET FOR " + this.getClass().getSimpleName());
        }
    }

    public abstract String getIdent();

    @Override
    public void addAccelerator(EFCActionAcceleratorKey accelerator) {
        this.putValue("AcceleratorKey", accelerator.getAcceleratorKey());
    }
}

