/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.actions;

import de.effectivecompany.app.syscl.ClSysWflParamDet;
import de.effectivecompany.app.syswfl.BoWflTask;
import de.effectivecompany.app.syswfl.BoWflVariable;
import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.msg.MsgType;
import de.effectivecompany.gui.actions.EFCAbstractAction;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.fx.wfl.WflController;
import de.effectivecompany.gui.components.fx.wfl.WflPanelType;
import de.effectivecompany.gui.components.fx.wfl.service.EFCSetVariablesForTaskService;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.components.swing.EFCMessageListDialog;
import de.effectivecompany.gui.constants.EFCParamConstants;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javafx.application.Platform;
import javafx.concurrent.Task;

public class EFCActionWflTask
extends EFCAbstractAction {
    private static final long serialVersionUID = -795069753634735602L;
    public static final String IDENT = "wfl_task";
    private BoWflTask task;
    private EFCController controller;

    public EFCActionWflTask(BoWflTask task, EFCController controller) {
        BoWflVariable pjmprogkey = (BoWflVariable)task.getAct_variables().get((Object)EFCParamConstants.WFL_CONST_PROGKEY);
        EFCList paramList = new EFCList();
        if (pjmprogkey != null && pjmprogkey.getAct_value() != null && WflController.getInstance().getWflParams().get((Object)pjmprogkey.getAct_value()) != null) {
            paramList = (EFCList)WflController.getInstance().getWflParams().get((Object)pjmprogkey.getAct_value());
        }
        Object taskName = "";
        for (ClSysWflParamDet param : paramList) {
            String value;
            if (!task.getAct_variables().containsKey((Object)param.getWflextparamcode()) || (value = ((BoWflVariable)task.getAct_variables().get((Object)param.getWflextparamcode())).getAct_value().getData()) == null || value.isEmpty() || param.getIswflextshow().getData() == null || !param.getIswflextshow().getData().booleanValue()) continue;
            taskName = (String)taskName + value + " ";
        }
        taskName = (String)taskName + task.getAct_name().getData();
        this.putValue("Name", taskName);
        this.putValue("ShortDescription", task.getAct_description().getData());
        this.task = task;
        this.controller = controller;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.processAction(IDENT, this.task);
        if (Platform.isFxApplicationThread()) {
            this.execute();
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    EFCActionWflTask.this.execute();
                }
            });
        }
    }

    private void execute() {
        EFCSetVariablesForTaskService taskService = new EFCSetVariablesForTaskService();
        Task<BoWflTask> taskexec = taskService.createTask(this.task, this.controller);
        taskexec.setOnRunning(handler -> EFCThreadUtil.doLater(() -> this.controller.lockControl()));
        taskexec.setOnSucceeded(handler -> {
            EFCThreadUtil.doLater(() -> this.controller.unlockControl());
            if (handler.getSource().valueProperty().getValue() instanceof BoWflTask) {
                BoWflTask task = (BoWflTask)handler.getSource().valueProperty().getValue();
                if (task.getCompleteMsgList().getMaxSeverity() == MsgType.ERROR) {
                    EFCMessageListDialog messageDlg = new EFCMessageListDialog((Frame)EFCMainFrame.getInstance(), true);
                    messageDlg.show(task.getCompleteMsgList().getMsgList());
                } else {
                    EFCDesktop.getInstance();
                    EFCDesktop.showInfoDlg(Translator.tr((String)"WFL_TASK_INFO_COMPLETED"));
                    WflController.getInstance().showView(WflPanelType.TASKS, false, task.getAct_id().getData());
                }
            } else {
                EFCDesktop.getInstance();
                EFCDesktop.showErrorDlg("WFL_TASK_INFO_ERROR");
            }
        });
        taskexec.setOnFailed(handler -> {
            EFCThreadUtil.doLater(() -> this.controller.unlockControl());
            EFCDesktop.reportError(handler.getSource().getException());
        });
        WflController.getInstance().executeTask(taskexec);
    }

    @Override
    public String getIdent() {
        return IDENT;
    }
}

