/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.base.efcbl.domain.BOxMapper;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.gui.components.BpmnFilter;
import de.effectivecompany.gui.components.ImageFilter;
import de.effectivecompany.gui.components.PDFFilter;
import de.effectivecompany.gui.components.XMLFilter;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;

public class EFCFileChooser
extends JFileChooser {
    private static final long serialVersionUID = -2011149507394922836L;
    private String extension;

    public EFCFileChooser() {
    }

    public EFCFileChooser(File filePath) {
        super(filePath);
    }

    public EFCFileChooser(File filePath, int fileSelectionMod) {
        super(filePath);
        this.setFileSelectionMode(fileSelectionMod);
    }

    public EFCFileChooser(String filterName) {
        if (filterName.equalsIgnoreCase("xml")) {
            this.setFileFilter(new XMLFilter());
            this.extension = ".xml";
        } else if (filterName.equalsIgnoreCase("pdf")) {
            this.setFileFilter(new PDFFilter());
            this.extension = ".pdf";
        } else if (filterName.equalsIgnoreCase("images")) {
            this.setFileFilter(new ImageFilter());
        } else if (filterName.equalsIgnoreCase("bpmn")) {
            this.setFileFilter(new BpmnFilter());
        }
    }

    public File getFileByOpenFileDialog(Component parent) {
        if (this.showOpenDialog(parent) == 0) {
            return this.getSelectedFile();
        }
        return null;
    }

    public List<File> getFilesByOpenFileDialog(Component parent) {
        if (this.showOpenDialog(parent) == 0) {
            return Arrays.asList(this.getSelectedFiles());
        }
        return null;
    }

    public void saveBOFile(Component parent, BusinessObject bo) {
        if (this.showSaveDialog(parent) == 0) {
            Object fileName = this.getSelectedFile().getPath();
            if (!((String)fileName).endsWith(this.extension)) {
                fileName = (String)fileName + this.extension;
            }
            BOxMapper boxMapper = (BOxMapper)SpringHelper.getBean((String)"boXmlMapper");
            try {
                boxMapper.writeBOToXml((Object)bo, (String)fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Object openBOFile(Component parent) {
        Object businessObject = null;
        if (this.showOpenDialog(parent) == 0) {
            String fileName = this.getSelectedFile().getPath();
            BOxMapper boxMapper = (BOxMapper)SpringHelper.getBean((String)"boXmlMapper");
            try {
                businessObject = boxMapper.readBOFromXml(fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return businessObject;
    }
}

