/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.base.datatypes.EFCMap;
import de.effectivecompany.gui.actions.EFCAbstractAction;
import de.effectivecompany.gui.components.EFCToolBar;
import de.effectivecompany.gui.components.button.EFCDropDownButton;
import de.effectivecompany.gui.constants.EFCAction;
import de.effectivecompany.gui.constants.EFCMenu;
import de.effectivecompany.gui.constants.EFCMenuElement;
import de.effectivecompany.gui.constants.EFCPredefinedMenu;
import de.effectivecompany.gui.constants.EFCPredefinedToolBar;
import de.effectivecompany.gui.interfaces.handler.ActionHandler;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCMainMenu
extends JMenuBar {
    public static final long serialVersionUID = -154532L;
    private static Logger logger = LoggerFactory.getLogger(EFCMainMenu.class);
    private Map<EFCAction, EFCAbstractAction> actions = new LinkedHashMap<EFCAction, EFCAbstractAction>();
    private EFCPredefinedToolBar predefinedToolbar;
    private EFCToolBar toolbar;

    public EFCMainMenu() {
        this(EFCPredefinedMenu.M_FRAME_MASTER, EFCPredefinedToolBar.DEFAULT);
    }

    public EFCMainMenu(EFCPredefinedMenu predefMenu) {
        this(predefMenu, EFCPredefinedToolBar.DEFAULT);
    }

    public EFCMainMenu(EFCPredefinedMenu predefMenu, EFCPredefinedToolBar predefinedToolbar) {
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        this.predefinedToolbar = predefinedToolbar;
        this.initActions();
        for (EFCMenu menuItem : predefMenu.getMenuElements()) {
            this.addItem(null, menuItem);
        }
        this.setFocusable(false);
    }

    public void setMenusEnabled(boolean enabled) {
        for (Component menu : this.getComponents()) {
            menu.setEnabled(enabled);
        }
    }

    private void initActions() {
        for (EFCAction action : EFCAction.values()) {
            this.actions.put(action, action.newAction());
        }
    }

    private JMenu addItem(JMenu parent, EFCMenuElement item) {
        JMenu menu = null;
        if (item instanceof EFCAction) {
            EFCAction action = (EFCAction)item;
            if (EFCLookAndFeelManager.isAdmin || !action.isOnlyForAdmin()) {
                JMenuItem menuitem = new JMenuItem(this.getAction(action));
                menuitem.setFocusable(false);
                menuitem = parent.add(menuitem);
            }
        } else if (item.isMenuSeparator()) {
            parent.addSeparator();
        } else if (item instanceof EFCMenu) {
            EFCMenu efcMenu = (EFCMenu)item;
            menu = new JMenu(efcMenu.getMenuItemName());
            menu.setVisible(efcMenu.isVisible());
            if (parent != null) {
                parent.add(menu);
            } else {
                this.add(menu);
            }
            for (EFCMenuElement subItem : item.getElements()) {
                JMenu subMenu = this.addItem(menu, subItem);
                if (subMenu == null) continue;
                menu.add(subMenu);
            }
        }
        return menu;
    }

    public void setEnabledActions(EnumSet<EFCAction> bitmask) {
        bitmask.forEach(action -> {
            EFCAbstractAction efcAction = this.getAction((EFCAction)action);
            if (efcAction != null) {
                efcAction.setEnabled(true);
            }
        });
    }

    public void enableActions(EFCAction ... menu) {
        for (EFCAction action : menu) {
            EFCAbstractAction efcAction = this.getAction(action);
            if (efcAction == null) continue;
            efcAction.setEnabled(true);
        }
    }

    public void disableActions(EFCAction ... menu) {
        for (EFCAction action : menu) {
            EFCAbstractAction efcAction = this.getAction(action);
            if (efcAction == null) continue;
            efcAction.setEnabled(false);
        }
    }

    public void setActionHandler(ActionHandler handler) {
        for (Map.Entry<EFCAction, EFCAbstractAction> entry : this.actions.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            entry.getValue().setActionHandler(handler);
        }
    }

    public void removeActionHandlers() {
        for (Map.Entry<EFCAction, EFCAbstractAction> entry : this.actions.entrySet()) {
            if (entry == null || entry.getValue() == null) continue;
            entry.getValue().removeActionHandler();
        }
    }

    public EFCAbstractAction getAction(EFCAction constant) {
        EFCAbstractAction action = this.actions.get(constant);
        if (action == null) {
            logger.error("EFC Action not initialized MenuConstant: " + constant.name());
        }
        return action;
    }

    public EFCToolBar getToolBar() {
        if (this.toolbar != null) {
            return this.toolbar;
        }
        if (this.predefinedToolbar != null) {
            this.toolbar = new EFCToolBar();
            for (EFCMenuElement element : this.predefinedToolbar.getElements()) {
                EFCAction action;
                if (element instanceof EFCAction) {
                    action = (EFCAction)element;
                    JButton button = this.toolbar.add(this.getAction(action));
                    button.setBorderPainted(false);
                    button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, this.toolbar));
                    continue;
                }
                if (element.isMenuSeparator()) {
                    this.toolbar.addSeparator();
                    continue;
                }
                if (element.getElements().isEmpty()) continue;
                action = (EFCAction)element.getElements().get(0);
                EFCDropDownButton dropDown = this.createDropDownButton(this.toolbar, action);
                for (EFCMenuElement dropMenuElement : element.getElements()) {
                    if (dropMenuElement instanceof EFCAction) {
                        EFCAction dropaction = (EFCAction)dropMenuElement;
                        dropDown.add(this.getAction(dropaction)).setBorderPainted(false);
                        continue;
                    }
                    if (!dropMenuElement.isMenuSeparator()) continue;
                    dropDown.addSeparator();
                }
            }
        }
        return this.toolbar;
    }

    private EFCDropDownButton createDropDownButton(EFCToolBar toolbar, EFCAction a) {
        EFCDropDownButton button = new EFCDropDownButton(this.getAction(a));
        button.setHideActionText(true);
        button.setBackground(Color.BLACK);
        toolbar.add(button);
        button.setBorderPainted(false);
        button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, toolbar));
        return button;
    }

    public JMenu getMenu(EFCMenu menuconst) {
        for (Component comp : this.getComponents()) {
            JMenu menu;
            if (!(comp instanceof JMenu) || (menu = (JMenu)comp).getText() == null || menuconst.getMenuItemName() == null || !menu.getText().equals(menuconst.getMenuItemName())) continue;
            return menu;
        }
        return null;
    }

    public void terminate() {
        this.removeActionHandlers();
        this.actions.clear();
        for (EFCMenu menu : EFCMenu.values()) {
            JMenu efcMenu = this.getMenu(menu);
            if (efcMenu == null) continue;
            ((Container)efcMenu).removeAll();
        }
        if (this.toolbar != null) {
            this.toolbar.terminate();
        }
        this.removeAll();
    }

    public void processMenuBlacklist(EFCMap<String, Boolean> blackList) {
        for (MenuElement element : this.getSubElements()) {
            if (!(element instanceof JMenu)) continue;
            this.checkMenu(blackList, (JMenu)element);
        }
    }

    private void disableMenu(MenuElement menu) {
        block5: {
            block4: {
                if (!(menu instanceof JMenu)) break block4;
                JMenu jMenu = (JMenu)menu;
                for (MenuElement menuItem : jMenu.getSubElements()) {
                    JMenuItem jMenuItem;
                    if (menuItem instanceof JPopupMenu) {
                        this.disableMenu(menuItem);
                        continue;
                    }
                    if (!(menuItem instanceof JMenuItem) || !((jMenuItem = (JMenuItem)menuItem).getAction() instanceof EFCAbstractAction)) continue;
                    EFCAbstractAction action = (EFCAbstractAction)jMenuItem.getAction();
                    jMenuItem.setVisible(false);
                    action.setEnabled(false);
                    this.toolbar.removeButton(action);
                }
                break block5;
            }
            if (!(menu instanceof JPopupMenu)) break block5;
            JPopupMenu jMenu = (JPopupMenu)menu;
            for (MenuElement menuItem : jMenu.getSubElements()) {
                JMenuItem jMenuItem;
                if (menuItem instanceof JPopupMenu) {
                    this.disableMenu(menuItem);
                    continue;
                }
                if (!(menuItem instanceof JMenuItem) || !((jMenuItem = (JMenuItem)menuItem).getAction() instanceof EFCAbstractAction)) continue;
                EFCAbstractAction action = (EFCAbstractAction)jMenuItem.getAction();
                jMenuItem.setVisible(false);
                action.setEnabled(false);
                this.toolbar.removeButton(action);
            }
        }
    }

    private void checkMenu(EFCMap<String, Boolean> blackList, MenuElement menu) {
        block7: {
            block6: {
                if (!(menu instanceof JMenu)) break block6;
                JMenu jMenu = (JMenu)menu;
                if (blackList.containsKey((Object)("MENU_" + ((JMenuItem)menu).getText()))) {
                    this.disableMenu(jMenu);
                    jMenu.setVisible(false);
                } else {
                    for (MenuElement menuItem : jMenu.getSubElements()) {
                        EFCAbstractAction action;
                        JMenuItem jMenuItem;
                        if (menuItem instanceof JPopupMenu) {
                            this.checkMenu(blackList, (JPopupMenu)menuItem);
                            continue;
                        }
                        if (!(menuItem instanceof JMenuItem) || !((jMenuItem = (JMenuItem)menuItem).getAction() instanceof EFCAbstractAction) || !blackList.containsKey((Object)(action = (EFCAbstractAction)jMenuItem.getAction()).getIdent())) continue;
                        jMenuItem.setVisible(false);
                        action.setEnabled(false);
                        this.toolbar.removeButton(action);
                    }
                }
                break block7;
            }
            if (!(menu instanceof JPopupMenu)) break block7;
            JPopupMenu jMenu = (JPopupMenu)menu;
            for (MenuElement menuItem : jMenu.getSubElements()) {
                EFCAbstractAction action;
                JMenuItem jMenuItem;
                if (menuItem instanceof JPopupMenu) {
                    this.checkMenu(blackList, (JPopupMenu)menuItem);
                    continue;
                }
                if (!(menuItem instanceof JMenuItem) || !((jMenuItem = (JMenuItem)menuItem).getAction() instanceof EFCAbstractAction) || !blackList.containsKey((Object)(action = (EFCAbstractAction)jMenuItem.getAction()).getIdent())) continue;
                jMenuItem.setVisible(false);
                action.setEnabled(false);
                this.toolbar.removeButton(action);
            }
        }
    }
}

