/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.gui.components.EFCStatusBarSkin;
import de.effectivecompany.gui.components.EFCTaskProgressView;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.control.Label;
import javafx.scene.control.Separator;
import javafx.scene.control.Skin;
import javafx.scene.layout.TilePane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import org.controlsfx.control.StatusBar;

public class EFCStatusBar
extends StatusBar {
    public static final long serialVersionUID = -3725326L;
    private Label[] textfield;
    private TilePane box = new TilePane(Orientation.VERTICAL);
    private boolean withProgress = false;

    public EFCStatusBar() {
        this(1);
    }

    public EFCStatusBar(int textfields, boolean withProgressView) {
        EFCTaskProgressView.getInstance();
        this.textfield = new Label[textfields];
        this.withProgress = withProgressView;
        this.box.setPrefColumns(textfields);
        this.setPrefHeight(20.0);
        this.setText("");
        for (int i = 0; i < this.textfield.length; ++i) {
            this.textfield[i] = new Label();
            this.textfield[i].getStyleClass().add((Object)"status-label");
            this.textfield[i].setPadding(new Insets(0.0, 100.0, 0.0, 12.0));
            this.getLeftItems().add((Object)this.textfield[i]);
            this.getLeftItems().add((Object)new Separator(Orientation.VERTICAL));
            this.textfield[i].setFont(new Font(EFCLookAndFeelManager.FONT_STATUSBAR.getFontName(), (double)EFCLookAndFeelManager.FONT_STATUSBAR.getSize()));
        }
        this.setStatusText(" ", 0);
        this.getLeftItems().add((Object)this.box);
    }

    protected Skin<?> createDefaultSkin() {
        return new EFCStatusBarSkin(this, this.withProgress);
    }

    public EFCStatusBar(int textfields) {
        this(textfields, false);
    }

    public String getUserAgentStylesheet() {
        return "";
    }

    public void setStatusText(final String text) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EFCStatusBar.this.textfield[0].setText(text);
            }
        });
    }

    public String getStatusText() {
        return this.textfield[0].getText();
    }

    public void setStatusText(final String text, final int field) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EFCStatusBar.this.textfield[field].setText(text);
            }
        });
    }

    public void setStatusText(final String text, final int field, final Color textColor) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                EFCStatusBar.this.textfield[field].setText(text);
                EFCStatusBar.this.textfield[field].setTextFill((Paint)textColor);
            }
        });
    }

    public void setProgressBarVisible(boolean visible) {
        ((EFCStatusBarSkin)this.getSkin()).getProgressBar().setVisible(visible);
    }

    public String getText(int field) {
        return this.textfield[field].getText();
    }

    public Label getTextField(int field) {
        return this.textfield[field];
    }

    public void terminate() {
        this.textfield = null;
    }
}

