/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.EFCTaskProgressView;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.util.Collection;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import org.controlsfx.control.StatusBar;

public class EFCStatusBarSkin
extends SkinBase<StatusBar> {
    private HBox leftBox = new HBox();
    private HBox rightBox;
    private Label label;
    private Control progressBar;

    public EFCStatusBarSkin(StatusBar statusBar, boolean withProgress) {
        super((Control)statusBar);
        this.leftBox.getStyleClass().add((Object)"left-items");
        this.rightBox = new HBox();
        this.rightBox.getStyleClass().add((Object)"right-items");
        if (EFCLookAndFeelManager.IS_REMOTE_DESKTOP_SESSION) {
            this.progressBar = new Label(Translator.tr((String)"STATUSBAR_PROGESS_TEXT"));
            ((Label)this.progressBar).setTextFill((Paint)Color.DODGERBLUE);
        } else {
            this.progressBar = new ProgressBar(-1.0);
        }
        this.progressBar.setVisible(false);
        if (withProgress) {
            this.progressBar.visibleProperty().bind((ObservableValue)Bindings.notEqual((int)0, (ObservableNumberValue)statusBar.progressProperty()));
            if (this.progressBar instanceof ProgressBar) {
                ((ProgressBar)this.progressBar).progressProperty().bind((ObservableValue)statusBar.progressProperty());
            }
            this.progressBar.setOnMouseClicked(event -> EFCTaskProgressView.getInstance().toggleIsVisible(event));
        }
        this.label = new Label();
        this.label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.label.textProperty().bind((ObservableValue)statusBar.textProperty());
        this.label.graphicProperty().bind((ObservableValue)statusBar.graphicProperty());
        this.label.getStyleClass().add((Object)"status-label");
        this.leftBox.getChildren().setAll((Collection)((StatusBar)this.getSkinnable()).getLeftItems());
        this.rightBox.getChildren().setAll((Collection)((StatusBar)this.getSkinnable()).getRightItems());
        statusBar.getLeftItems().addListener(evt -> this.leftBox.getChildren().setAll((Collection)((StatusBar)this.getSkinnable()).getLeftItems()));
        statusBar.getRightItems().addListener(evt -> this.rightBox.getChildren().setAll((Collection)((StatusBar)this.getSkinnable()).getRightItems()));
        GridPane gridPane = new GridPane();
        GridPane.setFillHeight((Node)this.leftBox, (Boolean)true);
        GridPane.setFillHeight((Node)this.rightBox, (Boolean)true);
        GridPane.setFillHeight((Node)this.label, (Boolean)true);
        GridPane.setFillHeight((Node)this.progressBar, (Boolean)true);
        GridPane.setVgrow((Node)this.progressBar, (Priority)Priority.ALWAYS);
        GridPane.setMargin((Node)this.progressBar, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        GridPane.setVgrow((Node)this.leftBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.rightBox, (Priority)Priority.ALWAYS);
        GridPane.setVgrow((Node)this.label, (Priority)Priority.ALWAYS);
        GridPane.setHgrow((Node)this.label, (Priority)Priority.ALWAYS);
        gridPane.add((Node)this.leftBox, 0, 0);
        gridPane.add((Node)this.label, 1, 0);
        gridPane.add((Node)this.progressBar, 2, 0);
        gridPane.add((Node)this.rightBox, 4, 0);
        this.getChildren().add((Object)gridPane);
    }

    public Control getProgressBar() {
        return this.progressBar;
    }
}

