/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import de.effectivecompany.gui.actions.EFCAbstractAction;
import de.effectivecompany.gui.actions.EFCActionGoNext;
import de.effectivecompany.gui.actions.EFCActionGoPrevious;
import de.effectivecompany.gui.components.button.EFCDropDownButton;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JToolBar;
import javax.swing.MenuElement;

public class EFCToolBar
extends JToolBar {
    public static final long serialVersionUID = -34563456L;
    private List<EFCAbstractAction> actions = new ArrayList<EFCAbstractAction>();

    public EFCToolBar() {
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                block3: {
                    block2: {
                        if (event.getWheelRotation() != 1) break block2;
                        for (Action action : EFCToolBar.this.actions) {
                            if (!(action instanceof EFCActionGoNext) || !action.isEnabled()) continue;
                            action.actionPerformed(new ActionEvent(event.getSource(), event.getID() + 1, "go_next"));
                        }
                        break block3;
                    }
                    if (event.getWheelRotation() != -1) break block3;
                    for (Action action : EFCToolBar.this.actions) {
                        if (!(action instanceof EFCActionGoPrevious) || !action.isEnabled()) continue;
                        action.actionPerformed(new ActionEvent(event.getSource(), event.getID() + 1, "go_previous"));
                    }
                }
            }
        });
    }

    @Override
    public JButton add(Action arg0) {
        this.actions.add((EFCAbstractAction)arg0);
        return super.add(arg0);
    }

    @Override
    public void removeAll() {
        this.actions.clear();
        super.removeAll();
    }

    public void terminate() {
        for (Component comp : this.getComponents()) {
            if (!(comp instanceof JButton)) continue;
            ((JButton)comp).removeAll();
        }
        this.removeAll();
        for (MouseWheelListener listener : this.getMouseWheelListeners()) {
            this.removeMouseWheelListener(listener);
        }
    }

    public void setButtonVisible(Action action, boolean visible) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component instanceof JButton) {
                if (((JButton)component).getAction() != action) continue;
                component.setVisible(visible);
                continue;
            }
            if (!(component instanceof EFCDropDownButton) || ((EFCDropDownButton)component).getAction() != action) continue;
            component.setVisible(visible);
        }
    }

    public void removeButton(Action action) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (component instanceof EFCDropDownButton) {
                EFCDropDownButton dropDownButton = (EFCDropDownButton)component;
                if (dropDownButton.getAction() == action) {
                    if (dropDownButton.getMenu().getSubElements().length != 0) continue;
                    this.remove(dropDownButton);
                    continue;
                }
                for (MenuElement element : dropDownButton.getMenu().getSubElements()) {
                    JMenuItem dropMenuItem;
                    if (!(element instanceof JMenuItem) || (dropMenuItem = (JMenuItem)element).getAction() != action) continue;
                    dropDownButton.getMenu().remove(dropMenuItem);
                }
                continue;
            }
            if (!(component instanceof JButton) || ((JButton)component).getAction() != action) continue;
            this.remove(component);
        }
    }

    public Boolean isButtonVisible(Action action) {
        Component[] components;
        for (Component component : components = this.getComponents()) {
            if (!(component instanceof JButton) || ((JButton)component).getAction() != action) continue;
            return component.isVisible();
        }
        return false;
    }

    public List<EFCAbstractAction> getActions() {
        return this.actions;
    }
}

