/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components;

import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.controlsfx.control.TaskProgressView;

public class TaskViewPanel<T extends Task<?>>
extends SkinBase<TaskProgressView<T>> {
    public TaskViewPanel(TaskProgressView<T> monitor) {
        super(monitor);
        BorderPane borderPane = new BorderPane();
        borderPane.getStyleClass().add((Object)"box");
        ListView listView = new ListView();
        listView.setPrefSize(500.0, 400.0);
        listView.setCellFactory(param -> new TaskCell());
        listView.setFocusTraversable(false);
        Bindings.bindContent((List)listView.getItems(), (ObservableList)monitor.getTasks());
        borderPane.setCenter((Node)listView);
        this.getChildren().add((Object)listView);
    }

    class TaskCell
    extends ListCell<T> {
        private ProgressBar progressBar;
        private Label titleText = new Label();
        private Label messageText;
        private T task;
        private BorderPane borderPane;

        public TaskCell() {
            this.titleText.getStyleClass().add((Object)"task-title");
            this.messageText = new Label();
            this.messageText.getStyleClass().add((Object)"task-message");
            this.progressBar = new ProgressBar();
            this.progressBar.setMaxWidth(Double.MAX_VALUE);
            this.progressBar.setMaxHeight(8.0);
            this.progressBar.getStyleClass().add((Object)"task-progress-bar");
            VBox vbox = new VBox();
            vbox.setSpacing(4.0);
            vbox.getChildren().add((Object)this.titleText);
            vbox.getChildren().add((Object)this.progressBar);
            vbox.getChildren().add((Object)this.messageText);
            this.borderPane = new BorderPane();
            this.borderPane.setCenter((Node)vbox);
            this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        }

        public void updateIndex(int index) {
            super.updateIndex(index);
            if (index == -1) {
                this.setGraphic(null);
                this.getStyleClass().setAll((Object[])new String[]{"task-list-cell-empty"});
            }
        }

        protected void updateItem(T task, boolean empty) {
            super.updateItem(task, empty);
            this.task = task;
            if (empty || task == null) {
                this.getStyleClass().setAll((Object[])new String[]{"task-list-cell-empty"});
                this.setGraphic(null);
            } else if (task != null) {
                this.getStyleClass().setAll((Object[])new String[]{"task-list-cell"});
                this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
                this.titleText.textProperty().bind((ObservableValue)task.titleProperty());
                this.messageText.textProperty().bind((ObservableValue)task.messageProperty());
                Callback factory = ((TaskProgressView)TaskViewPanel.this.getSkinnable()).getGraphicFactory();
                if (factory != null) {
                    Node graphic = (Node)factory.call(task);
                    if (graphic != null) {
                        BorderPane.setAlignment((Node)graphic, (Pos)Pos.CENTER);
                        BorderPane.setMargin((Node)graphic, (Insets)new Insets(0.0, 4.0, 0.0, 0.0));
                        this.borderPane.setLeft(graphic);
                    }
                } else {
                    this.borderPane.setLeft(null);
                }
                this.setGraphic((Node)this.borderPane);
            }
        }
    }
}

