/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.button;

import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SpringLayout;
import javax.swing.border.Border;

public class EFCDropDownButton
extends JButton {
    private static final long serialVersionUID = -3753313630321534866L;
    private AbstractButton mainbutton;
    private AbstractButton dropdown;
    private JPopupMenu menu = new JPopupMenu();

    private void initButtons() {
        if (this.mainbutton == null) {
            this.mainbutton = new JButton();
        }
        if (this.dropdown == null) {
            this.dropdown = new JButton(EFCLookAndFeelManager.ICON_TOOLBAR_DROPDOWN);
        }
    }

    public EFCDropDownButton() {
        super.setBorderPainted(false);
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.initButtons();
        this.dropdown.setIconTextGap(0);
        this.dropdown.setPreferredSize(new Dimension(6, 24));
        this.dropdown.setMaximumSize(new Dimension(10, 24));
        JToolBar bar = new JToolBar(0);
        bar.setFloatable(false);
        bar.add((Component)this.mainbutton, "Center");
        bar.add((Component)this.dropdown, "East");
        this.add(bar);
        layout.putConstraint("Height", (Component)this, 0, "Height", (Component)bar);
        layout.putConstraint("Width", (Component)this, 0, "Width", (Component)bar);
        this.dropdown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EFCDropDownButton.this.menu.show(EFCDropDownButton.this, EFCDropDownButton.this.mainbutton.getX(), EFCDropDownButton.this.mainbutton.getY() + EFCDropDownButton.this.mainbutton.getHeight());
            }
        });
        PropertyChangeListener propertylistener = new PropertyChangeListener(){
            private boolean active = true;

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (this.active) {
                    this.active = false;
                    if ("borderPainted".equals(evt.getPropertyName())) {
                        EFCDropDownButton.this.mainbutton.setBorderPainted((Boolean)evt.getNewValue());
                        EFCDropDownButton.this.dropdown.setBorderPainted((Boolean)evt.getNewValue());
                    }
                    this.active = true;
                }
            }
        };
        this.mainbutton.addPropertyChangeListener(propertylistener);
        this.dropdown.addPropertyChangeListener(propertylistener);
        this.validate();
    }

    public EFCDropDownButton(Action a) {
        this();
        this.mainbutton.setAction(a);
        this.validate();
    }

    public EFCDropDownButton(Icon icon) {
        this();
        this.mainbutton.setIcon(icon);
        this.validate();
    }

    public EFCDropDownButton(String text, Icon icon) {
        this();
        if (this.mainbutton != null) {
            this.mainbutton.setIcon(icon);
            this.mainbutton.setText(text);
        }
        this.validate();
    }

    public EFCDropDownButton(String text) {
        this();
        this.mainbutton.setText(text);
        this.validate();
    }

    public JMenuItem add(JMenuItem item) {
        return this.menu.add(item);
    }

    public void remove(JMenuItem submenu) {
        this.menu.remove(submenu);
    }

    public JMenuItem add(Action a) {
        return this.menu.add(a);
    }

    public void addSeparator() {
        this.menu.addSeparator();
    }

    public void setMenuEnabled(boolean enabled) {
        this.menu.setEnabled(enabled);
    }

    public boolean isMenuEnabled() {
        return this.menu.isEnabled();
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.initButtons();
        this.mainbutton.setEnabled(b);
    }

    @Override
    public void setLabel(String label) {
        this.initButtons();
        this.mainbutton.setText(label);
    }

    @Override
    public Action getAction() {
        this.initButtons();
        return this.mainbutton.getAction();
    }

    @Override
    public void setAction(Action a) {
        this.initButtons();
        this.mainbutton.setAction(a);
    }

    @Override
    public void setText(String text) {
        this.initButtons();
        this.mainbutton.setText(text);
    }

    @Override
    public String getText() {
        this.initButtons();
        return this.mainbutton.getText();
    }

    @Override
    public Icon getIcon() {
        this.initButtons();
        return this.mainbutton.getIcon();
    }

    @Override
    public void setIcon(Icon defaultIcon) {
        this.initButtons();
        this.mainbutton.setIcon(defaultIcon);
    }

    @Override
    public void addActionListener(ActionListener l) {
        this.initButtons();
        this.mainbutton.addActionListener(l);
    }

    @Override
    public void removeActionListener(ActionListener l) {
        this.initButtons();
        this.mainbutton.removeActionListener(l);
    }

    @Override
    public void addMouseListener(MouseListener l) {
        this.initButtons();
        this.mainbutton.addMouseListener(l);
        this.dropdown.addMouseListener(l);
    }

    @Override
    public void removeMouseListener(MouseListener l) {
        this.initButtons();
        this.mainbutton.removeMouseListener(l);
        this.dropdown.removeMouseListener(l);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener l) {
        this.initButtons();
        this.mainbutton.addMouseMotionListener(l);
        this.dropdown.addMouseMotionListener(l);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener l) {
        this.initButtons();
        this.mainbutton.removeMouseMotionListener(l);
        this.dropdown.removeMouseMotionListener(l);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener l) {
        this.initButtons();
        this.mainbutton.addMouseWheelListener(l);
        this.dropdown.addMouseWheelListener(l);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener l) {
        this.initButtons();
        this.mainbutton.removeMouseWheelListener(l);
        this.dropdown.removeMouseWheelListener(l);
    }

    @Override
    public boolean action(Event evt, Object what) {
        this.initButtons();
        return this.mainbutton.action(evt, what);
    }

    @Override
    public void setBorder(Border border) {
        this.initButtons();
        this.mainbutton.setBorder(border);
        this.dropdown.setBorder(border);
    }

    @Override
    public Border getBorder() {
        this.initButtons();
        return this.mainbutton.getBorder();
    }

    @Override
    public void setBorderPainted(boolean b) {
        this.initButtons();
        this.mainbutton.setBorderPainted(b);
        this.dropdown.setBorderPainted(b);
    }

    @Override
    public boolean isBorderPainted() {
        this.initButtons();
        return this.mainbutton.isBorderPainted();
    }

    @Override
    public void setHideActionText(boolean hideActionText) {
        this.initButtons();
        this.mainbutton.setHideActionText(hideActionText);
    }

    @Override
    public boolean getHideActionText() {
        this.initButtons();
        return this.mainbutton.getHideActionText();
    }

    public JPopupMenu getMenu() {
        this.initButtons();
        return this.menu;
    }

    public void setMenu(JPopupMenu menu) {
        this.initButtons();
        this.menu = menu;
    }
}

