/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.edgeicon;

import de.effectivecompany.gui.components.edgeicon.EIDrawer;
import de.effectivecompany.gui.interfaces.element.EdgeIconComponent;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.JTextArea;
import javax.swing.text.Document;

public class EITextArea
extends JTextArea
implements EdgeIconComponent {
    private static final long serialVersionUID = -1529142213577690600L;
    private ImageIcon[] edgeIcons = new ImageIcon[4];
    private boolean edgeIconsVisible = true;

    public EITextArea() {
    }

    public EITextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
    }

    public EITextArea(Document doc) {
        super(doc);
    }

    public EITextArea(int rows, int columns) {
        super(rows, columns);
    }

    public EITextArea(String text, int rows, int columns) {
        super(text, rows, columns);
    }

    public EITextArea(String text) {
        super(text);
    }

    @Override
    public ImageIcon getEdgeIcon(int edge) {
        return this.edgeIcons[edge - 1];
    }

    @Override
    public void setEdgeIcon(ImageIcon icon, int edge) {
        this.edgeIcons[edge - 1] = icon;
        this.repaint();
    }

    @Override
    public boolean isEdgeIconVisible() {
        return this.edgeIconsVisible;
    }

    @Override
    public void setEdgeIconVisible(boolean visible) {
        this.edgeIconsVisible = visible;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.edgeIconsVisible) {
            g.translate(0, 0);
            EIDrawer.drawEdgeIcons(this.edgeIcons, g, this, this);
        }
    }
}

