/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.edgeicon;

import de.effectivecompany.gui.components.edgeicon.EIDrawer;
import de.effectivecompany.gui.interfaces.element.EdgeIconComponent;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class EITextField
extends JTextField
implements EdgeIconComponent {
    private static final long serialVersionUID = 422974990156679670L;
    private ImageIcon[] edgeIcons = new ImageIcon[4];
    private boolean edgeIconsVisible = true;

    public EITextField() {
    }

    public EITextField(String text) {
        super(text);
    }

    public EITextField(int columns) {
        super(columns);
    }

    public EITextField(String text, int columns) {
        super(text, columns);
    }

    public EITextField(Document doc, String text, int columns) {
        super(doc, text, columns);
    }

    @Override
    public ImageIcon getEdgeIcon(int edge) {
        return this.edgeIcons[edge - 1];
    }

    @Override
    public void setEdgeIcon(ImageIcon icon, int edge) {
        this.edgeIcons[edge - 1] = icon;
        this.repaint();
    }

    @Override
    public boolean isEdgeIconVisible() {
        return this.edgeIconsVisible;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dim = super.getPreferredSize();
        dim.width = dim.width + this.getMargin().left + this.getMargin().right;
        return dim;
    }

    @Override
    public void setEdgeIconVisible(boolean visible) {
        this.edgeIconsVisible = visible;
        this.repaint();
    }

    @Override
    public void paste() {
        String text = null;
        try {
            text = (String)Toolkit.getDefaultToolkit().getSystemClipboard().getData(DataFlavor.stringFlavor);
        }
        catch (HeadlessException | UnsupportedFlavorException | IOException e) {
            e.printStackTrace();
        }
        if (text != null && !text.isEmpty()) {
            text = text.replace(System.getProperty("line.separator"), "").replace("\n", "");
            text = text.trim();
            this.replaceSelection(text);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (this.edgeIconsVisible) {
            g.translate(0, 0);
            EIDrawer.drawEdgeIcons(this.edgeIcons, g, this, this);
        }
    }
}

