/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.meta.TypeInfo;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.interfaces.EFCColumnEditor;
import de.effectivecompany.gui.components.editor.interfaces.EFCEditorView;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.swing.ImageIcon;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EFCAbstractAlphaNumericEditor
extends EFCAbstractPrimaryEditor
implements EFCEditorView,
EFCColumnEditor {
    private static Logger logger = LoggerFactory.getLogger(EFCAbstractAlphaNumericEditor.class);
    public static final long serialVersionUID = -6355L;
    protected EITextField textField = new EITextField(4);
    protected String originalData = "";
    private String redoString = null;
    private int maxChars = 255;

    public EFCAbstractAlphaNumericEditor(String ident) {
        super(ident, false, false, null, true);
    }

    public EFCAbstractAlphaNumericEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel) {
        this(ident, boModel, info, dropDownButtonEnabled, size, width, label, withLabel, null);
    }

    public EFCAbstractAlphaNumericEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel, String scbchrkey) {
        super(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        TypeInfo typeInfo;
        this.setBusinessObjectModel(boModel);
        this.setLayout(new BorderLayout());
        EFCAbstractEditor.TextFieldFocusChangeHandler focusListener = new EFCAbstractEditor.TextFieldFocusChangeHandler(this);
        StringUserInputHandler userInputHandler = new StringUserInputHandler(this.getIdent());
        this.textField.addKeyListener(userInputHandler);
        this.textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                boolean valid;
                JTextField tField = (JTextField)input;
                boolean bl = valid = tField.getText().length() <= EFCAbstractAlphaNumericEditor.this.getMaxChars();
                if (!valid) {
                    EFCDesktop.showErrorDlg(Translator.tr((String)"MSG_INPUTTEXT_TO_LONG"));
                }
                return valid;
            }
        });
        ((AbstractDocument)this.textField.getDocument()).setDocumentFilter(new DocumentFilter(){

            @Override
            public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
                logger.debug("insertString: " + string);
                super.insertString(fb, offset, string, attr);
            }

            @Override
            public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
                logger.debug("replace: " + text);
                if (text != null && !text.isEmpty()) {
                    text = text.replace(System.getProperty("line.separator"), "").replace("\n", "");
                }
                super.replace(fb, offset, length, text, attrs);
            }
        });
        this.textField.addMouseListener(userInputHandler);
        this.textField.addMouseWheelListener(userInputHandler);
        this.textField.addFocusListener(focusListener);
        this.textField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.textField.setSize((Dimension)this.textField.getPreferredSize().clone());
        this.textField.setMargin(UnitConverter.createPixelFromDLUInsets(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS, this.textField));
        this.setEditorSizing(0);
        this.reorganize();
        if (boModel != null && (typeInfo = boModel.getAttributeInfo(ident)).getMaxSize() > 0) {
            this.setColumns(typeInfo.getMaxSize());
            this.setMaxChars(typeInfo.getMaxSize());
        }
        this.initColumns(width, size);
    }

    @Override
    public void initColumns(int width, int size) {
        if (size > 0) {
            this.setColumns(size);
        }
        int charSize = 3 + (width - 1) * 14;
        charSize = this.setCharsize(width, charSize);
        if (this.getColumns() > charSize) {
            this.setColumns(charSize);
        }
        if (size > 0) {
            this.setPreferredSize((Dimension)this.getMinimumSize().clone());
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    protected boolean isCharValid(char ch) {
        return this.getText().length() < this.maxChars || this.getSelectionStart() != this.getSelectionEnd();
    }

    public String getText() {
        return this.textField.getText();
    }

    public int getSelectionStart() {
        return this.textField.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.textField.getSelectionEnd();
    }

    public void setText(String s) {
        this.textField.setText(s);
    }

    @Override
    public void setValue(Object value) {
        Object oldValue = this.getValue();
        if (this.textField != null) {
            if (value == null) {
                this.textField.setText("");
            } else if (value instanceof Type) {
                Object tval = ((Type)value).optainValue();
                if (tval != null) {
                    this.textField.setText(tval.toString());
                } else {
                    this.textField.setText(null);
                }
            } else {
                this.textField.setText(value.toString());
            }
            if (this.getEmptyStrategy() != -1) {
                this.setVisible(true);
                if (this.textField.getText().trim().equals("")) {
                    if (this.getEmptyStrategy() == 1) {
                        this.setVisible(true);
                        this.textField.setEditable(false);
                    }
                    if (this.getEmptyStrategy() == 2) {
                        this.setVisible(false);
                        this.textField.setEditable(false);
                    }
                }
            }
            this.setModified(false);
            this.fireValueResetEvent(this.getIdent(), oldValue, value);
            this.originalData = this.textField.getText();
            if (!this.isEnabled() || !this.isEditable()) {
                this.textField.setCaretPosition(0);
            }
        }
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    @Override
    public String getSimpleValue() {
        if (this.textField != null) {
            return this.textField.getText();
        }
        return "";
    }

    @Override
    public void undo() {
        logger.debug("StringEditor: undo");
        this.setModified(false);
        this.redoString = this.textField.getText();
        this.textField.setText(this.originalData);
    }

    @Override
    public void redo() {
        logger.debug("StringEditor: redo");
        if (this.redoString != null) {
            this.textField.setText(this.redoString);
            this.setModified(true);
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.textField.setVisible(aFlag);
        super.setVisible(aFlag);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.textField.setEditable(editable);
        if (!editable) {
            this.textField.setCaretPosition(0);
        }
        this.setComponentStyle(this.textField);
    }

    @Override
    public boolean isEditable() {
        return this.textField.isEditable();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
        if (this.dropDownButton != null) {
            this.dropDownButton.setEnabled(enabled && this.getMetadata().isReadOnly());
        }
        if (!enabled) {
            this.textField.setCaretPosition(0);
        }
        this.setComponentStyle(this.textField);
    }

    @Override
    public boolean isEnabled() {
        return this.textField.isEnabled();
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.textField.setEdgeIcon(img, edge);
    }

    @Override
    public void setColumns(int columns) {
        this.textField.setColumns(columns);
        if (columns > 0) {
            this.setEditorSizing(2);
        } else {
            this.setEditorSizing(1);
        }
        this.reorganize();
    }

    @Override
    public int getColumns() {
        return this.textField.getColumns();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.textField;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.textField = (EITextField)component;
    }

    @Override
    public void setMaxChars(int chars) {
        this.maxChars = chars;
    }

    public int getMaxChars() {
        return this.maxChars;
    }

    @Override
    public void terminate() {
        for (KeyListener keyListener : this.textField.getKeyListeners()) {
            this.textField.removeKeyListener(keyListener);
        }
        for (EventListener eventListener : this.textField.getMouseListeners()) {
            this.textField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.textField.getMouseWheelListeners()) {
            this.textField.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.textField.getFocusListeners()) {
            this.textField.removeFocusListener((FocusListener)eventListener);
        }
        this.removeAll();
        this.textField = null;
        super.terminate();
    }

    protected class StringUserInputHandler
    extends EFCAbstractEditor.UserInputHandler {
        public StringUserInputHandler(String ident) {
            super(EFCAbstractAlphaNumericEditor.this, ident);
        }

        @Override
        public void keyPressed(KeyEvent event) {
            if (event.isControlDown() && event.getKeyCode() == 67) {
                EFCAbstractAlphaNumericEditor.this.setModified(false);
            }
            super.keyPressed(event);
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (!event.isActionKey()) {
                if (!EFCAbstractAlphaNumericEditor.this.isCharValid(event.getKeyChar())) {
                    event.consume();
                } else {
                    EFCAbstractAlphaNumericEditor.this.setModified(true);
                }
            }
            super.keyTyped(event);
        }
    }
}

