/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.gui.data.SearchService;
import de.effectivecompany.base.gui.interfaces.SelectService;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCLabel;
import de.effectivecompany.gui.components.model.table.SelectServiceTableModel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCTable;
import de.effectivecompany.gui.components.swing.layout.HorizontalLineLayout;
import de.effectivecompany.gui.components.swing.popup.EFCSearchTablePopupMenu;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import de.effectivecompany.gui.events.UserInteractionEvent;
import de.effectivecompany.gui.interfaces.element.EditorComponent;
import de.effectivecompany.gui.interfaces.element.PrimaryEditorComponent;
import de.effectivecompany.gui.interfaces.listeners.FocusChangeListener;
import de.effectivecompany.gui.interfaces.listeners.UserInputListener;
import de.effectivecompany.gui.interfaces.listeners.UserInteractionListener;
import de.effectivecompany.gui.interfaces.listeners.ValueChangeListener;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EFCAbstractPrimaryEditor
extends EFCAbstractEditor
implements PrimaryEditorComponent {
    private static Logger logger = LoggerFactory.getLogger(EFCAbstractPrimaryEditor.class);
    private static final long serialVersionUID = -7795666910966821666L;
    private String keyattr;
    private SelectServiceTableModel primaryPopupTableModel;
    private boolean secondaryFieldActive;
    private SelectServiceTableModel secondaryPopupTableModel;
    protected EFCUnitFieldSubEditor secondaryEditor;
    protected JButton dropDownButton;
    protected EFCLabel infotext;
    protected JPopupMenu primaryPopupMenu;
    protected EFCTable primaryPopupTable;
    protected JPopupMenu secondaryPopupMenu;
    protected EFCTable secondaryPopupTable;
    protected EFCSearchTablePopupMenu searchPopupMenu;
    private boolean dropDownButtonEnabled;
    private boolean infoTextEnabled;

    public EFCAbstractPrimaryEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, info, dropDownButtonEnabled, label, withLabel, null);
    }

    public EFCAbstractPrimaryEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel, String scbchrkey) {
        super(ident, scbchrkey);
        this.infoTextEnabled = info;
        this.dropDownButtonEnabled = dropDownButtonEnabled;
        this.initComponents();
        this.reorganize();
        if (withLabel) {
            this.initLabelText(label);
        }
    }

    protected void checkPrimaryPopupInit() {
        if (this.primaryPopupMenu != null) {
            return;
        }
        this.primaryPopupMenu = new JPopupMenu("Popup");
        this.primaryPopupMenu.setLayout(new BorderLayout());
        this.createPrimaryPopupTable();
        this.disableDefaultEnterKeyBehaviour((JTable)((Object)this.primaryPopupTable));
        this.primaryPopupTable.setSelectionMode(0);
        this.primaryPopupMenu.add(this.createPrimaryPopupScroll());
        this.primaryPopupMenu.addPopupMenuListener(new PopupStateHandler(true));
    }

    private JScrollPane createPrimaryPopupScroll() {
        JScrollPane primaryPopupScroll = new JScrollPane((Component)((Object)this.primaryPopupTable));
        primaryPopupScroll.setPreferredSize(new Dimension(EFCLookAndFeelManager.PRIMARY_TABLE_WIDTH, EFCLookAndFeelManager.PRIMARY_TABLE_HEIGHT));
        primaryPopupScroll.setMaximumSize(new Dimension(EFCLookAndFeelManager.PRIMARY_TABLE_WIDTH, EFCLookAndFeelManager.PRIMARY_TABLE_HEIGHT));
        return primaryPopupScroll;
    }

    private void createPrimaryPopupTable() {
        this.primaryPopupTableModel = new SelectServiceTableModel();
        this.primaryPopupTable = new EFCTable(this.primaryPopupTableModel);
        this.primaryPopupTable.setHorizontalScrollEnabled(true);
        this.primaryPopupTable.addMouseListener(new PopupMouseClickHandler());
        this.primaryPopupTable.setAutoResizeMode(0);
    }

    protected void checkSecondaryPopupInit() {
        if (this.secondaryPopupMenu != null) {
            return;
        }
        this.secondaryPopupMenu = new JPopupMenu("Popup");
        this.secondaryPopupMenu.setLayout(new BorderLayout());
        this.secondaryPopupTableModel = new SelectServiceTableModel();
        this.secondaryPopupTable = new EFCTable(this.secondaryPopupTableModel);
        this.secondaryPopupTable.setHorizontalScrollEnabled(true);
        this.secondaryPopupTable.setAutoResizeMode(0);
        this.secondaryPopupTable.addMouseListener(new PopupMouseClickHandler());
        this.disableDefaultEnterKeyBehaviour((JTable)((Object)this.secondaryPopupTable));
        this.secondaryPopupTable.setSelectionMode(0);
        this.secondaryPopupMenu.add(this.createSecondaryPopupTable());
        this.secondaryPopupMenu.addPopupMenuListener(new PopupStateHandler(false));
    }

    private JScrollPane createSecondaryPopupTable() {
        JScrollPane secondaryPopupScroll = new JScrollPane((Component)((Object)this.secondaryPopupTable));
        secondaryPopupScroll.setPreferredSize(new Dimension(EFCLookAndFeelManager.SECONDARY_TABLE_WIDTH, EFCLookAndFeelManager.SECONDARY_TABLE_HEIGHT));
        secondaryPopupScroll.setMaximumSize(new Dimension(EFCLookAndFeelManager.SECONDARY_TABLE_WIDTH, EFCLookAndFeelManager.SECONDARY_TABLE_HEIGHT));
        return secondaryPopupScroll;
    }

    private void disableDefaultEnterKeyBehaviour(JTable table) {
        table.getInputMap(1).put(KeyStroke.getKeyStroke(10, 0), "SOME_ACTION");
        table.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "SOME_ACTION");
        AbstractAction action = new AbstractAction(){
            private static final long serialVersionUID = -2783835902590454456L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EFCAbstractPrimaryEditor.this.closePopupMenu();
            }
        };
        table.getActionMap().put("SOME_ACTION", action);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        if (this.dropDownButtonEnabled) {
            this.secondaryEditor = new EFCUnitFieldSubEditor();
            ImageIcon dropDownIcon = EFCLookAndFeelManager.ICON_BUTTON_POPUP_DROPDOWN;
            if (EFCLookAndFeelManager.SIZE_MULTIPLIER != 1.0) {
                dropDownIcon = new ImageIcon(dropDownIcon.getImage().getScaledInstance((int)((double)dropDownIcon.getIconWidth() * EFCLookAndFeelManager.SIZE_MULTIPLIER), (int)((double)dropDownIcon.getIconHeight() * EFCLookAndFeelManager.SIZE_MULTIPLIER), 4));
            }
            if (dropDownIcon != null) {
                this.initDrowDownButton(dropDownIcon);
            } else {
                this.dropDownButton = new JButton("\\/");
            }
            DropDownButtonHandler dropDownHandler = new DropDownButtonHandler();
            this.dropDownButton.addMouseListener(dropDownHandler);
            this.dropDownButton.addKeyListener(dropDownHandler);
            this.dropDownButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            });
            this.dropDownButton.setVisible(true);
        }
        if (this.infoTextEnabled) {
            this.initInfotext();
        }
    }

    private void initDrowDownButton(ImageIcon dropDownIcon) {
        this.dropDownButton = new JButton(dropDownIcon);
        Dimension size = new Dimension(dropDownIcon.getIconWidth(), dropDownIcon.getIconHeight());
        this.dropDownButton.setMinimumSize((Dimension)size.clone());
        this.dropDownButton.setPreferredSize((Dimension)size.clone());
        this.dropDownButton.setMaximumSize((Dimension)size.clone());
        this.dropDownButton.setMargin(new Insets(0, 0, 0, 0));
        this.dropDownButton.setBorderPainted(false);
        this.dropDownButton.setFocusable(false);
    }

    private void initInfotext() {
        this.infotext = new EFCLabel("");
        this.infotext.setFont(EFCLookAndFeelManager.FONT_FORM_INFOTEXT);
        this.infotext.setMinimumSize(new Dimension(0, 0));
        this.infotext.setForeground(EFCLookAndFeelManager.COLOR_INFOTEXT_TEXT);
        this.infotext.setBackground(EFCLookAndFeelManager.COLOR_INFOTEXT_BACKGROUND);
        this.infotext.setBorder(EFCLookAndFeelManager.STYLE_INFOTEXT_BORDER);
        this.infotext.setVisible(false);
        this.infotext.setHorizontalAlignment(2);
    }

    public void reorganize() {
        this.removeAll();
        this.setLayout(new HorizontalLineLayout());
        JComponent editor = this.getEditorComponent();
        if (editor != null) {
            this.add((Component)editor, (Object)(this.editorSizing == 1 ? HorizontalLineLayout.Sizing.MAXIMIZE : HorizontalLineLayout.Sizing.PREFERRED));
        }
        if (this.dropDownButton != null) {
            this.add((Component)this.dropDownButton, (Object)HorizontalLineLayout.Sizing.MINIMIZE);
        }
        if (this.infotext != null) {
            this.add((Component)this.infotext, (Object)HorizontalLineLayout.Sizing.MAXIMIZE);
        }
    }

    protected void closePopupMenu() {
        if (this.primaryPopupMenu != null) {
            this.primaryPopupMenu.setVisible(false);
        }
        if (this.secondaryPopupMenu != null) {
            this.secondaryPopupMenu.setVisible(false);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        JComponent editor = this.getEditorComponent();
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).setEditable(editable);
        }
        if (this.dropDownButton != null) {
            this.dropDownButton.setEnabled(editable && this.isEnabled());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getMetadata().isReadOnly()) {
            return;
        }
        super.setEnabled(enabled);
        JComponent editor = this.getEditorComponent();
        if (editor instanceof JComponent) {
            editor.setEnabled(enabled);
        }
        if (this.dropDownButton != null) {
            this.dropDownButton.setEnabled(this.isEditable() && this.isEnabled());
        }
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (this.linkedLabel != null) {
            this.linkedLabel.setVisible(aFlag);
        }
        super.setVisible(aFlag);
    }

    @Override
    public void setInfotext(String text) {
        if (this.infotext != null) {
            this.infotext.setText(text);
        }
    }

    @Override
    public String getInfotext() {
        if (this.infotext != null) {
            return this.infotext.getText();
        }
        return "";
    }

    @Override
    public JComponent getInfotextComponent() {
        return this.infotext;
    }

    @Override
    public void setInfotextVisible(boolean enabled) {
        if (this.infotext != null) {
            this.infotext.setVisible(enabled);
        }
    }

    @Override
    public boolean isInfotextVisible() {
        if (this.infotext != null) {
            return this.infotext.isVisible();
        }
        return false;
    }

    protected String getKeyattr() {
        return this.keyattr;
    }

    protected void setKeyattr(String keyattr) {
        this.keyattr = keyattr;
    }

    @Override
    public SelectService getPrimaryPopupService() {
        this.checkPrimaryPopupInit();
        return this.primaryPopupTableModel.getSelectService();
    }

    @Override
    public void setPrimaryPopupService(SelectService svc) {
        this.checkPrimaryPopupInit();
        this.primaryPopupTableModel.setSelectService(svc);
    }

    @Override
    public SelectService getSecondaryPopupService() {
        this.checkSecondaryPopupInit();
        return this.secondaryPopupTableModel.getSelectService();
    }

    @Override
    public void setSecondaryPopupService(SelectService svc) {
        this.checkSecondaryPopupInit();
        this.secondaryPopupTableModel.setSelectService(svc);
    }

    @Override
    public void removeSearchPopup() {
        this.setSearchPopupEnabled(false);
        if (this.searchPopupMenu != null) {
            this.searchPopupMenu.terminate();
        }
        this.searchPopupMenu = null;
    }

    @Override
    public void setSearchPopup(EFCController controller, SearchService svc, String searchlist, String searchListKey, String[] orderFields, String searchListFilter) {
        this.searchPopupMenu = new EFCSearchTablePopupMenu(controller, this, svc, searchlist, searchListKey, orderFields, searchListFilter);
    }

    @Override
    public void setSearchPopupEnabled(boolean enabled) {
        if (this.searchPopupMenu != null) {
            this.searchPopupMenu.setEnabled(enabled);
            if (enabled) {
                this.setEdgeImage(EFCLookAndFeelManager.ICON_FIELDINFO_QUICKSEARCH, 4);
            } else {
                this.setEdgeImage(null, 4);
            }
        }
    }

    @Override
    public boolean isPopupEnabled() {
        if (this.dropDownButton != null) {
            return this.dropDownButton.isVisible();
        }
        return false;
    }

    @Override
    public void setPopupEnabled(boolean enable) {
        if (this.dropDownButton != null) {
            this.dropDownButton.setVisible(enable);
        }
    }

    @Override
    public void setSecondaryPopupActive(boolean enable) {
        this.secondaryFieldActive = enable;
    }

    @Override
    public boolean isSecondaryPopupActive() {
        return this.secondaryFieldActive;
    }

    @Override
    public boolean isSearchPopupActive() {
        return this.searchPopupMenu != null;
    }

    @Override
    public String getSecondaryIdent() {
        if (this.secondaryEditor != null) {
            return this.secondaryEditor.getIdent();
        }
        return null;
    }

    @Override
    public void setSecondaryIdent(String ident) {
        if (this.secondaryEditor != null) {
            this.secondaryEditor.setIdent(ident);
        }
    }

    public void reloadPopupServiceData(Map<String, String> param) {
        if (this.isSecondaryPopupActive()) {
            this.secondaryPopupTableModel.loadData(param);
            EFCColumnResizer.adjustSecondaryPopupTableColumnPreferredWidths((JTable)((Object)this.secondaryPopupTable));
        } else {
            this.primaryPopupTableModel.loadData(param);
        }
    }

    protected void onPopupOpen(String ident) {
    }

    protected void onPopupClose(String ident, Object oldValue, Object newValue) {
    }

    @Override
    public EditorComponent getSecondaryEditor() {
        return this.secondaryEditor;
    }

    @Override
    public void terminate() {
        if (this.primaryPopupTable != null) {
            for (MouseListener mouseListener : this.primaryPopupTable.getMouseListeners()) {
                this.primaryPopupTable.removeMouseListener(mouseListener);
                Object var4_4 = null;
            }
            this.primaryPopupTable.removeAll();
            this.primaryPopupTable = null;
        }
        if (this.secondaryPopupTable != null) {
            for (EventListener eventListener : this.secondaryPopupTable.getMouseListeners()) {
                this.secondaryPopupTable.removeMouseListener((MouseListener)eventListener);
                Object var4_8 = null;
            }
            this.secondaryPopupTable.removeAll();
            this.secondaryPopupTable = null;
        }
        if (this.searchPopupMenu != null) {
            this.searchPopupMenu.terminate();
        }
        if (this.secondaryPopupMenu != null) {
            for (EventListener eventListener : this.secondaryPopupMenu.getPopupMenuListeners()) {
                this.secondaryPopupMenu.removePopupMenuListener((PopupMenuListener)eventListener);
            }
            this.secondaryPopupMenu.removeAll();
            this.secondaryPopupMenu = null;
        }
        if (this.primaryPopupMenu != null) {
            for (EventListener eventListener : this.primaryPopupMenu.getPopupMenuListeners()) {
                this.primaryPopupMenu.removePopupMenuListener((PopupMenuListener)eventListener);
            }
            this.primaryPopupMenu.removeAll();
            this.primaryPopupMenu = null;
        }
        if (this.searchPopupMenu != null) {
            for (PopupMenuListener popupMenuListener : this.searchPopupMenu.getPopupMenuListeners()) {
                this.searchPopupMenu.removePopupMenuListener(popupMenuListener);
            }
            this.searchPopupMenu.removeAll();
            this.searchPopupMenu = null;
        }
        if (this.primaryPopupTableModel != null) {
            this.primaryPopupTableModel = null;
        }
        if (this.secondaryPopupTableModel != null) {
            this.secondaryPopupTableModel = null;
        }
        if (this.dropDownButton != null) {
            for (MouseListener mouseListener : this.dropDownButton.getMouseListeners()) {
                this.dropDownButton.removeMouseListener(mouseListener);
            }
            for (KeyListener keyListener : this.dropDownButton.getKeyListeners()) {
                this.dropDownButton.removeKeyListener(keyListener);
            }
            for (ActionListener actionListener : this.dropDownButton.getActionListeners()) {
                this.dropDownButton.removeActionListener(actionListener);
            }
        }
        for (FocusChangeListener focusChangeListener : this.getFocusChangeListeners()) {
            this.removeFocusChangeListener(focusChangeListener);
        }
        for (ValueChangeListener valueChangeListener : this.getValueChangeListeners()) {
            this.removeValueChangeListener(valueChangeListener);
        }
        for (UserInputListener userInputListener : this.getUserInputListeners()) {
            this.removeUserInputListener(userInputListener);
        }
        for (UserInteractionListener userInteractionListener : this.getUserInteractionListeners()) {
            this.removeUserInteractionListener(userInteractionListener);
        }
        this.secondaryEditor = null;
        this.infotext = null;
        this.dropDownButton = null;
        super.terminate();
    }

    public void setDropDownButtonEnabled(boolean dropDownButtonEnabled) {
        this.dropDownButtonEnabled = dropDownButtonEnabled;
    }

    public void setInfoTextEnabled(boolean infoTextEnabled) {
        this.infoTextEnabled = infoTextEnabled;
    }

    protected int setCharsize(int width, int charSize) {
        if (width > 2) {
            charSize -= width - 2;
        }
        return charSize;
    }

    protected void initLabelText(String label) {
        Object labelText = this.getIdent();
        if (label != null && !label.equals("")) {
            if (label.startsWith(".")) {
                labelText = label.replaceFirst(".", "");
                JLabel linkedlabel = new JLabel(Translator.tr((String)labelText));
                linkedlabel.setFont(EFCLookAndFeelManager.FONT_FORM_LABEL);
                linkedlabel.setVerticalAlignment(0);
                this.setLinkedLabel(linkedlabel);
                return;
            }
            labelText = label;
        }
        if (labelText != null) {
            if (((String)labelText).contains(".")) {
                labelText = ((String)labelText).substring(((String)labelText).lastIndexOf(".") + 1);
            }
            labelText = "FLD_" + ((String)labelText).toUpperCase();
            String toolTip = (String)labelText + "_DESC";
            JLabel linkedlabel = new JLabel(Translator.tr((String)labelText));
            linkedlabel.setToolTipText(Translator.tr((String)toolTip));
            linkedlabel.setFont(EFCLookAndFeelManager.FONT_FORM_LABEL);
            linkedlabel.setVerticalAlignment(0);
            this.setLinkedLabel(linkedlabel);
        }
    }

    public class EFCUnitFieldSubEditor
    extends EFCAbstractEditor {
        static final long serialVersionUID = -6354L;
        private Object value;
        private String keyAttr;

        private EFCUnitFieldSubEditor() {
            super("");
        }

        @Override
        public JComponent getEditorComponent() {
            return null;
        }

        public void setKeyAttr(String keyAttr) {
            this.keyAttr = keyAttr;
        }

        public String getKeyAttr() {
            return this.keyAttr;
        }

        @Override
        public Object getValue() {
            return this.value;
        }

        @Override
        public Object getSimpleValue() {
            return this.value;
        }

        @Override
        public void setValue(Object value) {
            EFCAbstractPrimaryEditor.this.checkSecondaryPopupInit();
            this.value = value;
            if (this.keyAttr == null) {
                logger.error("no key attr set for {}", (Object)this.getIdent());
                return;
            }
        }

        public void reloadPopupServiceData(Map<String, String> param) {
            EFCAbstractPrimaryEditor.this.reloadPopupServiceData(param);
        }

        @Override
        public void setEditorComponent(JComponent component) {
        }
    }

    protected class DropDownButtonHandler
    extends MouseAdapter
    implements KeyListener {
        protected DropDownButtonHandler() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            this.handleKey(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.handleKey(e);
        }

        @Override
        public void keyTyped(KeyEvent e) {
            this.handleKey(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.handle();
            e.consume();
        }

        private void handleKey(KeyEvent e) {
            if (e.getKeyCode() == 40 && e.getModifiers() == 0) {
                this.handle();
                e.consume();
            }
        }

        private void handle() {
            if (EFCAbstractPrimaryEditor.this.dropDownButton != null && !EFCAbstractPrimaryEditor.this.dropDownButton.isEnabled() || EFCAbstractPrimaryEditor.this.dropDownButton == null) {
                return;
            }
            if (EFCAbstractPrimaryEditor.this.secondaryFieldActive) {
                EFCAbstractPrimaryEditor.this.checkSecondaryPopupInit();
            } else {
                EFCAbstractPrimaryEditor.this.checkPrimaryPopupInit();
            }
            JPopupMenu activeMenu = EFCAbstractPrimaryEditor.this.secondaryFieldActive ? EFCAbstractPrimaryEditor.this.secondaryPopupMenu : EFCAbstractPrimaryEditor.this.primaryPopupMenu;
            EFCTable activeTable = EFCAbstractPrimaryEditor.this.secondaryFieldActive ? EFCAbstractPrimaryEditor.this.secondaryPopupTable : EFCAbstractPrimaryEditor.this.primaryPopupTable;
            JComponent editor = EFCAbstractPrimaryEditor.this.getEditorComponent();
            if (activeMenu.isVisible()) {
                activeMenu.setVisible(false);
            } else {
                EFCAbstractPrimaryEditor.this.setFocusHandling(false);
                try {
                    if (!EFCAbstractPrimaryEditor.this.secondaryFieldActive) {
                        activeMenu.show(EFCAbstractPrimaryEditor.this, editor.getX(), editor.getY() + editor.getHeight());
                    } else {
                        activeMenu.show(EFCAbstractPrimaryEditor.this, EFCAbstractPrimaryEditor.this.dropDownButton.getX(), EFCAbstractPrimaryEditor.this.dropDownButton.getY() + EFCAbstractPrimaryEditor.this.dropDownButton.getHeight());
                    }
                    activeTable.requestFocusInWindow();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    EFCDesktop.reportError(ex);
                }
            }
        }
    }

    private class PopupStateHandler
    implements PopupMenuListener {
        private boolean forPrimary;
        private Key onOpenKey;

        public PopupStateHandler(boolean forPrimary) {
            this.forPrimary = forPrimary;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            int viewIndex;
            Object value;
            logger.debug("PopupStateHandler.popupMenuWillBecomeVisible()");
            String keyAttr = this.forPrimary ? EFCAbstractPrimaryEditor.this.getKeyattr() : EFCAbstractPrimaryEditor.this.secondaryEditor.getKeyAttr();
            Object keyValue = null;
            Object object = value = this.forPrimary ? EFCAbstractPrimaryEditor.this.getValue() : EFCAbstractPrimaryEditor.this.secondaryEditor.getValue();
            if (value != null) {
                keyValue = ObjectUtil2.getObjectAttributeByName((Object)value, (String)keyAttr);
            }
            EFCAbstractPrimaryEditor src = EFCAbstractPrimaryEditor.this;
            String ident = this.forPrimary ? EFCAbstractPrimaryEditor.this.getIdent() : EFCAbstractPrimaryEditor.this.getSecondaryIdent();
            UserInteractionEvent uiEvent = new UserInteractionEvent(src, 2039, ident);
            for (UserInteractionListener l : EFCAbstractPrimaryEditor.this.getUserInteractionListeners()) {
                l.onUserInteraction(uiEvent);
            }
            if (this.forPrimary) {
                int selected = EFCAbstractPrimaryEditor.this.primaryPopupTableModel.indexOf(value);
                this.onOpenKey = EFCAbstractPrimaryEditor.this.primaryPopupTableModel.getKeyAt(selected);
                EFCAbstractPrimaryEditor.this.primaryPopupTable.clearSelection();
                if (selected >= 0) {
                    viewIndex = EFCAbstractPrimaryEditor.this.primaryPopupTable.convertColumnIndexToView(selected);
                    EFCAbstractPrimaryEditor.this.primaryPopupTable.addRowSelectionInterval(viewIndex, viewIndex);
                }
            } else {
                int selected = EFCAbstractPrimaryEditor.this.secondaryPopupTableModel.firstIndexOfValue(keyAttr, keyValue);
                this.onOpenKey = EFCAbstractPrimaryEditor.this.secondaryPopupTableModel.getKeyAt(selected);
                EFCAbstractPrimaryEditor.this.secondaryPopupTable.clearSelection();
                if (selected >= 0) {
                    viewIndex = EFCAbstractPrimaryEditor.this.secondaryPopupTable.convertRowIndexToView(selected);
                    EFCAbstractPrimaryEditor.this.secondaryPopupTable.addRowSelectionInterval(viewIndex, viewIndex);
                }
            }
            EFCAbstractPrimaryEditor.this.onPopupOpen(ident);
            EFCAbstractPrimaryEditor.this.setFocusHandling(true);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
            logger.debug("PopupStateHandler.popupMenuWillBecomeInvisible()");
            this.handleCloseEvent(event);
            EFCAbstractPrimaryEditor src = EFCAbstractPrimaryEditor.this;
            String ident = !this.forPrimary ? EFCAbstractPrimaryEditor.this.getSecondaryIdent() : EFCAbstractPrimaryEditor.this.getIdent();
            UserInteractionEvent uiEvent = new UserInteractionEvent(src, 2040, ident);
            for (UserInteractionListener listener : EFCAbstractPrimaryEditor.this.getUserInteractionListeners()) {
                listener.onUserInteraction(uiEvent);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private void handleCloseEvent(PopupMenuEvent event) {
            try {
                String ident;
                EFCTable table = this.forPrimary ? EFCAbstractPrimaryEditor.this.primaryPopupTable : EFCAbstractPrimaryEditor.this.secondaryPopupTable;
                int selectedRow = table.getSelectedRow();
                if (selectedRow == -1) {
                    return;
                }
                SelectServiceTableModel model = this.forPrimary ? EFCAbstractPrimaryEditor.this.primaryPopupTableModel : EFCAbstractPrimaryEditor.this.secondaryPopupTableModel;
                SelectService svc = model.getSelectService();
                Key newKey = model.getKeyAt(table.convertRowIndexToModel(selectedRow));
                String string = ident = this.forPrimary ? EFCAbstractPrimaryEditor.this.getIdent() : EFCAbstractPrimaryEditor.this.getSecondaryIdent();
                if (newKey == null) {
                    this.handleNewValue(ident, null, null);
                } else if (!newKey.equals((Object)this.onOpenKey)) {
                    if (svc != null) {
                        Object newValue = svc.getObj(newKey);
                        if (this.onOpenKey == null) {
                            this.handleNewValue(ident, null, newValue);
                        } else {
                            this.handleNewValue(ident, svc.getObj(this.onOpenKey), newValue);
                        }
                    } else {
                        this.handleNewValue(ident, this.onOpenKey, newKey);
                    }
                    this.onOpenKey = newKey;
                }
            }
            catch (Exception ex) {
                EFCDesktop.reportError(ex);
            }
        }

        private void handleNewValue(String ident, Object oldValue, Object newValue) {
            if (this.forPrimary) {
                EFCAbstractPrimaryEditor.this.onPopupClose(ident, oldValue, newValue);
            } else {
                if (EFCAbstractPrimaryEditor.this.getBusinessObjectModel() != null) {
                    EFCAbstractPrimaryEditor.this.getBusinessObjectModel().setLastSelectedListItemIndex();
                }
                EFCAbstractPrimaryEditor.this.secondaryEditor.setValue(newValue);
                EFCAbstractPrimaryEditor.this.fireValueChangeEvent(ident, oldValue, newValue);
            }
        }
    }

    private class PopupMouseClickHandler
    extends MouseAdapter {
        private PopupMouseClickHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            if (event.getClickCount() == 2 && event.getButton() == 1) {
                event.consume();
                EFCAbstractPrimaryEditor.this.closePopupMenu();
            }
        }
    }
}

