/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCBoolean;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;

public class EFCBooleanEditor
extends EFCAbstractPrimaryEditor {
    static final long serialVersionUID = -6354L;
    protected JCheckBox checkBox;
    protected Boolean oldValue = null;
    private boolean editable = true;
    private boolean enable = true;
    private boolean nullValue = true;

    public EFCBooleanEditor(String ident, boolean info, boolean dropDownButtonEnabled) {
        super(ident, info, dropDownButtonEnabled, null, true);
        this.setLayout(new FlowLayout(0, 0, 0));
    }

    public EFCBooleanEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, boModel, info, dropDownButtonEnabled, label, withLabel, null);
    }

    public EFCBooleanEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel, String scbchrkey) {
        super(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        this.setBusinessObjectModel(boModel);
        this.setLayout(new FlowLayout(0, 0, 0));
    }

    @Override
    protected void initComponents() {
        EFCAbstractEditor.FocusChangeHandler focusListener = new EFCAbstractEditor.FocusChangeHandler();
        CheckChangeHandler actionListener = new CheckChangeHandler();
        EFCAbstractEditor.UserInputHandler userInputHandler = new EFCAbstractEditor.UserInputHandler(this.getIdent()){

            @Override
            public void keyPressed(KeyEvent event) {
                super.keyPressed(event);
                if (event.getKeyCode() == 10) {
                    EFCBooleanEditor.this.checkBox.doClick();
                }
            }
        };
        this.checkBox = new JCheckBox(this.getIdent());
        this.checkBox.addFocusListener(focusListener);
        this.checkBox.addActionListener(actionListener);
        this.checkBox.addKeyListener(userInputHandler);
        this.checkBox.addMouseListener(userInputHandler);
        this.checkBox.addMouseWheelListener(userInputHandler);
        this.add(this.checkBox);
        this.setFont(EFCLookAndFeelManager.FONT_FORM_LABEL);
    }

    public void setLabelText(String text) {
        this.checkBox.setText(text);
    }

    public String getLabelText() {
        return this.checkBox.getText();
    }

    @Override
    public void setValue(Object value) {
        Boolean newValue = null;
        this.oldValue = this.checkBox.isSelected();
        boolean bl = this.nullValue = value == null;
        if (value == null) {
            newValue = false;
        } else if (value instanceof Boolean) {
            newValue = (Boolean)value;
        } else if (value instanceof EFCBoolean) {
            newValue = ((EFCBoolean)value).getBoolean();
        } else {
            throw new IllegalArgumentException("value has to be a boolean or EFCBoolean");
        }
        this.checkBox.setEnabled(this.enable && this.editable);
        this.checkBox.setSelected(newValue == null ? false : newValue);
        this.fireValueResetEvent(this.getIdent(), this.oldValue, newValue);
        this.oldValue = newValue;
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue() != null ? this.getSimpleValue().toString() : null;
    }

    public EFCBoolean getValue() {
        if (this.nullValue) {
            return new EFCBoolean();
        }
        return new EFCBoolean(Boolean.valueOf(this.checkBox.isSelected()));
    }

    @Override
    public Boolean getSimpleValue() {
        return this.checkBox.isSelected();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getMetadata().isReadOnly()) {
            this.checkBox.setForeground(SystemColor.GRAY);
            return;
        }
        this.enable = enabled;
        this.checkBox.setEnabled(this.enable && this.editable);
        this.checkBox.setForeground(SystemColor.BLACK);
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }

    @Override
    public void setEditable(boolean edit) {
        this.editable = edit;
        this.checkBox.setEnabled(this.enable && this.editable);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setForeground(Color fg) {
        if (this.checkBox != null) {
            this.checkBox.setForeground(fg);
        }
    }

    @Override
    public void setBackground(Color bg) {
        if (this.checkBox != null) {
            this.checkBox.setBackground(bg);
        }
    }

    @Override
    public void setVisible(boolean visible) {
        this.checkBox.setVisible(visible);
        super.setVisible(visible);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        if (this.checkBox != null) {
            this.checkBox.setFont(font);
        }
    }

    @Override
    public JComponent getEditorComponent() {
        return this.checkBox;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.checkBox = (JCheckBox)component;
    }

    @Override
    public void setToolTipText(String text) {
        this.checkBox.setToolTipText(text);
    }

    @Override
    public void terminate() {
        for (FocusListener focusListener : this.checkBox.getFocusListeners()) {
            this.checkBox.removeFocusListener(focusListener);
        }
        for (EventListener eventListener : this.checkBox.getActionListeners()) {
            this.checkBox.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.checkBox.getKeyListeners()) {
            this.checkBox.removeKeyListener((KeyListener)eventListener);
        }
        for (EventListener eventListener : this.checkBox.getMouseListeners()) {
            this.checkBox.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.checkBox.getMouseWheelListeners()) {
            this.checkBox.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        this.removeAll();
        super.terminate();
    }

    @Override
    protected void initLabelText(String label) {
        Object labelText = this.getIdent();
        if (label != null && !label.equals("")) {
            if (label.startsWith(".")) {
                labelText = label.replaceFirst(".", "");
                this.setLabelText((String)labelText);
                return;
            }
            labelText = label;
        }
        if (((String)labelText).contains(".")) {
            labelText = ((String)labelText).substring(((String)labelText).lastIndexOf(".") + 1);
        }
        labelText = "FLD_" + ((String)labelText).toUpperCase();
        this.setLabelText(Translator.tr((String)labelText));
        String toolTip = (String)labelText + "_DESC";
        this.setToolTipText(Translator.tr((String)toolTip));
    }

    public EFCBoolean getOriginalValue() {
        return (EFCBoolean)super.getOriginalValue();
    }

    private class CheckChangeHandler
    implements ActionListener {
        private CheckChangeHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Boolean eOldValue = EFCBooleanEditor.this.oldValue;
            Boolean eNewValue = EFCBooleanEditor.this.checkBox.isSelected();
            EFCBooleanEditor.this.nullValue = false;
            EFCBooleanEditor.this.fireValueChangeEvent(EFCBooleanEditor.this.getIdent(), new EFCBoolean(eOldValue), new EFCBoolean(eNewValue));
            EFCBooleanEditor.this.setModified(true);
            EFCBooleanEditor.this.oldValue = eNewValue;
        }
    }
}

