/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCCalMonth;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.actions.EFCActionSave;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.swing.layout.HorizontalLineLayout;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;

public class EFCCalMonthYearEditor
extends EFCAbstractPrimaryEditor {
    private static final long serialVersionUID = -9005151749652244579L;
    protected EITextField monthField;
    protected EITextField yearField;

    public EFCCalMonthYearEditor(String ident, boolean info, boolean dropDownButtonEnabled) {
        super(ident, info, dropDownButtonEnabled, null, true);
    }

    public EFCCalMonthYearEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        this.setBusinessObjectModel(boModel);
    }

    @Override
    public boolean isEditable() {
        return this.yearField.isEditable();
    }

    @Override
    public boolean isEnabled() {
        return this.yearField.isEnabled();
    }

    @Override
    protected void setComponentStyle(JComponent component) {
        if (this.isEnabled()) {
            component.setBackground(SystemColor.window);
        } else {
            component.setBackground(SystemColor.control);
        }
        if (this.isEditable() && !this.getMetadata().isReadOnly()) {
            component.setForeground(SystemColor.BLACK);
        } else {
            component.setForeground(SystemColor.GRAY);
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setDisabledTextColor(component.getForeground());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        JComponent editor = this.getEditorComponent();
        if (this.getMetadata().isReadOnly()) {
            return;
        }
        super.setEnabled(enabled);
        if (editor instanceof JComponent) {
            editor.setEnabled(enabled);
        }
        this.monthField.setEnabled(enabled);
        this.yearField.setEnabled(enabled);
        this.setComponentStyle(this.monthField);
        this.setComponentStyle(this.yearField);
    }

    @Override
    public void setEditable(boolean editable) {
        JComponent editor = this.getEditorComponent();
        if (editor instanceof JTextComponent) {
            ((JTextComponent)editor).setEditable(editable);
        }
        this.monthField.setEditable(editable);
        this.yearField.setEditable(editable);
        this.setComponentStyle(this.monthField);
        this.setComponentStyle(this.yearField);
    }

    @Override
    public void setValue(Object value) {
        String text = "";
        this.setModified(false);
        if (value instanceof Type) {
            if (value instanceof EFCInteger) {
                text = ((EFCInteger)value).toString();
            }
            if (value instanceof EFCString) {
                text = ((EFCString)value).getData();
            }
        } else {
            String string = text = value == null ? "" : value.toString();
        }
        if ("0".equals(text) || "".equals(text) || value == null) {
            this.monthField.setText("");
            this.yearField.setText("");
            return;
        }
        if (!text.matches("[0-9]+") || text.length() != 6) {
            if (text.matches("[0-9]+")) {
                this.monthField.setText("");
                this.yearField.setText("");
                return;
            }
            throw new IllegalArgumentException("value must be a 6 digit integer or string, got: " + text);
        }
        String month = text.substring(4);
        String year = text.substring(0, 4);
        this.monthField.setText(month);
        this.yearField.setText(year);
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    public EFCCalMonth getValue() {
        this.validateEditors();
        String month = this.monthField.getText();
        String year = this.yearField.getText();
        if (month != null && !month.isEmpty() && year != null && !year.isEmpty()) {
            return new EFCCalMonth(year + month);
        }
        return new EFCCalMonth();
    }

    private void validateEditors() {
        Integer numMonth = null;
        Integer numYear = null;
        Object month = this.monthField.getText();
        Object year = this.yearField.getText();
        if (month != null && !((String)month).isEmpty()) {
            while (((String)month).length() < 2) {
                month = "0" + (String)month;
            }
            numMonth = Integer.parseInt((String)month);
        }
        this.monthField.setText((String)month);
        if (year != null && !((String)year).isEmpty()) {
            if (((String)year).length() == 1 || ((String)year).length() == 2) {
                numYear = Integer.parseInt((String)year);
                numYear = numYear < 50 ? 2000 + numYear : 1900 + numYear;
                year = "" + numYear;
                this.yearField.setText((String)year);
            }
            while (((String)year).length() < 4) {
                year = "0" + (String)year;
            }
            numYear = Integer.parseInt((String)year);
        }
        if (numYear != null && (numYear < 1000 || numYear > 4000)) {
            this.yearField.setEdgeIcon(EFCLookAndFeelManager.ICON_FIELDINFO_ERROR, 4);
            this.yearField.setBackground(Color.RED);
        } else {
            this.yearField.setEdgeIcon(null, 4);
            if (this.isEnabled()) {
                this.yearField.setBackground(Color.WHITE);
            }
        }
        if (numMonth != null && (numMonth < 1 || numMonth > 12)) {
            this.monthField.setEdgeIcon(EFCLookAndFeelManager.ICON_FIELDINFO_ERROR, 4);
            this.monthField.setBackground(Color.RED);
        } else {
            this.monthField.setEdgeIcon(null, 4);
            if (this.isEnabled()) {
                this.monthField.setBackground(Color.WHITE);
            }
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        EFCAbstractEditor.UserInputHandler inputHandler = new EFCAbstractEditor.UserInputHandler(this.getIdent());
        KeyHandler keyHandler = new KeyHandler();
        FocusChangeHandler focusChangeHandler = new FocusChangeHandler();
        this.monthField = new EITextField(2);
        this.yearField = new EITextField(4);
        this.monthField.addKeyListener(keyHandler);
        this.yearField.addKeyListener(keyHandler);
        this.monthField.addFocusListener(focusChangeHandler);
        this.yearField.addFocusListener(focusChangeHandler);
        this.monthField.setHorizontalAlignment(4);
        this.yearField.setHorizontalAlignment(4);
        this.monthField.addKeyListener(inputHandler);
        this.monthField.addMouseListener(inputHandler);
        this.monthField.addMouseWheelListener(inputHandler);
        this.yearField.addKeyListener(inputHandler);
        this.yearField.addMouseListener(inputHandler);
        this.yearField.addMouseWheelListener(inputHandler);
    }

    @Override
    public void reorganize() {
        this.removeAll();
        this.setLayout(new HorizontalLineLayout());
        this.add((Component)this.monthField, (Object)HorizontalLineLayout.Sizing.PREFERRED);
        this.add((Component)this.yearField, (Object)HorizontalLineLayout.Sizing.PREFERRED);
    }

    @Override
    public String getSimpleValue() {
        this.validateEditors();
        String month = this.monthField.getText();
        String year = this.yearField.getText();
        return year + month;
    }

    @Override
    public JComponent getEditorComponent() {
        return null;
    }

    @Override
    public void setEditorComponent(JComponent component) {
    }

    @Override
    public void terminate() {
        for (KeyListener keyListener : this.monthField.getKeyListeners()) {
            this.monthField.removeKeyListener(keyListener);
        }
        for (KeyListener keyListener : this.yearField.getKeyListeners()) {
            this.yearField.removeKeyListener(keyListener);
        }
        for (EventListener eventListener : this.monthField.getFocusListeners()) {
            this.monthField.removeFocusListener((FocusListener)eventListener);
        }
        for (EventListener eventListener : this.yearField.getFocusListeners()) {
            this.yearField.removeFocusListener((FocusListener)eventListener);
        }
        for (EventListener eventListener : this.monthField.getMouseListeners()) {
            this.monthField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.yearField.getMouseListeners()) {
            this.yearField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.monthField.getMouseWheelListeners()) {
            this.monthField.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.yearField.getMouseWheelListeners()) {
            this.yearField.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        this.removeAll();
        this.monthField = null;
        this.yearField = null;
        super.terminate();
    }

    public EFCCalMonth getOriginalValue() {
        return (EFCCalMonth)super.getOriginalValue();
    }

    private class FocusChangeHandler
    implements FocusListener {
        private String onFocusValue = null;

        private FocusChangeHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getOppositeComponent() == EFCCalMonthYearEditor.this.monthField || e.getOppositeComponent() == EFCCalMonthYearEditor.this.yearField) {
                return;
            }
            this.onFocusValue = EFCCalMonthYearEditor.this.getSimpleValue();
            EFCCalMonthYearEditor.this.fireFocusGainedEvent(EFCCalMonthYearEditor.this.getIdent());
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!EFCCalMonthYearEditor.this.doFocusHandling || e.getOppositeComponent() instanceof JButton && ((JButton)e.getOppositeComponent()).getAction() instanceof EFCActionSave) {
                return;
            }
            EFCCalMonthYearEditor.this.validateEditors();
            if (e.getOppositeComponent() == EFCCalMonthYearEditor.this.monthField || e.getOppositeComponent() == EFCCalMonthYearEditor.this.yearField) {
                return;
            }
            String oldVal = this.onFocusValue;
            String newVal = EFCCalMonthYearEditor.this.getSimpleValue();
            if (oldVal.equals(newVal)) {
                return;
            }
            EFCCalMonthYearEditor.this.fireValueChangeEvent(EFCCalMonthYearEditor.this.getIdent(), new EFCCalMonth(oldVal), new EFCCalMonth(newVal));
            EFCCalMonthYearEditor.this.fireFocusLostEvent(EFCCalMonthYearEditor.this.getIdent());
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (!event.isConsumed()) {
                char ch = event.getKeyChar();
                if (ch != '\b' && ch != '\u007f' && ch != '\n' && ch != '\t' && !Character.isDigit(ch)) {
                    event.consume();
                } else if (Character.isDigit(ch) && (event.getSource() == EFCCalMonthYearEditor.this.monthField && EFCCalMonthYearEditor.this.monthField.getText().length() >= 2 || event.getSource() == EFCCalMonthYearEditor.this.yearField && EFCCalMonthYearEditor.this.yearField.getText().length() >= 4)) {
                    if (((EITextField)event.getSource()).getSelectedText() == null) {
                        event.consume();
                    }
                } else {
                    EFCCalMonthYearEditor.this.setModified(true);
                }
            }
            super.keyTyped(event);
        }
    }
}

