/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCCalWeek;
import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.actions.EFCActionSave;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.jcalendar.calendar.EFCDatePicker;
import de.effectivecompany.gui.components.swing.EFCCalendarPopupButton;
import de.effectivecompany.gui.components.swing.layout.HorizontalLineLayout;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

public class EFCCalWeekEditor
extends EFCAbstractPrimaryEditor {
    private static final long serialVersionUID = -1573445316L;
    protected EITextField weekField;
    protected EITextField yearField;
    private EFCDatePicker calendar;
    private JButton calendarPopupButton;
    private boolean enabled = true;
    private boolean editable = true;
    private JPopupMenu popup = new JPopupMenu();
    private ActionDateChangedHandler actionDateChangedHandler;

    private void openCalendarDialog() {
        String year = this.yearField.getText();
        String weekOfYear = this.weekField.getText();
        Calendar cal = Calendar.getInstance();
        if (!weekOfYear.isEmpty()) {
            cal.set(3, Integer.parseInt(weekOfYear));
        }
        if (!year.isEmpty()) {
            cal.set(1, Integer.parseInt(year));
        }
        if (this.calendar == null) {
            this.calendar = new EFCDatePicker();
            this.calendar.addActionListener(new ActionDateChangedHandler());
        }
        this.calendar.setFirstDisplayedDay(cal.getTime());
        this.calendar.setSelectionDate(cal.getTime());
        this.popup.add((Component)((Object)this.calendar));
        this.popup.show(this, this.yearField.getX(), this.yearField.getY() + this.yearField.getHeight());
    }

    public EFCCalWeekEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
    }

    public EFCCalWeekEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, info, dropDownButtonEnabled, label, withLabel);
        this.setBusinessObjectModel(boModel);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        EFCAbstractEditor.UserInputHandler inputHandler = new EFCAbstractEditor.UserInputHandler(this.getIdent());
        KeyHandler keyHandler = new KeyHandler();
        FocusChangeHandler focusChangeHandler = new FocusChangeHandler();
        this.weekField = new EITextField(2);
        this.yearField = new EITextField(4);
        this.weekField.addKeyListener(keyHandler);
        this.yearField.addKeyListener(keyHandler);
        this.weekField.addFocusListener(focusChangeHandler);
        this.yearField.addFocusListener(focusChangeHandler);
        this.weekField.setHorizontalAlignment(4);
        this.yearField.setHorizontalAlignment(4);
        this.weekField.addKeyListener(inputHandler);
        this.weekField.addMouseListener(inputHandler);
        this.weekField.addMouseWheelListener(inputHandler);
        this.yearField.addKeyListener(inputHandler);
        this.yearField.addMouseListener(inputHandler);
        this.yearField.addMouseWheelListener(inputHandler);
        this.calendarPopupButton = new EFCCalendarPopupButton();
        this.calendarPopupButton.addActionListener(new DateUserActionHandler());
    }

    @Override
    public void reorganize() {
        this.removeAll();
        this.setLayout(new HorizontalLineLayout());
        this.add((Component)this.weekField, (Object)HorizontalLineLayout.Sizing.PREFERRED);
        this.add((Component)this.yearField, (Object)HorizontalLineLayout.Sizing.PREFERRED);
        this.add((Component)this.calendarPopupButton, (Object)HorizontalLineLayout.Sizing.PREFERRED);
    }

    private void validateEditors() {
        Integer numYear = null;
        Integer numWeek = null;
        Object calendarWeek = this.weekField.getText();
        Object year = this.yearField.getText();
        if (year != null && !((String)year).isEmpty()) {
            if (((String)year).length() == 1 || ((String)year).length() == 2) {
                numYear = Integer.parseInt((String)year);
                numYear = numYear < 50 ? 2000 + numYear : 1900 + numYear;
                year = "" + numYear;
                this.yearField.setText((String)year);
            }
            while (((String)year).length() < 4) {
                year = "0" + (String)year;
            }
            numYear = Integer.parseInt((String)year);
        }
        if (numYear != null && (numYear < 1000 || numYear > 4000)) {
            this.yearField.setEdgeIcon(EFCLookAndFeelManager.ICON_FIELDINFO_ERROR, 4);
            this.yearField.setBackground(Color.RED);
        } else {
            this.yearField.setEdgeIcon(null, 4);
            if (this.isEnabled()) {
                this.yearField.setBackground(SystemColor.window);
            } else {
                this.yearField.setBackground(SystemColor.control);
            }
            if (this.isEditable()) {
                this.yearField.setForeground(SystemColor.BLACK);
            } else {
                this.yearField.setForeground(SystemColor.GRAY);
            }
        }
        if (calendarWeek != null && !((String)calendarWeek).isEmpty()) {
            while (((String)calendarWeek).length() < 2) {
                calendarWeek = "0" + (String)calendarWeek;
            }
            numWeek = Integer.parseInt((String)calendarWeek);
        }
        this.weekField.setText((String)calendarWeek);
        if (numWeek != null && (numWeek < 1 || numWeek > 55)) {
            this.weekField.setEdgeIcon(EFCLookAndFeelManager.ICON_FIELDINFO_ERROR, 4);
            this.weekField.setBackground(Color.RED);
        } else {
            this.weekField.setEdgeIcon(null, 4);
            if (this.isEnabled()) {
                this.weekField.setBackground(SystemColor.window);
            } else {
                this.weekField.setBackground(SystemColor.control);
            }
            if (this.isEditable()) {
                this.weekField.setForeground(SystemColor.BLACK);
            } else {
                this.weekField.setForeground(SystemColor.GRAY);
            }
        }
    }

    public EFCInteger getWeekOfDate(Date date) {
        Calendar helpDate = Calendar.getInstance();
        helpDate.setTime(date);
        return new EFCInteger(Integer.valueOf(helpDate.get(3)));
    }

    public EFCInteger getYearOfWeekOfDate(Date date) {
        Calendar helpDate = Calendar.getInstance();
        helpDate.setTime(date);
        int weekInYear = helpDate.get(3);
        helpDate.set(7, helpDate.getActualMinimum(7));
        int weekStartsInYear = helpDate.get(1);
        helpDate.set(7, helpDate.getActualMaximum(7));
        int weekEndsInYear = helpDate.get(1);
        int minWeekInYear = helpDate.getActualMinimum(3);
        if (weekStartsInYear != weekEndsInYear && weekInYear == minWeekInYear) {
            return new EFCInteger(Integer.valueOf(weekEndsInYear));
        }
        return new EFCInteger(Integer.valueOf(weekStartsInYear));
    }

    @Override
    public void setEditable(boolean editable) {
        this.weekField.setEditable(editable);
        this.yearField.setEditable(editable);
        this.calendarPopupButton.setEnabled(this.enabled && editable);
        this.setComponentStyle(this.weekField);
        this.setComponentStyle(this.yearField);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    protected void setComponentStyle(JComponent component) {
        if (this.isEnabled()) {
            component.setBackground(SystemColor.window);
        } else {
            component.setBackground(SystemColor.control);
        }
        if (this.isEditable() && !this.getMetadata().isReadOnly()) {
            component.setForeground(SystemColor.BLACK);
        } else {
            component.setForeground(SystemColor.GRAY);
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setDisabledTextColor(component.getForeground());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getMetadata().isReadOnly()) {
            return;
        }
        this.enabled = enabled;
        this.calendarPopupButton.setEnabled(enabled && this.editable);
        this.weekField.setEnabled(enabled);
        this.yearField.setEnabled(enabled);
        this.setComponentStyle(this.weekField);
        this.setComponentStyle(this.yearField);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setValue(Object value) {
        String text = "";
        this.setModified(false);
        if (value instanceof Type) {
            if (value instanceof EFCInteger) {
                text = ((EFCInteger)value).toString();
            }
            if (value instanceof EFCString) {
                text = ((EFCString)value).getData();
            }
        } else {
            String string = text = value == null ? "" : value.toString();
        }
        if ("0".equals(text) || "".equals(text) || value == null) {
            this.weekField.setText("");
            this.yearField.setText("");
            return;
        }
        if (!text.matches("[0-9]+") || text.length() != 6) {
            if (text.matches("[0-9]+")) {
                this.weekField.setText("");
                this.yearField.setText("");
                return;
            }
            throw new IllegalArgumentException("value must be a 6 digit integer or string, got: " + text);
        }
        String week = text.substring(4);
        String year = text.substring(0, 4);
        this.weekField.setText(week);
        this.yearField.setText(year);
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    public EFCCalWeek getValue() {
        this.validateEditors();
        String kw = this.weekField.getText();
        String year = this.yearField.getText();
        if (kw != null && !kw.isEmpty() && year != null && !year.isEmpty()) {
            return new EFCCalWeek(year + kw);
        }
        return new EFCCalWeek();
    }

    @Override
    public String getSimpleValue() {
        this.validateEditors();
        String kw = this.weekField.getText();
        String year = this.yearField.getText();
        return year + kw;
    }

    @Override
    public JComponent getEditorComponent() {
        return null;
    }

    @Override
    public void setEditorComponent(JComponent component) {
    }

    public Date getDateOfWeek(int year, int week) {
        Calendar helpDate = Calendar.getInstance();
        helpDate.set(1, year);
        helpDate.set(3, week);
        helpDate.set(7, 2);
        this.resetTime(helpDate);
        return helpDate.getTime();
    }

    private void resetTime(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
    }

    @Override
    public void terminate() {
        for (KeyListener keyListener : this.weekField.getKeyListeners()) {
            this.weekField.removeKeyListener(keyListener);
        }
        for (KeyListener keyListener : this.yearField.getKeyListeners()) {
            this.yearField.removeKeyListener(keyListener);
        }
        for (EventListener eventListener : this.weekField.getFocusListeners()) {
            this.weekField.removeFocusListener((FocusListener)eventListener);
        }
        for (EventListener eventListener : this.yearField.getFocusListeners()) {
            this.yearField.removeFocusListener((FocusListener)eventListener);
        }
        for (EventListener eventListener : this.weekField.getMouseListeners()) {
            this.weekField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.yearField.getMouseListeners()) {
            this.yearField.removeMouseListener((MouseListener)eventListener);
        }
        for (EventListener eventListener : this.weekField.getMouseWheelListeners()) {
            this.weekField.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.yearField.getMouseWheelListeners()) {
            this.yearField.removeMouseWheelListener((MouseWheelListener)eventListener);
        }
        for (EventListener eventListener : this.calendarPopupButton.getActionListeners()) {
            this.calendarPopupButton.removeActionListener((ActionListener)eventListener);
        }
        if (this.calendar != null && this.actionDateChangedHandler != null) {
            this.calendar.removeActionListener(this.actionDateChangedHandler);
        }
        this.removeAll();
        this.weekField = null;
        this.yearField = null;
        this.calendarPopupButton = null;
        this.calendar = null;
        this.popup = null;
        super.terminate();
    }

    public EFCCalWeek getOriginalValue() {
        return (EFCCalWeek)super.getOriginalValue();
    }

    private class FocusChangeHandler
    implements FocusListener {
        private String onFocusValue = null;

        private FocusChangeHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getOppositeComponent() == EFCCalWeekEditor.this.weekField || e.getOppositeComponent() == EFCCalWeekEditor.this.yearField) {
                return;
            }
            this.onFocusValue = EFCCalWeekEditor.this.getSimpleValue();
            EFCCalWeekEditor.this.fireFocusGainedEvent(EFCCalWeekEditor.this.getIdent());
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() instanceof EFCCalendarPopupButton) {
                return;
            }
            if (!EFCCalWeekEditor.this.doFocusHandling || e.getOppositeComponent() instanceof JButton && ((JButton)e.getOppositeComponent()).getAction() instanceof EFCActionSave) {
                return;
            }
            EFCCalWeekEditor.this.validateEditors();
            if (e.getOppositeComponent() == EFCCalWeekEditor.this.weekField || e.getOppositeComponent() == EFCCalWeekEditor.this.yearField) {
                return;
            }
            String oldVal = this.onFocusValue;
            String newVal = EFCCalWeekEditor.this.getSimpleValue();
            if (oldVal.equals(newVal)) {
                return;
            }
            EFCCalWeekEditor.this.fireValueChangeEvent(EFCCalWeekEditor.this.getIdent(), new EFCCalWeek(oldVal), new EFCCalWeek(newVal));
            EFCCalWeekEditor.this.fireFocusLostEvent(EFCCalWeekEditor.this.getIdent());
        }
    }

    private class DateUserActionHandler
    implements ActionListener {
        private DateUserActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == EFCCalWeekEditor.this.calendarPopupButton) {
                EFCCalWeekEditor.this.openCalendarDialog();
            }
        }
    }

    private class ActionDateChangedHandler
    implements ActionListener {
        private ActionDateChangedHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String oldWeekText = EFCCalWeekEditor.this.weekField.getText();
            String oldYearText = EFCCalWeekEditor.this.yearField.getText();
            String oldDateString = oldYearText + oldWeekText;
            Date newDate = EFCCalWeekEditor.this.calendar.getFirstSelectionDate();
            EFCInteger week = EFCCalWeekEditor.this.getWeekOfDate(newDate);
            EFCInteger year = EFCCalWeekEditor.this.getYearOfWeekOfDate(newDate);
            EFCCalWeekEditor.this.weekField.setText(week.getData().toString());
            EFCCalWeekEditor.this.yearField.setText(year.getData().toString());
            EFCCalWeekEditor.this.validateEditors();
            String newDateString = EFCCalWeekEditor.this.yearField.getText() + EFCCalWeekEditor.this.weekField.getText();
            EFCCalWeekEditor.this.popup.setVisible(false);
            if (EFCCalWeekEditor.this.getBusinessObjectModel() != null) {
                EFCCalWeekEditor.this.getBusinessObjectModel().setLastSelectedListItemIndex();
            }
            EFCCalWeekEditor.this.fireValueChangeEvent(EFCCalWeekEditor.this.getIdent(), new EFCCalWeek(oldDateString), new EFCCalWeek(newDateString));
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (!event.isConsumed()) {
                char ch = event.getKeyChar();
                if (ch != '\b' && ch != '\u007f' && ch != '\n' && ch != '\t' && !Character.isDigit(ch)) {
                    event.consume();
                } else if (Character.isDigit(ch) && (event.getSource() == EFCCalWeekEditor.this.weekField && EFCCalWeekEditor.this.weekField.getText().length() >= 2 || event.getSource() == EFCCalWeekEditor.this.yearField && EFCCalWeekEditor.this.yearField.getText().length() >= 4)) {
                    if (((EITextField)event.getSource()).getSelectedText() == null) {
                        event.consume();
                    }
                } else {
                    EFCCalWeekEditor.this.setModified(true);
                }
            }
            super.keyTyped(event);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            if (e.getKeyCode() == 40) {
                EFCCalWeekEditor.this.openCalendarDialog();
                e.consume();
            }
        }
    }
}

