/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCDate;
import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.editor.util.DateFormatter;
import de.effectivecompany.gui.components.jcalendar.calendar.EFCDatePicker;
import de.effectivecompany.gui.components.swing.EFCCalendarPopupButton;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Calendar;
import java.util.Date;
import java.util.EventListener;
import java.util.GregorianCalendar;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCDateEditor
extends EFCAbstractPrimaryEditor {
    private static final long serialVersionUID = -6354L;
    private static Logger logger = LoggerFactory.getLogger(EFCDateEditor.class);
    private EITextField dateField;
    private JPopupMenu popup;
    private EFCDatePicker calendar;
    private JButton calendarPopupButton;
    private boolean enabled = true;
    private boolean editable = true;
    private EITextField dayNameField;
    private ActionDateChangedHandler actionDateChangedHandler;

    public EFCDateEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, info, dropDownButtonEnabled, label, withLabel, null);
    }

    public EFCDateEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel, String scbchrkey) {
        super(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        DateFocusHandler focusHandler = new DateFocusHandler();
        DateUserActionHandler userHandler = new DateUserActionHandler();
        EFCAbstractEditor.UserInputHandler inputHandler = new EFCAbstractEditor.UserInputHandler(this.getIdent());
        this.dayNameField = new EITextField(2);
        this.dayNameField.setMargin(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS);
        this.dayNameField.setHorizontalAlignment(0);
        this.dayNameField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.dayNameField.setEditable(false);
        this.dayNameField.setEnabled(false);
        this.dateField = new EITextField(7);
        this.dateField.setMargin(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS);
        this.dateField.setHorizontalAlignment(0);
        this.dateField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.dateField.addFocusListener(focusHandler);
        this.dateField.addKeyListener(userHandler);
        this.dateField.addKeyListener(inputHandler);
        this.dateField.addMouseListener(inputHandler);
        this.dateField.addActionListener(userHandler);
        this.calendarPopupButton = new EFCCalendarPopupButton();
        this.calendarPopupButton.setFocusable(false);
        this.calendarPopupButton.addActionListener(userHandler);
        this.calendarPopupButton.addFocusListener(focusHandler);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(this.dayNameField);
        this.add(this.dateField);
        this.add(this.calendarPopupButton);
        this.revalidate();
    }

    public EFCDateEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, boModel, info, dropDownButtonEnabled, label, withLabel, null);
    }

    public EFCDateEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel, String scbchrkey) {
        this(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        this.setBusinessObjectModel(boModel);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    public void setDate(Date date) {
        if (date != null) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            this.dateField.setText(DateFormatter.getDefaultDateFormat().format(date));
            this.dayNameField.setText(DateFormatter.getDefaultDaynameFormat().format(date));
            if (cal.get(1) >= 1800 && cal.get(1) <= 2999) {
                this.dateField.setEdgeIcon(null, 4);
                if (this.isEnabled() && this.isEditable()) {
                    this.dateField.setBackground(Color.WHITE);
                }
            } else {
                this.dateField.setEdgeIcon(EFCLookAndFeelManager.ICON_FIELDINFO_ERROR, 4);
                if (this.isEnabled() && this.isEditable()) {
                    this.dateField.setBackground(Color.RED);
                }
            }
        } else {
            this.dateField.setText("");
            this.dayNameField.setText("");
            this.dateField.setEdgeIcon(null, 4);
            if (this.isEnabled() && this.isEditable()) {
                this.dateField.setBackground(Color.WHITE);
            }
        }
    }

    public String getDateFieldText() {
        return this.dateField.getText();
    }

    public boolean isDateStringValid() {
        return DateFormatter.convertDate(this.dateField.getText()) != null;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setDate(null);
        } else if (value instanceof EFCDate) {
            this.setDate(((EFCDate)value).getDate());
        } else if (value instanceof EFCDateTime) {
            this.setDate(((EFCDateTime)value).getDate());
        } else if (value instanceof Date) {
            this.setDate((Date)value);
        } else if (value instanceof String) {
            this.setDate(new EFCDate((String)value).getDate());
        } else {
            throw new IllegalArgumentException("unsupported value for editor: " + value.getClass().getName());
        }
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.dateField.getText();
    }

    public EFCDate getValue() {
        Date value = DateFormatter.convertDate(this.dateField.getText());
        if (value == null) {
            return new EFCDate();
        }
        return new EFCDate(value);
    }

    @Override
    public Date getSimpleValue() {
        return DateFormatter.convertDate(this.dateField.getText());
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        this.dateField.setEditable(editable);
        this.calendarPopupButton.setEnabled(this.enabled && editable);
        this.setComponentStyle(this.dateField);
    }

    @Override
    public boolean isEditable() {
        return this.editable;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setVisible(boolean aFlag) {
        this.dateField.setVisible(aFlag);
        this.dayNameField.setVisible(aFlag);
        this.calendarPopupButton.setVisible(aFlag);
        super.setVisible(aFlag);
    }

    @Override
    public boolean isVisible() {
        return this.dateField.isVisible();
    }

    @Override
    public JComponent getEditorComponent() {
        return this.dateField;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.dateField = (EITextField)component;
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.dateField.setEdgeIcon(img, edge);
    }

    @Override
    public void terminate() {
        for (FocusListener focusListener : this.dateField.getFocusListeners()) {
            this.dateField.removeFocusListener(focusListener);
        }
        for (EventListener eventListener : this.dateField.getKeyListeners()) {
            this.dateField.removeKeyListener((KeyListener)eventListener);
        }
        for (EventListener eventListener : this.dateField.getMouseListeners()) {
            this.dateField.removeMouseListener((MouseListener)eventListener);
        }
        if (this.calendar != null && this.actionDateChangedHandler != null) {
            this.calendar.removeActionListener(this.actionDateChangedHandler);
        }
        for (EventListener eventListener : this.calendarPopupButton.getActionListeners()) {
            this.calendarPopupButton.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : this.calendarPopupButton.getFocusListeners()) {
            this.calendarPopupButton.removeFocusListener((FocusListener)eventListener);
        }
        this.removeAll();
        this.dateField = null;
        this.calendar = null;
        this.calendarPopupButton = null;
        this.popup = null;
        super.terminate();
    }

    public EFCDate getOriginalValue() {
        return (EFCDate)super.getOriginalValue();
    }

    public EITextField getDateField() {
        return this.dateField;
    }

    public EITextField getDayNameField() {
        return this.dayNameField;
    }

    public JButton getCalendarPopupButton() {
        return this.calendarPopupButton;
    }

    private class DateUserActionHandler
    extends KeyAdapter
    implements ActionListener,
    KeyListener {
        private DateUserActionHandler() {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            if (Character.isLetter(event.getKeyChar()) || EFCDateEditor.this.dateField.getText().length() > 12) {
                event.consume();
            } else {
                EFCDateEditor.this.setModified(true);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            super.keyPressed(e);
            if (e.getKeyCode() == 40) {
                this.openCalendarDialog();
                e.consume();
            }
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == EFCDateEditor.this.calendarPopupButton) {
                this.openCalendarDialog();
            }
        }

        private void openCalendarDialog() {
            String dateString = EFCDateEditor.this.dateField.getText();
            Date date = DateFormatter.convertDate(dateString);
            logger.debug("setting date: " + date);
            if (EFCDateEditor.this.calendar == null) {
                EFCDateEditor.this.calendar = new EFCDatePicker();
                EFCDateEditor.this.actionDateChangedHandler = new ActionDateChangedHandler();
                EFCDateEditor.this.calendar.addActionListener(EFCDateEditor.this.actionDateChangedHandler);
                EFCDateEditor.this.popup = new JPopupMenu();
                EFCDateEditor.this.popup.setPreferredSize(EFCDateEditor.this.calendar.getPreferredSize());
            }
            if (date != null) {
                Date border = new GregorianCalendar(1800, 1, 1).getTime();
                if (date.before(border) || date.equals(border)) {
                    date = new Date();
                }
                EFCDateEditor.this.calendar.setFirstDisplayedDay(date);
            } else {
                date = new Date();
                EFCDateEditor.this.calendar.setFirstDisplayedDay(date);
            }
            EFCDateEditor.this.calendar.setSelectionDate(date);
            EFCDateEditor.this.popup.add((Component)((Object)EFCDateEditor.this.calendar));
            EFCDateEditor.this.popup.show(EFCDateEditor.this, EFCDateEditor.this.dateField.getX(), EFCDateEditor.this.dateField.getY() + EFCDateEditor.this.dateField.getHeight());
        }
    }

    private class DateFocusHandler
    implements FocusListener {
        private Date onFocusValue = null;

        private DateFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.getSource() instanceof EFCCalendarPopupButton) {
                EFCDateEditor.this.calendarPopupButton.transferFocus();
            }
            if (e.getOppositeComponent() == EFCDateEditor.this.dateField || e.getOppositeComponent() == EFCDateEditor.this.dropDownButton) {
                return;
            }
            this.onFocusValue = EFCDateEditor.this.getSimpleValue();
            EFCDateEditor.this.fireFocusGainedEvent(EFCDateEditor.this.getIdent());
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (e.getSource() instanceof EFCCalendarPopupButton) {
                return;
            }
            Date date = DateFormatter.convertDate(EFCDateEditor.this.dateField.getText());
            EFCDateEditor.this.setDate(date);
            if (e.getOppositeComponent() == EFCDateEditor.this.dateField || e.getOppositeComponent() == EFCDateEditor.this.dropDownButton) {
                return;
            }
            Date newVal = EFCDateEditor.this.getSimpleValue();
            Date oldVal = this.onFocusValue;
            if (newVal == null || oldVal == null) {
                if (newVal != oldVal) {
                    EFCDateEditor.this.fireValueChangeEvent(EFCDateEditor.this.getIdent(), new EFCDate(oldVal), new EFCDate(newVal));
                }
            } else if (oldVal.getTime() != newVal.getTime()) {
                EFCDateEditor.this.fireValueChangeEvent(EFCDateEditor.this.getIdent(), new EFCDate(oldVal), new EFCDate(newVal));
            }
            EFCDateEditor.this.fireFocusLostEvent(EFCDateEditor.this.getIdent());
        }
    }

    private class ActionDateChangedHandler
    implements ActionListener {
        private ActionDateChangedHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (EFCDateEditor.this.getBusinessObjectModel() != null) {
                EFCDateEditor.this.getBusinessObjectModel().setLastSelectedListItemIndex();
            }
            Date oldDate = DateFormatter.convertDate(EFCDateEditor.this.dateField.getText());
            Date newDate = EFCDateEditor.this.calendar.getFirstSelectionDate();
            EFCDateEditor.this.popup.setVisible(false);
            EFCDateEditor.this.fireValueChangeEvent(EFCDateEditor.this.getIdent(), new EFCDate(oldDate), new EFCDate(newDate));
        }
    }
}

