/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.data.LazyLoader;
import de.effectivecompany.base.datatypes.EFCBlob;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.edgeicon.EITextArea;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.factory.EFCViewerFactory;
import de.effectivecompany.gui.interfaces.element.PictureContainer;
import de.effectivecompany.gui.util.EFCThreadUtil;
import java.awt.BorderLayout;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCImageEditor
extends EFCAbstractPrimaryEditor {
    private static final long serialVersionUID = 1189767834164615036L;
    private static Logger logger = LoggerFactory.getLogger(EFCImageEditor.class);
    protected EITextArea textArea = new EITextArea(15, 2);
    private PictureContainer data;
    private boolean dataModified;
    private EFCImageComponent imageFrame = new EFCImageComponent();

    public EFCImageEditor(String ident, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        this.setLayout(new BorderLayout());
        this.add(this.imageFrame);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    public void setData(PictureContainer container) {
        this.data = container;
        this.dataModified = true;
    }

    @Override
    public void paint(Graphics g) {
        if (this.dataModified) {
            this.imageFrame.checkForLoading();
        }
        super.paint(g);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.imageFrame;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.imageFrame = (EFCImageComponent)component;
    }

    @Override
    public Object getSimpleValue() {
        return null;
    }

    @Override
    public Object getValue() {
        return null;
    }

    @Override
    public void setValue(Object imageSource) {
        if (imageSource == null) {
            logger.error("Unable to set image, imageSource is null!");
            return;
        }
        if (imageSource instanceof EFCBlob) {
            this.imageFrame.setImage(((EFCBlob)imageSource).getInputStream());
        }
    }

    public class EFCImageComponent
    extends EFCPanel {
        private static final long serialVersionUID = 5586317122218132283L;
        private Logger logger;
        private ImagePanel imagePanel;

        public void setLocked(boolean locked) {
            if (locked) {
                this.setCursor(new Cursor(3));
            } else {
                this.setCursor(new Cursor(0));
            }
        }

        public EFCImageComponent() {
            super(null, null, "", "", false);
            this.logger = LoggerFactory.getLogger(EFCImageComponent.class);
            this.imagePanel = new ImagePanel();
            JScrollPane pane = new JScrollPane(this.imagePanel);
            this.add(pane);
        }

        public void setImage(InputStream stream) {
            this.imagePanel.setImage(stream);
        }

        private void checkForLoading() {
            PictureContainer object = EFCImageEditor.this.data;
            if (object == null) {
                this.logger.warn("no picture container loaded (null)");
            }
            if (object instanceof LazyLoader) {
                EFCImageEditor.this.dataModified = false;
                LazyLoader loader = (LazyLoader)object;
                this.setLocked(true);
                if (!loader.isLoaded()) {
                    new SwingWorker<Object, Object>(){
                        private boolean didLoading = false;

                        @Override
                        protected Object doInBackground() {
                            LazyLoader loader = (LazyLoader)EFCImageEditor.this.data;
                            loader.lock();
                            if (loader.isLoaded()) {
                                loader.unlock();
                                return null;
                            }
                            try {
                                EFCImageComponent.this.setEnabled(false);
                                loader.load();
                                this.didLoading = true;
                            }
                            catch (Exception e) {
                                EFCImageComponent.this.logger.error(Translator.tr((String)"MSG_FRAME_EXCEPTION"), (Throwable)e);
                            }
                            loader.unlock();
                            return null;
                        }

                        @Override
                        protected void done() {
                            try {
                                this.get();
                                EFCImageComponent.this.setLocked(false);
                                if (this.didLoading) {
                                    EFCImageComponent.this.setEnabled(true);
                                    EFCImageComponent.this.imagePanel.setImage(EFCImageEditor.this.data.getData().getInputStream());
                                }
                            }
                            catch (InterruptedException | ExecutionException e) {
                                EFCImageComponent.this.setLocked(false);
                                EFCDesktop.reportError(e);
                            }
                        }
                    }.execute();
                }
            }
        }

        private class ImagePanel
        extends JPanel {
            private static final long serialVersionUID = 1791642429829973739L;
            private BufferedImage scaledImage;
            private JLabel labelImage = new JLabel();

            public ImagePanel() {
                this.add(this.labelImage);
                this.addPreviewWindow();
            }

            public void setImage(InputStream stream) {
                try {
                    this.checkImageSize(ImageIO.read(stream));
                    if (this.scaledImage == null) {
                        this.labelImage.setIcon(null);
                    } else {
                        this.labelImage.setIcon(new ImageIcon(this.scaledImage));
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }

            private void checkImageSize(BufferedImage image) {
                int imageHeight;
                int imageWidth;
                if (image == null) {
                    this.scaledImage = image;
                    return;
                }
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Dimension screenSize = toolkit.getScreenSize();
                double screenSizeMaxWidth = (double)screenSize.width * 0.75;
                double screenSizeMaxHeight = (double)screenSize.height * 0.75;
                int imageWidthScaled = imageWidth = image.getWidth();
                int imageHeightScaled = imageHeight = image.getHeight();
                double scaleFactor = 0.9;
                int scaleSteps = 0;
                while ((double)imageWidthScaled > screenSizeMaxWidth || (double)imageHeightScaled > screenSizeMaxHeight) {
                    imageWidthScaled = (int)((double)imageWidthScaled * scaleFactor);
                    imageHeightScaled = (int)((double)imageHeightScaled * scaleFactor);
                    ++scaleSteps;
                }
                if (scaleSteps > 0) {
                    this.scaleImage(image, (double)imageWidthScaled / (double)imageWidth);
                } else {
                    this.scaledImage = image;
                }
            }

            private void scaleImage(BufferedImage image, double scaleFactor) {
                double scale = scaleFactor;
                AffineTransformOp op = new AffineTransformOp(AffineTransform.getScaleInstance(scale, scale), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
                this.scaledImage = op.filter(image, null);
            }

            private void addPreviewWindow() {
                this.labelImage.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        if (e.getClickCount() == 2) {
                            EFCThreadUtil.doLater(() -> EFCViewerFactory.createViewer(ImagePanel.this.scaledImage));
                        }
                    }
                });
            }
        }
    }
}

