/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.gui.components.editor.EFCAbstractNumberEditor;
import de.effectivecompany.gui.data.BusinessObjectModel;
import java.text.NumberFormat;

public class EFCIntegerEditor
extends EFCAbstractNumberEditor {
    static final long serialVersionUID = -1573456L;

    public EFCIntegerEditor(String ident) {
        super(ident, false, false);
        this.setColumns(8);
    }

    public EFCIntegerEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel) {
        this(ident, boModel, info, dropDownButtonEnabled, size, width, label, withLabel, null);
    }

    public EFCIntegerEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel, String scbchrkey) {
        super(ident, boModel, info, dropDownButtonEnabled, size, width, label, withLabel, scbchrkey);
        this.setColumns(8);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    @Override
    protected void initFormat(NumberFormat format) {
        super.initFormat(format);
        format.setMinimumFractionDigits(0);
        format.setMaximumFractionDigits(0);
    }

    @Override
    protected boolean isCharValid(char ch) {
        boolean ok = super.isCharValid(ch);
        if (ch == ',' || ch == '.') {
            ok = false;
        }
        return ok;
    }

    public EFCInteger getValue() {
        Object object = super.getValue();
        if (object instanceof Number) {
            Integer intVal = ((Number)object).intValue();
            return new EFCInteger(intVal);
        }
        return new EFCInteger();
    }

    public EFCInteger getOriginalValue() {
        return (EFCInteger)super.getOriginalValue();
    }

    @Override
    public void terminate() {
        this.removeAll();
        super.terminate();
    }
}

