/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCInteger;
import de.effectivecompany.base.datatypes.EFCString;
import de.effectivecompany.base.gui.interfaces.BusinessObject;
import de.effectivecompany.base.gui.interfaces.SelectService;
import de.effectivecompany.base.gui.key.Key;
import de.effectivecompany.base.meta.TypeInfo;
import de.effectivecompany.base.util.ObjectUtil2;
import de.effectivecompany.base.util.SpringHelper;
import de.effectivecompany.base.util.StringUtil;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.model.table.SelectServiceTableModel;
import de.effectivecompany.gui.components.swing.layout.HorizontalLineLayout;
import de.effectivecompany.gui.components.table.EFCColumnResizer;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.events.UserInteractionEvent;
import de.effectivecompany.gui.interfaces.listeners.UserInteractionListener;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelListener;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCObjectListEditor
extends EFCAbstractPrimaryEditor {
    private static Logger logger = LoggerFactory.getLogger(EFCObjectListEditor.class);
    private static final long serialVersionUID = -62567417L;
    private Key defaultPopupParams;
    protected EITextField myTextField;
    protected Class<?> objectclass;
    private static MethodHandles.Lookup publicLookup = MethodHandles.publicLookup();
    private String onFocusString;
    private Object onFocusValue;

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean handleDataChange() {
        String newVal = this.myTextField.getText();
        if (this.verifyText()) {
            this.myTextField.setBackground(Color.WHITE);
            this.myTextField.setEdgeIcon(null, 4);
            if (newVal.equals(this.getSimpleOriginalValue() != null ? this.getSimpleOriginalValue().toString() : "")) return false;
            if (!this.isScrollMode) {
                this.fireValueChangeEvent(this.getIdent(), this.getOriginalValue(), this.getValue());
                this.setModified(true);
                return true;
            }
            UserInteractionEvent sece = new UserInteractionEvent(this, 2044, this.getIdent(), newVal);
            for (UserInteractionListener listener : this.getUserInteractionListeners()) {
                listener.onUserInteraction(sece);
            }
            return false;
        }
        this.myTextField.setEdgeIcon(EFCLookAndFeelManager.ICON_FIELDINFO_ERROR, 4);
        this.myTextField.setBackground(Color.RED);
        return false;
    }

    public EFCObjectListEditor(String ident, Class<?> clazz, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String keyattr, String srvkeyattr, String dataService, String serviceBasePath, String unitattr, String label, boolean withLabel) {
        this(ident, clazz, boModel, info, dropDownButtonEnabled, keyattr, srvkeyattr, dataService, serviceBasePath, unitattr, label, withLabel, null);
    }

    public EFCObjectListEditor(String ident, Class<?> clazz, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String keyattr, String srvkeyattr, String dataService, String serviceBasePath, String unitattr, String label, boolean withLabel, String scbchrkey) {
        super(ident, info, dropDownButtonEnabled, label, withLabel, scbchrkey);
        this.objectclass = clazz;
        this.setBusinessObjectModel(boModel);
        logger.debug("found assignable BusinessObject {}", (Object)clazz.getSimpleName());
        logger.debug("keyattr: " + keyattr);
        TypeInfo typeInfo = boModel.getAttributeInfo(keyattr);
        if (typeInfo.getMaxSize() > 0) {
            this.setColumns(typeInfo.getMaxSize());
        }
        if (dataService == null) {
            logger.error("ERROR: field {} needs the pulldown attribute set", (Object)ident);
            this.setPopupEnabled(false);
            this.reorganize();
        } else {
            String beanId = null;
            try {
                Class svcclass = ClassUtils.getClass((String)(serviceBasePath + dataService));
                beanId = (String)svcclass.getField("BEAN_ID").get(null);
                Object svcobj = SpringHelper.getBean((String)beanId);
                if (svcobj == null) {
                    logger.error("Spring returned a null service");
                }
                if (svcobj instanceof SelectService) {
                    this.setPrimaryPopupService((SelectService)svcobj);
                    this.setKeyattr(srvkeyattr);
                    this.setSecondaryPopupActive(false);
                    this.setSecondaryIdent(unitattr);
                    this.setPopupEnabled(true);
                } else {
                    logger.error("service set for {} is not a SelectService", (Object)ident);
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                logger.error("Editor generation for " + ident + " failed: " + e.getClass().getName() + ":" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        EFCAbstractEditor.UserInputHandler inputHandler = new EFCAbstractEditor.UserInputHandler(this.getIdent());
        OLEFocusHandler focusHandler = new OLEFocusHandler();
        InputVerifier inputVerifier = new InputVerifier();
        this.setLayout(new HorizontalLineLayout());
        this.setPopupEnabled(true);
        this.myTextField = new EITextField(4);
        this.myTextField.addFocusListener(focusHandler);
        this.myTextField.addFocusListener(inputVerifier);
        this.myTextField.addKeyListener(inputVerifier);
        this.myTextField.addKeyListener(inputHandler);
        this.myTextField.addMouseListener(inputHandler);
        this.myTextField.addMouseWheelListener(inputHandler);
        this.myTextField.addKeyListener(new EFCAbstractPrimaryEditor.DropDownButtonHandler());
        this.myTextField.setFont(EFCLookAndFeelManager.FONT_FORM);
        this.myTextField.setMargin(UnitConverter.createPixelFromDLUInsets(EFCLookAndFeelManager.SIZE_TEXTFIELD_INSETS, this.myTextField));
        this.checkPrimaryPopupInit();
        this.primaryPopupTable.addFocusListener(focusHandler);
        this.primaryPopupMenu.addFocusListener(inputVerifier);
        this.primaryPopupTable.setColumnControlVisible(false);
        if (this.dropDownButton != null) {
            this.dropDownButton.addFocusListener(focusHandler);
            this.dropDownButton.addFocusListener(inputVerifier);
        }
    }

    private String[] getPossibleKeys() {
        this.reloadList();
        SelectServiceTableModel model = (SelectServiceTableModel)this.primaryPopupTable.getModel();
        LinkedList<String> values = new LinkedList<String>();
        for (int i = 0; i < model.getRowCount(); ++i) {
            Object value = model.getObjectValueAt(i, this.getKeyattr());
            String valueString = value == null ? null : value.toString();
            values.add(valueString);
        }
        return values.toArray(new String[0]);
    }

    private boolean verifyText() {
        int i;
        String text = this.myTextField.getText();
        if ("".equals(text)) {
            return true;
        }
        String[] values = this.getPossibleKeys();
        for (i = 0; i < values.length; ++i) {
            if (!text.equals(values[i])) continue;
            return true;
        }
        for (i = 0; i < values.length; ++i) {
            if (!text.equalsIgnoreCase(values[i])) continue;
            this.myTextField.setText(values[i]);
            return true;
        }
        return false;
    }

    @Override
    public void reorganize() {
        this.removeAll();
        this.setLayout(new HorizontalLineLayout());
        this.add((Component)this.myTextField, (Object)HorizontalLineLayout.Sizing.PREFERRED);
        if (this.dropDownButton != null && this.dropDownButton.isVisible()) {
            this.add((Component)this.dropDownButton, (Object)HorizontalLineLayout.Sizing.MINIMIZE);
        }
        if (this.infotext != null) {
            this.add((Component)this.infotext, (Object)HorizontalLineLayout.Sizing.MAXIMIZE);
        }
    }

    public void setDefaultPopupParams(Key defaultPopupParams) {
        this.defaultPopupParams = defaultPopupParams;
    }

    public Map<String, String> getDefaultPopupParams() {
        return this.defaultPopupParams;
    }

    public void reloadList(Map<String, String> param) {
        if (param != null) {
            ((SelectServiceTableModel)this.primaryPopupTable.getModel()).loadData(param);
            EFCColumnResizer.adjustPrimaryPopupTableColumnPreferredWidths((JTable)((Object)this.primaryPopupTable));
        }
    }

    public void reloadList() {
        this.reloadList((Map<String, String>)this.defaultPopupParams);
    }

    private String getObjectAttribute(Object o, String attribName) {
        MethodHandle getterMethod = null;
        String methodName1 = StringUtil.getterName((String)this.getKeyattr());
        String methodName2 = StringUtil.getterName((String)this.getKeyattr(), Boolean.class);
        if (o != null) {
            String fullMethodName1 = o.getClass().getName() + "." + methodName1;
            String fullMethodName2 = o.getClass().getName() + "." + methodName2;
            if (ObjectUtil2.getterMethodCache.containsKey((Object)fullMethodName1)) {
                getterMethod = (MethodHandle)ObjectUtil2.getterMethodCache.get((Object)fullMethodName1);
            } else if (ObjectUtil2.getterMethodCache.containsKey((Object)fullMethodName2)) {
                getterMethod = (MethodHandle)ObjectUtil2.getterMethodCache.get((Object)fullMethodName2);
            } else {
                Method[] methods;
                for (Method method : methods = o.getClass().getMethods()) {
                    MethodType mt2;
                    if (method.getName().equalsIgnoreCase(methodName1) && method.getParameterTypes().length == 0) {
                        try {
                            mt2 = MethodType.methodType(method.getReturnType());
                            getterMethod = publicLookup.findVirtual(o.getClass(), method.getName(), mt2);
                        }
                        catch (Throwable mt2) {
                            // empty catch block
                        }
                        ObjectUtil2.getterMethodCache.put((Object)fullMethodName1, (Object)getterMethod);
                    } else if (method.getName().equalsIgnoreCase(methodName2) && method.getParameterTypes().length == 0) {
                        try {
                            mt2 = MethodType.methodType(method.getReturnType());
                            getterMethod = publicLookup.findVirtual(o.getClass(), method.getName(), mt2);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        ObjectUtil2.getterMethodCache.put((Object)fullMethodName2, (Object)getterMethod);
                    }
                    if (getterMethod != null) break;
                }
            }
        }
        String result = null;
        if (getterMethod == null) {
            throw new NullPointerException("could not find getter " + methodName1 + " or " + methodName2 + " on " + o.getClass().getName());
        }
        try {
            Object attribValue = getterMethod.invoke(o);
            result = attribValue instanceof EFCString ? ((EFCString)attribValue).toString() : (attribValue instanceof EFCInteger ? ((EFCInteger)attribValue).toString() : attribValue.toString());
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        catch (Throwable th) {
            th.printStackTrace();
        }
        return result;
    }

    public void setColumns(int columns) {
        this.myTextField.setColumns(columns);
        if (columns > 0) {
            this.setEditorSizing(2);
        } else {
            this.setEditorSizing(1);
        }
        this.reorganize();
    }

    public int getColumns() {
        return this.myTextField.getColumns();
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.myTextField.setEdgeIcon(img, edge);
    }

    @Override
    public String getKeyattr() {
        return super.getKeyattr();
    }

    @Override
    public void setKeyattr(String keyattr) {
        super.setKeyattr(keyattr);
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof BusinessObject) {
            if (!value.getClass().isAssignableFrom(this.objectclass)) {
                throw new IllegalArgumentException("class of value is not compartible with " + this.objectclass.getName());
            }
            if (this.getKeyattr() == null) {
                logger.warn("{}: keyattr undefined, cannot set value", (Object)this.getIdent());
            } else {
                this.myTextField.setText(this.getObjectAttribute(value, this.getKeyattr()));
            }
        } else if (value != null) {
            this.myTextField.setText(value.toString());
        } else {
            this.myTextField.setText("");
        }
        this.myTextField.setEdgeIcon(null, 4);
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    @Override
    public Object getValue() {
        SelectServiceTableModel model = (SelectServiceTableModel)this.primaryPopupTable.getModel();
        String text = this.myTextField.getText();
        if ("".equals(text)) {
            return null;
        }
        Key key = null;
        for (int i = 0; i < model.getRowCount(); ++i) {
            String valueString;
            Object object = model.getObjectValueAt(i, this.getKeyattr());
            if (object == null || !(valueString = object.toString()).equals(text)) continue;
            key = model.getKeyAt(i);
            break;
        }
        if (key == null) {
            return null;
        }
        return model.getSelectService().getObj(key);
    }

    public Class<?> getObjectclass() {
        return this.objectclass;
    }

    @Override
    public String getSimpleValue() {
        return this.myTextField.getText();
    }

    @Override
    protected void onPopupOpen(String ident) {
        SelectServiceTableModel model = (SelectServiceTableModel)this.primaryPopupTable.getModel();
        String text = this.myTextField.getText();
        for (int i = 0; i < model.getRowCount(); ++i) {
            String valueString;
            Object object = model.getObjectValueAt(i, this.getKeyattr());
            if (object == null || !(valueString = object.toString()).equals(text)) continue;
            this.primaryPopupTable.getSelectionModel().setSelectionInterval(i, i);
            break;
        }
        super.onPopupOpen(ident);
    }

    @Override
    protected void onPopupClose(String ident, Object oldValue, Object newValue) {
        if (this.getIdent().equals(ident)) {
            String oldText;
            String newText = "";
            if (newValue != null) {
                newText = this.getObjectAttribute(newValue, this.getKeyattr());
            }
            if (!(oldText = this.myTextField.getText()).equals(newText)) {
                this.myTextField.setText(newText);
                this.setModified(true);
            }
        }
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myTextField;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.myTextField = (EITextField)component;
    }

    @Override
    public void terminate() {
        if (this.myTextField != null) {
            for (FocusListener focusListener : this.myTextField.getFocusListeners()) {
                this.myTextField.removeFocusListener(focusListener);
            }
            for (FocusListener focusListener : this.myTextField.getFocusListeners()) {
                this.myTextField.removeFocusListener(focusListener);
            }
            for (EventListener eventListener : this.myTextField.getKeyListeners()) {
                this.myTextField.removeKeyListener((KeyListener)eventListener);
            }
            for (EventListener eventListener : this.myTextField.getKeyListeners()) {
                this.myTextField.removeKeyListener((KeyListener)eventListener);
            }
            for (EventListener eventListener : this.myTextField.getMouseListeners()) {
                this.myTextField.removeMouseListener((MouseListener)eventListener);
            }
            for (EventListener eventListener : this.myTextField.getMouseWheelListeners()) {
                this.myTextField.removeMouseWheelListener((MouseWheelListener)eventListener);
            }
        }
        if (this.dropDownButton != null) {
            for (FocusListener focusListener : this.dropDownButton.getFocusListeners()) {
                this.dropDownButton.removeFocusListener(focusListener);
            }
        }
        if (this.primaryPopupTable != null) {
            for (FocusListener focusListener : this.primaryPopupTable.getFocusListeners()) {
                this.primaryPopupTable.removeFocusListener(focusListener);
            }
        }
        this.removeAll();
        this.myTextField = null;
        super.terminate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
        if (!enabled) {
            this.myTextField.setCaretPosition(0);
        }
        this.setComponentStyle(this.myTextField);
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this.myTextField.setEditable(editable);
        if (!editable) {
            this.myTextField.setCaretPosition(0);
        }
        this.setComponentStyle(this.myTextField);
    }

    private class InputVerifier
    extends KeyAdapter
    implements FocusListener {
        private InputVerifier() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent event) {
            int selectionEnd;
            String[] values = EFCObjectListEditor.this.getPossibleKeys();
            char keyChar = event.getKeyChar();
            if (Character.isISOControl(keyChar)) {
                return;
            }
            String currentText = EFCObjectListEditor.this.myTextField.getText();
            int selectionStart = EFCObjectListEditor.this.myTextField.getSelectionStart();
            int selectionPoint = selectionStart > (selectionEnd = EFCObjectListEditor.this.myTextField.getSelectionEnd()) ? selectionEnd : selectionStart;
            currentText = currentText.substring(0, selectionPoint);
            for (String string : values) {
                if (!currentText.equals(string)) continue;
                return;
            }
            int i = EFCObjectListEditor.this.myTextField.getCaretPosition();
            if (i != currentText.length()) {
                return;
            }
            for (String string : values) {
                if (!string.startsWith(currentText + keyChar)) continue;
                EFCObjectListEditor.this.myTextField.setText(string);
                EFCObjectListEditor.this.myTextField.setCaretPosition(string.length());
                if (i + 1 <= string.length()) {
                    EFCObjectListEditor.this.myTextField.moveCaretPosition(i + 1);
                }
                event.consume();
                break;
            }
            EFCObjectListEditor.this.setModified(true);
        }
    }

    private class OLEFocusHandler
    extends EFCAbstractEditor.FocusChangeHandler {
        private OLEFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            EFCObjectListEditor.this.onFocusString = EFCObjectListEditor.this.myTextField.getText();
            EFCObjectListEditor.this.onFocusValue = EFCObjectListEditor.this.getValue();
            if (!EFCObjectListEditor.this.doFocusHandling) {
                return;
            }
            if (event.getSource() instanceof JButton) {
                EFCObjectListEditor.this.dropDownButton.transferFocus();
            }
            if (event.getOppositeComponent() == EFCObjectListEditor.this.dropDownButton || event.getOppositeComponent() == EFCObjectListEditor.this.primaryPopupTable || event.getOppositeComponent() == EFCObjectListEditor.this.myTextField) {
                return;
            }
            super.focusGained(event);
        }

        @Override
        public void focusLost(FocusEvent event) {
            if (!EFCObjectListEditor.this.isEditable() || !EFCObjectListEditor.this.doFocusHandling || event.getOppositeComponent() == EFCObjectListEditor.this.primaryPopupTable || event.getOppositeComponent() == EFCObjectListEditor.this.myTextField || event.getSource() instanceof JButton) {
                return;
            }
            if (EFCObjectListEditor.this.handleDataChange()) {
                super.focusLost(event);
            }
        }
    }
}

