/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.NumberType;
import de.effectivecompany.base.datatypes.OptionObject;
import de.effectivecompany.gui.components.edgeicon.EIComboBox;
import de.effectivecompany.gui.components.edgeicon.EITextField;
import de.effectivecompany.gui.components.editor.EFCAbstractEditor;
import de.effectivecompany.gui.components.editor.EFCAbstractPrimaryEditor;
import de.effectivecompany.gui.components.model.CBEntry;
import de.effectivecompany.gui.components.model.MapComboBoxModel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCOptionCellRenderer;
import de.effectivecompany.gui.data.BusinessObjectModel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SpringLayout;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.JTextComponent;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCOptionEditor
extends EFCAbstractPrimaryEditor {
    private static Logger logger = LoggerFactory.getLogger(EFCOptionEditor.class);
    private static final long serialVersionUID = -6354L;
    private MapComboBoxModel model;
    private boolean enable = true;
    private boolean editable = true;
    private Class<? extends OptionObject> optionClass;
    protected EIComboBox myComboBox;
    protected EITextField myTextField;

    public EFCOptionEditor(String ident) {
        this(ident, null, false, false, null, true);
    }

    public EFCOptionEditor(String ident, Object option, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        this(ident, option, info, dropDownButtonEnabled, label, withLabel);
        this.setBusinessObjectModel(boModel);
        String optionClassName = boModel.getAttributeInfo(ident).getSecondClassName();
        try {
            Class optionClass = ClassUtils.getClass((String)optionClassName);
            this.setOptionClass(optionClass);
        }
        catch (ClassNotFoundException ex) {
            logger.warn("option class not found: {}", (Object)optionClassName);
        }
    }

    public EFCOptionEditor(String ident, Object option, boolean info, boolean dropDownButtonEnabled, String label, boolean withLabel) {
        super(ident, info, dropDownButtonEnabled, label, withLabel);
        OptionFocusChangeHandler focusHandler = new OptionFocusChangeHandler();
        EFCAbstractEditor.UserInputHandler userInputHandler = new EFCAbstractEditor.UserInputHandler(this.getIdent());
        this.initComboBox(focusHandler, userInputHandler);
        if (option instanceof ComboBoxModel) {
            this.myComboBox.setModel((ComboBoxModel)option);
        }
        this.initMyTextField(focusHandler, userInputHandler);
        this.initLayout();
    }

    @Override
    protected void initComponents() {
        super.initComponents();
    }

    private void initComboBox(OptionFocusChangeHandler focusHandler, EFCAbstractEditor.UserInputHandler userInputHandler) {
        this.myComboBox = new EIComboBox();
        this.myComboBox.setRenderer(new EFCOptionCellRenderer());
        this.myComboBox.setMinimumSize(new Dimension(60, 10));
        this.myComboBox.setEditable(false);
        this.myComboBox.addFocusListener(focusHandler);
        this.myComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.myComboBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!EFCOptionEditor.this.myComboBox.isEnabled()) {
                    EFCOptionEditor.this.fireUserInputEvent(EFCOptionEditor.this.getIdent(), e);
                }
            }
        });
        this.myComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ') {
                    EFCOptionEditor.this.myComboBox.showPopup();
                }
            }
        });
    }

    private void initLayout() {
        SpringLayout layout = new SpringLayout();
        this.setLayout(layout);
        this.add(this.myComboBox);
        this.add(this.myTextField);
        layout.putConstraint("North", (Component)this.myComboBox, 0, "North", (Component)this);
        layout.putConstraint("Height", (Component)this, 0, "Height", (Component)this.myComboBox);
        layout.putConstraint("West", (Component)this.myComboBox, 0, "West", (Component)this);
        layout.putConstraint("Width", (Component)this, 0, "Width", (Component)this.myComboBox);
        layout.putConstraint("North", (Component)this.myTextField, 0, "North", (Component)this.myComboBox);
        layout.putConstraint("Height", (Component)this.myTextField, 0, "Height", (Component)this.myComboBox);
        layout.putConstraint("West", (Component)this.myTextField, 0, "West", (Component)this.myComboBox);
        layout.putConstraint("Width", (Component)this.myTextField, 0, "Width", (Component)this.myComboBox);
    }

    private void initMyTextField(OptionFocusChangeHandler focusHandler, EFCAbstractEditor.UserInputHandler userInputHandler) {
        this.myTextField = new EITextField();
        this.myTextField.setEditable(false);
        this.myTextField.setVisible(false);
        this.myTextField.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (EFCOptionEditor.this.myTextField.isVisible()) {
                    EFCOptionEditor.this.fireUserInputEvent(EFCOptionEditor.this.getIdent(), e);
                }
            }
        });
        this.myComboBox.addKeyListener(userInputHandler);
    }

    public void setOptionClass(Class<? extends OptionObject> optionClass) {
        this.optionClass = optionClass;
        Map map = OptionObject.getValues(optionClass);
        this.model = new MapComboBoxModel(map, optionClass);
        this.myComboBox.setModel(this.model);
    }

    public Class<? extends OptionObject> getOptionClass() {
        return this.optionClass;
    }

    @Override
    public void setEdgeImage(ImageIcon img, int edge) {
        this.myComboBox.setEdgeIcon(img, edge);
        this.myTextField.setEdgeIcon(img, edge);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.myComboBox.setSelectedIndex(-1);
        } else if (value instanceof EFCOption) {
            EFCOption option = (EFCOption)value;
            Integer optionIndex = option.getIntValue();
            int index = optionIndex == null || this.model == null ? -1 : this.model.getValueIndex(optionIndex);
            this.myComboBox.setSelectedIndex(index);
        } else if (value instanceof Integer) {
            Integer optionIndex = (Integer)value;
            int index = optionIndex == null || this.model == null ? -1 : this.model.getValueIndex(optionIndex);
            this.myComboBox.setSelectedIndex(index);
        } else {
            logger.warn(this.getIdent() + ": trying to set value with " + value.getClass());
            ComboBoxModel model = this.myComboBox.getModel();
            model.setSelectedItem(value);
            if (model.getSelectedItem() != value && value instanceof NumberType) {
                try {
                    int index = ((NumberType)value).getIntValue();
                    this.myComboBox.setSelectedIndex(index);
                }
                catch (Exception e) {
                    EFCDesktop.reportError(e);
                }
            }
        }
        Object data = this.myComboBox.getSelectedItem();
        if (data != null) {
            this.myTextField.setText(data.toString());
            this.myComboBox.setToolTipText(data.toString());
        } else {
            this.myTextField.setText("");
            this.myComboBox.setToolTipText("");
        }
        this.myTextField.setCaretPosition(0);
        this.myComboBox.repaint();
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue() != null ? this.getSimpleValue().toString() : null;
    }

    public EFCOption getValue() {
        if (this.model != null) {
            return new EFCOption(this.model.getSelectedItemValue());
        }
        return null;
    }

    @Override
    public Integer getSimpleValue() {
        return this.model.getSelectedItemValue();
    }

    @Override
    public void setEditable(boolean editable) {
        this.editable = editable;
        this.myComboBox.setVisible(editable);
        this.myTextField.setVisible(!editable);
        this.setComponentStyle();
    }

    private void setComponentStyle() {
        this.setComponentStyle(this.myComboBox);
        this.setComponentStyle(this.myTextField);
    }

    @Override
    protected void setComponentStyle(JComponent component) {
        if (this.isEnabled()) {
            component.setBackground(SystemColor.window);
        } else {
            component.setBackground(SystemColor.control);
        }
        if (this.isEditable() && !this.getMetadata().isReadOnly()) {
            component.setForeground(SystemColor.BLACK);
        } else {
            component.setForeground(SystemColor.GRAY);
        }
        if (component instanceof JTextComponent) {
            ((JTextComponent)component).setDisabledTextColor(component.getForeground());
        }
    }

    @Override
    public boolean isEditable() {
        return this.editable && !this.getMetadata().isReadOnly();
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (this.getMetadata().isReadOnly()) {
            return;
        }
        this.enable = enabled;
        this.myComboBox.setEnabled(this.enable && this.editable && !this.getMetadata().isReadOnly());
        this.setComponentStyle();
    }

    @Override
    public boolean isEnabled() {
        return this.enable;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.myComboBox;
    }

    @Override
    public void setEditorComponent(JComponent component) {
        this.myComboBox = (EIComboBox)component;
    }

    public EFCOption getOriginalValue() {
        return (EFCOption)super.getOriginalValue();
    }

    private class OptionFocusChangeHandler
    extends EFCAbstractEditor.FocusChangeHandler {
        private int onFocusSelection;

        private OptionFocusChangeHandler() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            this.onFocusSelection = EFCOptionEditor.this.myComboBox.getSelectedIndex();
            super.focusGained(e);
        }

        @Override
        public void focusLost(FocusEvent e) {
            int oldIndex;
            int newIndex = EFCOptionEditor.this.myComboBox.getSelectedIndex();
            if (newIndex != (oldIndex = this.onFocusSelection)) {
                Integer newVal = null;
                Integer oldVal = null;
                if (newIndex >= 0) {
                    newVal = ((CBEntry)EFCOptionEditor.this.model.getElementAt((int)newIndex)).value;
                }
                if (oldIndex >= 0) {
                    oldVal = ((CBEntry)EFCOptionEditor.this.model.getElementAt((int)oldIndex)).value;
                }
                EFCOptionEditor.this.fireValueChangeEvent(EFCOptionEditor.this.getIdent(), new EFCOption(oldVal), new EFCOption(newVal));
                EFCOptionEditor.this.setModified(true);
            }
            super.focusLost(e);
        }
    }
}

