/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.gui.components.editor.EFCAbstractTextEditor;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class EFCRichTextEditor
extends EFCAbstractTextEditor {
    private static final long serialVersionUID = -7437672295832345937L;
    private Font editorFont = EFCLookAndFeelManager.FONT_CODE;
    private String ident;

    public EFCRichTextEditor(String ident, String label, boolean withLabel) {
        super(ident, false, false, label, withLabel);
        this.ident = ident;
        this.textArea.setFont(this.editorFont);
        this.textArea.addMouseListener(new DoubleClickListener());
    }

    public EFCText getValue() {
        return new EFCText(this.textArea.getText());
    }

    public EFCText getOriginalValue() {
        return (EFCText)super.getOriginalValue();
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getClickCount() == 2) {
                String code = EFCRichTextEditor.this.textArea.getText();
                EFCRichTextEditor codeEditor = new EFCRichTextEditor(null, null, true);
                codeEditor.setPopup(true);
                codeEditor.setValue(code);
                Object[] message = new Object[]{"Code eingeben:", codeEditor};
                JOptionPane pane = new JOptionPane(message, -1, 2);
                JDialog dialog = pane.createDialog(null, "Code Editor");
                dialog.setLocationRelativeTo(EFCMainFrame.getInstance());
                dialog.setSize(EFCLookAndFeelManager.SIZE_FRAME_CODE_EDITOR);
                dialog.setDefaultCloseOperation(0);
                dialog.setVisible(true);
                Object selectedButton = pane.getValue();
                if (selectedButton != null && (Integer)selectedButton == 0) {
                    EFCRichTextEditor.this.setValue(codeEditor.getValue());
                    EFCRichTextEditor.this.fireValueChangeEvent(EFCRichTextEditor.this.ident, new EFCText(code), codeEditor.getValue());
                }
            }
        }
    }
}

