/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCText;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.editor.EFCAbstractTextEditor;
import de.effectivecompany.gui.components.root.EFCMainFrame;
import de.effectivecompany.gui.data.BusinessObjectModel;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import org.fife.rsta.ui.search.AbstractFindReplaceDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;

public class EFCTextEditor
extends EFCAbstractTextEditor
implements SearchListener {
    private static final long serialVersionUID = -7437672295832345937L;
    private RSyntaxTextArea codetextArea;
    private AbstractFindReplaceDialog findReplaceDialog;

    public EFCTextEditor(String ident, BusinessObjectModel boModel, boolean isFontMonospaced, String label, boolean withLabel) {
        this(ident, label, withLabel);
        if (isFontMonospaced) {
            this.setFont(EFCLookAndFeelManager.FONT_CODE);
        }
        this.setBusinessObjectModel(boModel);
        this.textArea.addMouseListener(new DoubleClickListener());
    }

    public EFCTextEditor(String ident, String label, boolean withLabel) {
        super(ident, false, false, label, withLabel);
    }

    public EFCTextEditor(boolean isPopup) {
        super(null, false, false, null, true);
        this.setPopup(isPopup);
        if (isPopup) {
            this.codetextArea = new RSyntaxTextArea();
            this.codetextArea.setSyntaxEditingStyle("text/plain");
            this.codetextArea.setCodeFoldingEnabled(true);
            RTextScrollPane sp = new RTextScrollPane((RTextArea)this.codetextArea);
            this.add((Component)sp, "Center");
        }
    }

    public EFCText getOriginalValue() {
        return (EFCText)super.getOriginalValue();
    }

    @Override
    public void terminate() {
        for (MouseListener mouseListener : this.textArea.getMouseListeners()) {
            this.textArea.removeMouseListener(mouseListener);
        }
        this.removeAll();
        this.textArea = null;
        super.terminate();
    }

    public void searchEvent(SearchEvent e) {
        SearchEvent.Type type = e.getType();
        SearchContext context = e.getSearchContext();
        SearchResult result = null;
        switch (type) {
            default: {
                result = SearchEngine.markAll((RTextArea)this.codetextArea, (SearchContext)context);
                break;
            }
            case FIND: {
                result = SearchEngine.find((JTextArea)this.codetextArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.codetextArea);
                break;
            }
            case REPLACE: {
                result = SearchEngine.replace((RTextArea)this.codetextArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.codetextArea);
                break;
            }
            case REPLACE_ALL: {
                result = SearchEngine.replaceAll((RTextArea)this.codetextArea, (SearchContext)context);
                JOptionPane.showMessageDialog((Component)e.getSource(), result.getCount() + " occurrences replaced.");
            }
        }
    }

    public String getSelectedText() {
        if (this.codetextArea != null) {
            return this.codetextArea.getSelectedText();
        }
        return "";
    }

    public JTextArea getTextArea() {
        return this.codetextArea;
    }

    @Override
    public void setEditable(boolean aFlag) {
        if (this.isPopup()) {
            this.codetextArea.setEditable(aFlag);
        } else {
            this.textArea.setEditable(aFlag);
            this.setComponentStyle(this.textArea);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.setEditable(enabled && !this.getMetadata().isReadOnly());
    }

    public EFCText getValue() {
        if (this.isPopup()) {
            if (this.codetextArea != null) {
                return new EFCText(this.codetextArea.getText());
            }
            return new EFCText();
        }
        if (this.textArea != null) {
            return new EFCText(this.textArea.getText());
        }
        return new EFCText();
    }

    @Override
    public void setValue(Object value) {
        if (this.isPopup()) {
            if (value == null) {
                this.codetextArea.setText("");
            } else if (value instanceof Type) {
                this.codetextArea.setText((String)((EFCText)value).optainValue());
            } else {
                this.codetextArea.setText(value.toString());
            }
            this.codetextArea.setCaretPosition(0);
            this.originalValue = this.getValue();
            this.simpleOriginalValue = this.getSimpleValue();
        } else {
            super.setValue(value);
        }
    }

    private class ShowReplaceDialogAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ShowReplaceDialogAction() {
            super(Translator.tr((String)"ACTION_SEARCH"), EFCLookAndFeelManager.ICON_TOOLBAR_SEARCH);
            this.putValue("AcceleratorKey", KeyStroke.getAWTKeyStroke(70, 128));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            EFCTextEditor.this.findReplaceDialog.setVisible(true);
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        @Override
        public void mousePressed(MouseEvent event) {
            if (event.getClickCount() == 2) {
                JOptionPane pane;
                String code = EFCTextEditor.this.textArea.getText();
                EFCTextEditor codeEditor = new EFCTextEditor(true);
                codeEditor.setValue(code);
                Object[] message = new Object[]{codeEditor};
                if (!EFCTextEditor.this.textArea.isEditable()) {
                    codeEditor.setEditable(false);
                    JButton cancel = new JButton(Translator.tr((String)"_CANCEL"));
                    pane = new JOptionPane(message, -1, 2, null, new Object[]{cancel}, cancel);
                    cancel.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            pane.setValue(2);
                        }
                    });
                } else {
                    pane = new JOptionPane(message, -1, 2);
                }
                JDialog dialog = pane.createDialog("Text Editor");
                EFCTextEditor.this.findReplaceDialog = EFCTextEditor.this.isEnabled() && EFCTextEditor.this.isEditable() ? new ReplaceDialog((Dialog)dialog, (SearchListener)codeEditor) : new FindDialog((Dialog)dialog, (SearchListener)codeEditor);
                EFCTextEditor.this.findReplaceDialog.setLocationRelativeTo((Component)EFCMainFrame.getInstance());
                KeyStroke stroke = KeyStroke.getKeyStroke(70, 128);
                codeEditor.getTextArea().registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EFCTextEditor.this.findReplaceDialog.setVisible(true);
                    }
                }, stroke, 2);
                JToolBar toolBar = new JToolBar();
                toolBar.setFloatable(false);
                toolBar.add(new ShowReplaceDialogAction());
                dialog.setLocationRelativeTo(EFCMainFrame.getInstance());
                dialog.add((Component)toolBar, "North");
                dialog.setIconImage(EFCLookAndFeelManager.ICON_APP_TEXT_EDITOR.getImage());
                dialog.setSize(EFCLookAndFeelManager.SIZE_FRAME_CODE_EDITOR);
                dialog.setResizable(true);
                dialog.setDefaultCloseOperation(0);
                dialog.setVisible(true);
                Object selectedButton = pane.getValue();
                if (selectedButton != null && (Integer)selectedButton == 0 && EFCTextEditor.this.isEnabled()) {
                    EFCTextEditor.this.setValue(codeEditor.getValue());
                    EFCTextEditor.this.fireValueChangeEvent(EFCTextEditor.this.getIdent(), new EFCText(code), codeEditor.getValue());
                }
            }
        }
    }
}

