/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor;

import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.base.datatypes.EFCTime;
import de.effectivecompany.gui.components.editor.EFCAbstractAlphaNumericEditor;
import de.effectivecompany.gui.data.BusinessObjectModel;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

public class EFCTimeEditor
extends EFCAbstractAlphaNumericEditor {
    static final long serialVersionUID = -62567417L;

    public EFCTimeEditor(String ident, BusinessObjectModel boModel, boolean info, boolean dropDownButtonEnabled, int size, int width, String label, boolean withLabel) {
        super(ident, boModel, info, dropDownButtonEnabled, size, width, label, withLabel);
    }

    @Override
    protected boolean isCharValid(char ch) {
        if (!Character.isDigit(ch) && ch != ':' && ch != 'a' && ch != ' ' && ch != 'p' && ch != 'a' && ch != 'm') {
            return false;
        }
        return super.isCharValid(ch);
    }

    @Override
    public void setValue(Object value) {
        DateFormat df = SimpleDateFormat.getTimeInstance();
        if (value instanceof Number) {
            this.textField.setText(df.format((Number)value));
        } else if (value instanceof String) {
            this.textField.setText((String)value);
        } else if (value instanceof EFCTime) {
            if (((EFCTime)value).optainValue() != null) {
                this.textField.setText(df.format(((EFCTime)value).optainValue()));
            } else {
                this.textField.setText("");
            }
        } else if (value instanceof EFCDateTime) {
            if (((EFCDateTime)value).optainValue() != null) {
                this.textField.setText(df.format(((EFCDateTime)value).optainValue()));
            } else {
                this.textField.setText("");
            }
        } else {
            this.textField.setText("");
        }
        this.originalValue = this.getValue();
        this.simpleOriginalValue = this.getSimpleValue();
    }

    public EFCTime getValue() {
        return new EFCTime(this.textField.getText());
    }
}

