/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor.table;

import de.effectivecompany.base.datatypes.EFCDateTime;
import de.effectivecompany.gui.components.editor.table.EFCAbstractCellEditor;
import de.effectivecompany.gui.components.editor.util.DateTimeFormatter;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class EFCDateTimeCellEditor
extends EFCAbstractCellEditor {
    protected JTextField component = new JTextField();
    private DateFormat format;
    private static KeyListener dateKeyFilter = new KeyAdapter(){

        @Override
        public void keyTyped(KeyEvent event) {
            char ch;
            if (!event.isConsumed() && (ch = event.getKeyChar()) != '\b' && ch != '\u007f' && ch != '\n' && ch != '\t' && !Character.isDigit(ch) && ch != '.' && ch != '-' && ch != ' ' && ch != '/' && ch != ':') {
                event.consume();
            }
        }
    };

    public EFCDateTimeCellEditor() {
        this.styleComponent(this.component);
        this.format = DateFormat.getDateTimeInstance();
        this.component.addKeyListener(dateKeyFilter);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setBorder(Border b) {
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.component.setText("");
        } else if (value instanceof EFCDateTime) {
            this.component.setText(this.format.format(((EFCDateTime)value).getDate()));
        } else if (value instanceof Date) {
            this.component.setText(this.format.format((Date)value));
        } else if (value instanceof Long) {
            this.component.setText(this.format.format(new Date((Long)value)));
        } else {
            this.component.setText(value.toString());
        }
    }

    @Override
    public Object getValue() {
        if ("".equals(this.component.getText().trim())) {
            return null;
        }
        try {
            Date date = DateTimeFormatter.convertDate(this.component.getText().trim());
            this.setValue(date);
            return date;
        }
        catch (Exception ex) {
            throw new RuntimeException("error getting value from " + this.component.getText().trim(), ex);
        }
    }
}

