/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.editor.table;

import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.datatypes.OptionMetadata;
import de.effectivecompany.base.datatypes.OptionObject;
import de.effectivecompany.base.datatypes.Type;
import de.effectivecompany.gui.components.editor.table.EFCAbstractCellEditor;
import de.effectivecompany.gui.components.model.CBEntry;
import de.effectivecompany.gui.components.model.MapComboBoxModel;
import java.awt.Component;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.border.Border;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EFCOptionCellEditor
extends EFCAbstractCellEditor {
    private static Logger logger = LoggerFactory.getLogger(EFCOptionCellEditor.class);
    private MapComboBoxModel model;
    protected JComboBox component = new JComboBox();
    protected boolean emptyAllowed = true;
    protected Map<String, Integer> options;
    protected Class<? extends OptionObject> optionClass;

    public EFCOptionCellEditor(boolean allowEmpty) {
        this(allowEmpty, null);
    }

    public EFCOptionCellEditor(boolean allowEmpty, Class<? extends OptionObject> optionClass) {
        this.optionClass = optionClass;
        try {
            if (optionClass != null) {
                this.options = OptionObject.getValues(optionClass);
                this.model = new MapComboBoxModel(this.options, optionClass);
                this.component.setModel(this.model);
            }
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (IllegalArgumentException ex) {
            ex.printStackTrace();
        }
        this.setEmptyAllowed(allowEmpty);
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public void setBorder(Border b) {
    }

    @Override
    public void setValue(Type efcValue) {
        this.setValue((Object)efcValue);
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.component.setSelectedIndex(-1);
            return;
        }
        if (value instanceof Type) {
            if (value instanceof EFCOption) {
                EFCOption option = (EFCOption)value;
                this.component.setSelectedIndex(-1);
                this.optionClass = ((OptionMetadata)option.getMetadata()).getOptions().asSubclass(OptionObject.class);
                if (this.optionClass != null) {
                    try {
                        Integer i = option.getIntValue();
                        Integer pos = null;
                        this.options = OptionObject.getValues(this.optionClass);
                        this.model = new MapComboBoxModel(this.options, this.optionClass);
                        this.model.setWithNullField(this.isEmptyAllowed());
                        this.component.setModel(this.model);
                        if (i != null) {
                            pos = this.model.getValueIndex(i);
                        }
                        this.component.setSelectedIndex(pos == null ? -1 : pos);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            } else {
                value = ((Type)value).optainValue();
                this.setSelectedIndex(value);
            }
        } else {
            if (this.options == null) {
                logger.error("trying to set a value in a empty editor, aborting");
                return;
            }
            this.setSelectedIndex(value);
        }
    }

    private void setSelectedIndex(Object value) {
        if (value instanceof Number) {
            this.component.setSelectedIndex(((Number)value).intValue());
        }
    }

    @Override
    public Object getValue() {
        if (this.component.getSelectedIndex() == -1) {
            return null;
        }
        CBEntry entry = (CBEntry)this.model.getElementAt(this.component.getSelectedIndex());
        return entry == null ? null : entry.value;
    }

    public void setEmptyAllowed(boolean emptyAllowed) {
        this.emptyAllowed = emptyAllowed;
        if (this.model != null) {
            this.model.setWithNullField(this.emptyAllowed);
        }
    }

    public boolean isEmptyAllowed() {
        return this.emptyAllowed;
    }
}

