/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame;

import de.effectivecompany.base.gui.data.DefaultSearchService;
import de.effectivecompany.data.DummyGuiService;
import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.frame.EFCInternalFrameView;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JTextPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class EFCFrameInfo
extends JInternalFrame {
    private static final long serialVersionUID = -8519574533884184614L;
    private EFCController parent;
    private JTextPane activeIdentLabel;

    public EFCFrameInfo(EFCController base) {
        super("Fenster-Info: " + base.getView().getTitle(), true, true);
        EFCInternalFrameView viewFrame = base.getView();
        this.setSize(EFCLookAndFeelManager.SIZE_DIALOG_FRAMEINFO);
        this.setFrameIcon(EFCLookAndFeelManager.ICON_APP_WUG);
        this.setLocation(viewFrame.getStartX() + 50, viewFrame.getStartY() + 50);
        this.setFont(EFCLookAndFeelManager.FONT_EFC_STANDARD);
        this.setDefaultCloseOperation(1);
        this.parent = base;
        viewFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                if ("title".equals(event.getPropertyName())) {
                    EFCFrameInfo.this.setTitle("Fenster-Info: " + EFCFrameInfo.this.parent.getView().getTitle());
                }
                if ("lastfield".equals(event.getPropertyName())) {
                    EFCFrameInfo.this.activeIdentLabel.setText(event.getNewValue().toString());
                }
            }
        });
        viewFrame.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                EFCFrameInfo.this.parent = null;
                EFCFrameInfo.this.setVisible(false);
                if (EFCFrameInfo.this.getParent() != null) {
                    EFCFrameInfo.this.getParent().remove(EFCFrameInfo.this);
                }
                EFCFrameInfo.this.dispose();
            }
        });
        this.setLayout(null);
        int y = 5;
        int height = 15;
        int space = 25;
        int x1 = 5;
        int x2 = 125;
        int width1 = 100;
        int width2 = 400;
        this.add(new JLabel("Business-Object:")).setBounds(x1, y, width1, height);
        JTextPane efcBOClassSimpleName = new JTextPane();
        efcBOClassSimpleName.setText(this.createEFCClassSimpleName(base.getBusinessObjectClass()));
        efcBOClassSimpleName.setEditable(false);
        efcBOClassSimpleName.setBackground(null);
        efcBOClassSimpleName.setBorder(null);
        this.add(efcBOClassSimpleName).setBounds(x2, y, width2, height);
        this.add(new JLabel("Frame:")).setBounds(x1, y += space, width1, height);
        JTextPane efcClassSimpleName = new JTextPane();
        efcClassSimpleName.setText(this.createEFCClassSimpleName(base.getClass()));
        efcClassSimpleName.setEditable(false);
        efcClassSimpleName.setBackground(null);
        efcClassSimpleName.setBorder(null);
        this.add(efcClassSimpleName).setBounds(x2, y, width2, height);
        this.add(new JLabel("GUI-Service:")).setBounds(x1, y += space, width1, height);
        JTextPane guiServiceSimpleName = new JTextPane();
        guiServiceSimpleName.setText(this.createServiceSimpleName(base.getGuiService()));
        guiServiceSimpleName.setEditable(false);
        guiServiceSimpleName.setBackground(null);
        guiServiceSimpleName.setBorder(null);
        this.add(guiServiceSimpleName).setBounds(x2, y, width2, height);
        this.add(new JLabel("Such-Service:")).setBounds(x1, y += space, width1, height);
        JTextPane searchServiceSimpleName = new JTextPane();
        searchServiceSimpleName.setText(this.createServiceSimpleName(base.getSearchService()));
        searchServiceSimpleName.setEditable(false);
        searchServiceSimpleName.setBackground(null);
        searchServiceSimpleName.setBorder(null);
        this.add(searchServiceSimpleName).setBounds(x2, y, width2, height);
        this.add(new JLabel("Layout:")).setBounds(x1, y += space, width1, height);
        JTextPane layoutFileName = new JTextPane();
        layoutFileName.setText(base.getLayoutFileName());
        layoutFileName.setEditable(false);
        layoutFileName.setBackground(null);
        layoutFileName.setBorder(null);
        this.add(layoutFileName).setBounds(x2, y, width2, height);
        this.add(new JLabel("Druckprogramm:")).setBounds(x1, y += space, width1, height);
        JTextPane printListId = new JTextPane();
        printListId.setText(base.getPrintListId());
        printListId.setEditable(false);
        printListId.setBackground(null);
        printListId.setBorder(null);
        this.add(printListId).setBounds(x2, y, width2, height);
        this.add(new JLabel("Ident aktives Feld:")).setBounds(x1, y += space, width1, height);
        this.activeIdentLabel = new JTextPane();
        this.activeIdentLabel.setEditable(false);
        this.activeIdentLabel.setBackground(null);
        this.activeIdentLabel.setBorder(null);
        this.add(this.activeIdentLabel).setBounds(x2, y, width2, height);
        this.setVisible(true);
    }

    private String createServiceSimpleName(Object service) {
        if (service == null) {
            return "";
        }
        if (service instanceof DummyGuiService) {
            return "Dummy GUI-Service";
        }
        if (service instanceof DefaultSearchService) {
            return "Dummy SEARCH-Service";
        }
        String name = service.toString();
        String[] strings = name.split("/");
        name = strings[strings.length - 1];
        strings = name.split("\\n");
        return strings[0];
    }

    private String createEFCClassSimpleName(Class<?> bo) {
        if (bo == null) {
            return "";
        }
        String name = bo.getCanonicalName();
        name = name.replace("de.effectivecompany.", "");
        return name;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.parent = null;
    }
}

