/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame;

import de.effectivecompany.gui.components.EFCController;
import de.effectivecompany.gui.components.EFCMainMenu;
import de.effectivecompany.gui.components.EFCStatusBar;
import de.effectivecompany.gui.components.EFCToolBar;
import de.effectivecompany.gui.components.frame.EFCFrameInfo;
import de.effectivecompany.gui.components.panel.EFCButtonPanel;
import de.effectivecompany.gui.components.panel.EFCPanel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCLayoutFocusTraversalPolicy;
import de.effectivecompany.gui.components.swing.layout.EFCInternalFrameUI;
import de.effectivecompany.gui.handlers.FrameEventHandler;
import de.effectivecompany.gui.interfaces.frame.BaseDialog;
import de.effectivecompany.gui.interfaces.frame.EFCView;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.InternalFrameEvent;

public class EFCInternalFrameView
extends JInternalFrame
implements EFCView {
    private static final long serialVersionUID = -8975811145200723144L;
    private EFCController controller;
    private EFCMainMenu mainMenu;
    private EFCToolBar toolBar;
    private EFCStatusBar statusBar;
    private JPanel panel = new JPanel();
    private JPanel glass = new JPanel();
    private EFCFrameInfo infoBox;
    private JComponent mainPanel;
    private static int startX = 160;
    private static int startY = 0;
    private boolean dialogView;
    private boolean autoSize;
    private static final int PANEL_DIVIDER = 2;
    EFCFrameEventHandler eventHandler = new EFCFrameEventHandler();
    private boolean isLocked;
    private EFCButtonPanel buttonPanel;

    public EFCInternalFrameView(String title, Dimension dimension, EFCController controller) {
        super(title, true, true, true, true);
        this.controller = controller;
        this.addComponentListener(this.eventHandler);
        this.addInternalFrameListener(this.eventHandler);
        this.glass.setOpaque(false);
        this.glass.addMouseListener(new MouseAdapter(){});
        this.setGlassPane(this.glass);
        if (dimension != null) {
            this.setSize(UnitConverter.sizeFromDLU(dimension, EFCDesktop.getInstance()));
            this.setPreferredSize((Dimension)dimension.clone());
        } else {
            this.autoSize = true;
        }
        this.setDefaultCloseOperation(0);
        this.initLocation();
        this.moveToFront();
        this.panel.setBorder(null);
        this.panel.setLayout(new BorderLayout());
        this.setContentPane(this.panel);
        this.setDesktopIcon(new JInternalFrame.JDesktopIcon(this){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension d = this.getMinimumSize();
                String title = EFCInternalFrameView.this.getTitle();
                FontMetrics fm = this.getFontMetrics(EFCLookAndFeelManager.FONT_EFC_STANDARD);
                d.width += SwingUtilities.computeStringWidth(fm, title) - 16;
                return d;
            }
        });
        this.setFocusTraversalPolicy(new EFCLayoutFocusTraversalPolicy());
    }

    public EFCInternalFrameView(String title, Dimension dimension, EFCController controller, String[] buttonNames) {
        this(title, dimension, controller);
        this.addButtonBar(buttonNames);
    }

    public void addButtonBar(String[] buttonNames) {
        this.buttonPanel = new EFCButtonPanel(buttonNames, this);
        this.panel.add((Component)this.buttonPanel, "South");
    }

    public EFCButtonPanel getButtonPanel() {
        return this.buttonPanel;
    }

    private void initLocation() {
        this.setLocation(startX, startY);
        startY += 20;
        if ((startX += 20) > 380) {
            startX = 160;
        }
        if (startY > 230) {
            startY = 0;
        }
    }

    public JComponent getMainPanel() {
        return this.panel;
    }

    @Override
    public EFCMainMenu getEFCMainMenu() {
        return this.mainMenu;
    }

    @Override
    public EFCToolBar getEFCToolBar() {
        return this.toolBar;
    }

    @Override
    public EFCStatusBar getEFCStatusBar() {
        return this.statusBar;
    }

    @Override
    public void setEFCMainMenu(EFCMainMenu mainMenu) {
        this.mainMenu = mainMenu;
        mainMenu.setActionHandler(this.controller);
        mainMenu.setEnabledActions(this.controller.getMenu());
        this.setJMenuBar(mainMenu);
    }

    @Override
    public void setEFCToolBar(EFCToolBar toolBar) {
        this.toolBar = toolBar;
        toolBar.setFloatable(false);
        this.panel.add((Component)toolBar, "North");
    }

    @Override
    public void setEFCStatusBar() {
        EFCThreadUtil.doLaterFAT(() -> {
            this.statusBar = new EFCStatusBar(2);
            JFXPanel statusbarPanel = new JFXPanel();
            statusbarPanel.setScene(new Scene((Parent)this.statusBar));
            if (this.panel != null) {
                this.panel.add((Component)statusbarPanel, "South");
            }
        });
    }

    public boolean isDialogView() {
        return this.dialogView;
    }

    public void setDialogView(boolean dialogView) {
        this.dialogView = dialogView;
    }

    public JComponent setMainPanel(JComponent myPanel) {
        if (this.isDialogView() && this.autoSize) {
            this.initMainPanel(myPanel);
            this.pack();
            this.setSize(new Dimension(this.getWidth() / 2 + 30, this.getHeight()));
        } else {
            this.initMainPanel(myPanel);
        }
        return this.mainPanel;
    }

    private void initMainPanel(JComponent myPanel) {
        if (this.mainPanel != null) {
            this.panel.remove(this.mainPanel);
        }
        this.mainPanel = myPanel;
        this.panel.add((Component)this.mainPanel, "Center");
    }

    @Override
    public Container getContentPane() {
        return this.panel;
    }

    @Override
    public void fireChangeEvent(String property, String oldIdent, String newIdent) {
        this.firePropertyChange(property, oldIdent, newIdent);
    }

    public void lockFrame() {
        this.glass.setVisible(true);
        this.setCursor(new Cursor(3));
        this.statusBar.setProgressBarVisible(true);
        if (this.controller instanceof BaseDialog) {
            ((BaseDialog)((Object)this.controller)).lockFrame();
        }
        this.controller.setControlLocked(true);
        this.isLocked = true;
        if (this.mainMenu != null) {
            this.mainMenu.setMenusEnabled(false);
        }
    }

    public void unlockFrame() {
        this.glass.setVisible(false);
        this.setCursor(new Cursor(0));
        this.statusBar.setProgressBarVisible(false);
        if (this.controller instanceof BaseDialog) {
            ((BaseDialog)((Object)this.controller)).unLockFrame();
        }
        this.controller.setControlLocked(false);
        this.isLocked = false;
        if (this.mainMenu != null) {
            this.mainMenu.setMenusEnabled(true);
        }
    }

    @Override
    public void dispose() {
        this.removeComponentListener(this.eventHandler);
        this.removeInternalFrameListener(this.eventHandler);
        this.removeAll();
        if (this.mainMenu != null) {
            this.mainMenu.terminate();
        }
        if (this.mainPanel != null && this.mainPanel instanceof EFCPanel) {
            ((EFCPanel)this.mainPanel).terminate();
        }
        this.mainPanel = null;
        this.rootPane = null;
        this.eventHandler = null;
        this.mainMenu = null;
        this.toolBar = null;
        this.statusBar = null;
        this.glass = null;
        this.controller = null;
        this.panel = null;
        super.dispose();
        if (this.infoBox != null) {
            EFCFrameInfo info = this.infoBox;
            this.infoBox = null;
            EFCDesktop.getInstance().remove(info);
            info.setVisible(false);
            info.dispose();
        }
    }

    public void setStartX(int startX) {
        EFCInternalFrameView.startX = startX;
    }

    public int getStartX() {
        return startX;
    }

    public int getStartY() {
        return startY;
    }

    @Override
    public EFCController getController() {
        return this.controller;
    }

    @Override
    public void setVisible(boolean aFlag) {
        if (this.dialogView && aFlag) {
            this.setDialogPosition();
        }
        super.setVisible(aFlag);
    }

    private void setDialogPosition() {
        EFCInternalFrameView controllerView = this.controller.getParentController().getView();
        int xOffset = (controllerView.getWidth() - this.getWidth()) / 2;
        int yOffset = (controllerView.getHeight() - this.getHeight()) / 2;
        int tmpStartX = controllerView.getX() + xOffset;
        int tmpStartY = controllerView.getY() + yOffset;
        if (tmpStartX < 0) {
            tmpStartX = 0;
        }
        if (tmpStartY < 0) {
            tmpStartY = 0;
        }
        this.setLocation(tmpStartX, tmpStartY);
    }

    private class EFCFrameEventHandler
    extends FrameEventHandler {
        private EFCFrameEventHandler() {
        }

        @Override
        public void componentResized(ComponentEvent event) {
            if (EFCInternalFrameView.this.getUI() instanceof EFCInternalFrameUI) {
                ((EFCInternalFrameUI)((Object)EFCInternalFrameView.this.getUI())).setLockButtonPosition();
            }
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent event) {
            if (!EFCInternalFrameView.this.isLocked && EFCInternalFrameView.this.controller != null) {
                EFCInternalFrameView.this.controller.handleAction("exit", null);
            }
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent event) {
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent event) {
            EFCInternalFrameView.this.controller.setFrameIcon(true);
            if (EFCInternalFrameView.this.getUI() instanceof EFCInternalFrameUI) {
                ((EFCInternalFrameUI)((Object)EFCInternalFrameView.this.getUI())).setLockButtonPosition();
            }
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent event) {
            EFCInternalFrameView.this.controller.setFrameIcon(false);
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            if (EFCInternalFrameView.this.getUI() instanceof EFCInternalFrameUI) {
                ((EFCInternalFrameUI)((Object)EFCInternalFrameView.this.getUI())).setLockButtonPosition();
            }
        }
    }
}

