/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame;

import de.effectivecompany.base.datatypes.EFCMoney;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.data.EFCReportContainer;
import de.effectivecompany.gui.actions.EFCActionExit;
import de.effectivecompany.gui.components.EFCPrintPreviewDialog;
import de.effectivecompany.gui.components.EFCStatusBar;
import de.effectivecompany.gui.components.frame.EFCPDFViewer;
import de.effectivecompany.gui.components.model.table.StatisticDataTableModel;
import de.effectivecompany.gui.components.root.EFCDesktop;
import de.effectivecompany.gui.components.swing.EFCTableCellRenderer;
import de.effectivecompany.gui.factory.EFCPrintFactory;
import de.effectivecompany.gui.factory.EFCReportSingleton;
import de.effectivecompany.gui.manager.EFCLookAndFeelManager;
import de.effectivecompany.gui.util.CSVUtil;
import de.effectivecompany.gui.util.ClipboardUtil;
import de.effectivecompany.gui.util.EFCThreadUtil;
import de.effectivecompany.gui.util.UnitConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javafx.embed.swing.JFXPanel;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class EFCTableExportDialog
extends JDialog {
    private static final long serialVersionUID = -6875433208060663143L;
    private JScrollPane scrollArea;
    private JXTable table;
    private EFCStatusBar statusbar;
    private JPanel basePanel;
    private JToolBar toolBar;
    private JTable parentTable;

    public EFCTableExportDialog(JTable tModel) {
        DefaultTableColumnModelExt colModel;
        this.parentTable = tModel;
        this.table = new JXTable(){

            public void changeSelection(int rowIndex, int columnIndex, boolean toggle, boolean extend) {
                if (this.getSelectedColumnCount() == 1 && this.getSelectedRowCount() == 1) {
                    super.changeSelection(rowIndex, columnIndex, !extend, extend);
                } else {
                    super.changeSelection(rowIndex, columnIndex, toggle, extend);
                }
            }
        };
        this.table.setHorizontalScrollEnabled(true);
        this.table.setSortable(false);
        this.table.setEditable(false);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new EFCTableCellRenderer());
        if (tModel.getModel() instanceof StatisticDataTableModel) {
            StatisticDataTableModelExp expModel = new StatisticDataTableModelExp((StatisticDataTableModel)tModel.getModel());
            this.table.setModel((TableModel)expModel);
            colModel = new DefaultTableColumnModelExt();
            for (TableColumn column : this.table.getColumns()) {
                colModel.addColumn(column);
            }
            this.table.setColumnModel((TableColumnModel)colModel);
        } else {
            DefaultTableModel model = new DefaultTableModel();
            for (int i = 0; i < this.parentTable.getColumnCount(); ++i) {
                ArrayList<Object> colData = new ArrayList<Object>(this.parentTable.getRowCount());
                for (int j = 0; j < this.parentTable.getRowCount(); ++j) {
                    colData.add(this.parentTable.getValueAt(j, i));
                }
                model.addColumn((Object)this.parentTable.getColumnName(i).toString(), colData.toArray());
            }
            this.table.setModel((TableModel)model);
            colModel = new DefaultTableColumnModelExt();
            if (this.table.getColumnModel() instanceof DefaultTableColumnModelExt) {
                DefaultTableColumnModelExt columnModel = (DefaultTableColumnModelExt)this.table.getColumnModel();
                for (TableColumn column : columnModel.getColumns(false)) {
                    colModel.addColumn((TableColumn)new TableColumnExt((TableColumnExt)column));
                }
            }
            this.table.setColumnModel((TableColumnModel)colModel);
        }
        this.table.setRowSelectionAllowed(false);
        this.table.setCellSelectionEnabled(true);
        this.table.getColumnModel().setColumnSelectionAllowed(true);
        this.table.getSelectionModel().setSelectionMode(1);
        this.scrollArea = new JScrollPane((Component)this.table);
        this.toolBar = new JToolBar();
        this.toolBar.setFloatable(false);
        EFCActionExit actionExit = new EFCActionExit(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EFCTableExportDialog.this.setVisible(false);
                EFCTableExportDialog.this.dispose();
            }
        };
        JButton button = this.toolBar.add(actionExit);
        KeyStroke stroke = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.rootPane.getInputMap(2);
        inputMap.put(stroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", actionExit);
        button.setBorderPainted(false);
        button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, this.toolBar));
        this.toolBar.addSeparator();
        button = this.toolBar.add(new PrintDirectAction());
        button.setBorderPainted(false);
        button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, this.toolBar));
        button = this.toolBar.add(new ToClipboardAction());
        button.setBorderPainted(false);
        button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, this.toolBar));
        button = this.toolBar.add(new ToCSVAction());
        button.setBorderPainted(false);
        button.setPreferredSize(UnitConverter.sizeFromDLU(EFCLookAndFeelManager.SIZE_BUTTON_TOOLBAR, this.toolBar));
        this.statusbar = new EFCStatusBar();
        this.basePanel = new JPanel();
        this.basePanel.setLayout(new BorderLayout());
        this.basePanel.add((Component)this.toolBar, "North");
        this.basePanel.add((Component)this.scrollArea, "Center");
        JFXPanel statusbarPanel = new JFXPanel();
        EFCThreadUtil.doLaterFAT(() -> statusbarPanel.setScene(new Scene((Parent)this.statusbar)));
        this.basePanel.add((Component)statusbarPanel, "South");
        this.setContentPane(this.basePanel);
        this.setSize(EFCLookAndFeelManager.SIZE_DIALOG_DATA_EXPORT);
        this.setIconImage(EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT.getImage());
        this.setTitle(Translator.tr((String)"DLG_TITLE_DATAEXPORT"));
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
    }

    public TableModel getModel() {
        return this.table.getModel();
    }

    public void setColumnModel(TableColumnModel columnModel) {
        this.table.setColumnModel(columnModel);
    }

    @Override
    public void dispose() {
        this.parentTable = null;
        this.basePanel.removeAll();
        this.removeAll();
        this.basePanel = null;
        this.scrollArea = null;
        if (this.statusbar != null) {
            this.statusbar.terminate();
        }
        this.statusbar = null;
        this.table = null;
        this.toolBar = null;
        super.dispose();
    }

    private class PrintDirectAction
    extends AbstractAction {
        private static final long serialVersionUID = 412669463194245153L;

        public PrintDirectAction() {
            super(Translator.tr((String)"ACTION_PRINT_DIRECT"));
            this.putValue("SmallIcon", EFCLookAndFeelManager.ICON_TOOLBAR_PRINT_DIRECT);
            this.putValue("SwingLargeIconKey", EFCLookAndFeelManager.ICON_TOOLBAR_PRINT_DIRECT);
            this.putValue("ShortDescription", Translator.tr((String)"ACTION_PRINT_DIRECT_DESC"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            EFCThreadUtil.edtBuilder(th -> th.doOutside(() -> {
                EFCReportContainer reportContainer = EFCReportSingleton.getInstance().buildReport((JTable)EFCTableExportDialog.this.table);
                th.edt(() -> {
                    EFCTableExportDialog.this.setVisible(false);
                    EFCTableExportDialog.this.dispose();
                    int selection = new EFCPrintPreviewDialog().getSelection();
                    if (selection == 0) {
                        EFCPDFViewer viewer = new EFCPDFViewer(reportContainer, Translator.tr((String)"DLG_TITLE_REPORT_PREVIEW_PRINT_DIRECT"));
                        EFCDesktop.getInstance().add(viewer);
                    } else if (selection == 1) {
                        new EFCPrintFactory().print(reportContainer);
                    }
                });
            }));
        }
    }

    private class ToCSVAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ToCSVAction() {
            super(Translator.tr((String)"ACTION_EXPORT_SAVETOHARDDISK"));
            this.putValue("SmallIcon", EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT_HD);
            this.putValue("SwingLargeIconKey", EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT_HD);
            this.putValue("ShortDescription", Translator.tr((String)"ACTION_EXPORT_SAVETOHARDDISK_DESC"));
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int startx = EFCTableExportDialog.this.table.getSelectedColumn();
            int starty = EFCTableExportDialog.this.table.getSelectedRow();
            int width = EFCTableExportDialog.this.table.getSelectedColumnCount();
            int height = EFCTableExportDialog.this.table.getSelectedRowCount();
            String csv = startx == -1 || starty == -1 || width == 1 && height == 1 ? CSVUtil.tableToCSV((JTable)EFCTableExportDialog.this.table) : CSVUtil.tableToCSV((JTable)EFCTableExportDialog.this.table, startx, starty, width, height);
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file == null) {
                        return false;
                    }
                    return file.isDirectory() || file.getName().endsWith(".csv");
                }

                @Override
                public String getDescription() {
                    return "CSV-File (*.csv)";
                }
            });
            if (fileChooser.showSaveDialog(EFCTableExportDialog.this) == 0) {
                File target = fileChooser.getSelectedFile();
                if (!target.getName().endsWith(".csv")) {
                    target = new File(target.getPath() + ".csv");
                }
                try {
                    FileWriter writer = new FileWriter(target);
                    writer.write(csv);
                    writer.flush();
                    writer.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private class ToClipboardAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public ToClipboardAction() {
            super(Translator.tr((String)"ACTION_EXPORT_SAVETOCLIPBOARD"));
            this.putValue("SmallIcon", EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT_CB);
            this.putValue("SwingLargeIconKey", EFCLookAndFeelManager.ICON_TOOLBAR_DATA_EXPORT_CB);
            this.putValue("ShortDescription", Translator.tr((String)"ACTION_EXPORT_SAVETOCLIPBOARD_DESC"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int startx = EFCTableExportDialog.this.table.getSelectedColumn();
            int starty = EFCTableExportDialog.this.table.getSelectedRow();
            int width = EFCTableExportDialog.this.table.getSelectedColumnCount();
            int height = EFCTableExportDialog.this.table.getSelectedRowCount();
            if (startx == -1 || starty == -1 || width == 1 && height == 1) {
                ClipboardUtil.tableToClipboard((JTable)EFCTableExportDialog.this.table);
            } else {
                ClipboardUtil.tableToClipboard((JTable)EFCTableExportDialog.this.table, startx, starty, width, height);
            }
        }
    }

    private class StatisticDataTableModelExp
    extends DefaultTableModel {
        private static final long serialVersionUID = -4314094123994411809L;

        public StatisticDataTableModelExp(StatisticDataTableModel model) {
            ArrayList<String> col = new ArrayList<String>(model.getRowCount());
            for (String key : model.getData().getDatasetKeys()) {
                col.add(key.toString());
            }
            this.addColumn((Object)"", col.toArray());
            for (int i = 0; i < EFCTableExportDialog.this.parentTable.getColumnCount(); ++i) {
                ArrayList<Object> colData = new ArrayList<Object>(EFCTableExportDialog.this.parentTable.getRowCount());
                for (int j = 0; j < EFCTableExportDialog.this.parentTable.getRowCount(); ++j) {
                    colData.add(EFCTableExportDialog.this.parentTable.getValueAt(j, i));
                }
                this.addColumn((Object)EFCTableExportDialog.this.parentTable.getColumnName(i).toString(), colData.toArray());
            }
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object value = super.getValueAt(rowIndex, columnIndex);
            if (value instanceof Number[]) {
                Number[] data = (Number[])value;
                value = 0.0;
                if (data.length > 0 && data[0] != null) {
                    try {
                        Double myDouble = Double.parseDouble(data[0].toString());
                        value = myDouble;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            if (value instanceof Double) {
                value = new EFCMoney((Double)value);
            }
            if (value instanceof Float) {
                value = new EFCMoney(Double.valueOf(((Float)value).doubleValue()));
            }
            return value;
        }
    }
}

