/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe;

import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchResultTable;
import de.effectivecompany.gui.components.fx.components.EFCTableView;
import java.util.Collection;
import java.util.Map;
import javafx.collections.ListChangeListener;
import javafx.scene.control.TableColumn;

public class EFCSearchCriteriaTable
extends EFCTableView<Map<String, String>> {
    private boolean reorderEnabled = true;

    public void addTableColumnListener(final EFCSearchResultTable result) {
        this.getColumns().addListener((ListChangeListener)new ListChangeListener<TableColumn>(){

            public void onChanged(ListChangeListener.Change<? extends TableColumn> c) {
                if (EFCSearchCriteriaTable.this.reorderEnabled) {
                    result.reorder(EFCSearchCriteriaTable.this);
                }
            }
        });
    }

    public void setReorderEnabled(boolean enabled) {
        this.reorderEnabled = enabled;
    }

    public void reorder(EFCSearchResultTable result) {
        this.reorderEnabled = false;
        EFCList critColumns = new EFCList();
        EFCList newCritColumns = new EFCList();
        this.getColumns().forEach(critColumn -> critColumns.add(critColumn));
        this.getColumns().clear();
        for (TableColumn resultColumn : result.getColumns()) {
            for (TableColumn critColumn2 : critColumns) {
                if (!critColumn2.getId().equalsIgnoreCase(resultColumn.getId()) || this.getColumns().contains((Object)critColumn2)) continue;
                newCritColumns.add((Object)critColumn2);
            }
        }
        this.getColumns().setAll((Collection)newCritColumns);
        this.reorderEnabled = true;
    }
}

