/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe;

import de.effectivecompany.base.datatypes.EFCList;
import de.effectivecompany.base.gui.data.SearchResult;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchCriteriaTable;
import de.effectivecompany.gui.components.frame.searchframe.EFCSearchResultTablePane;
import de.effectivecompany.gui.components.frame.searchframe.columns.EFCSearchResultTableColumn;
import de.effectivecompany.gui.components.fx.components.EFCTableView;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;

public class EFCSearchResultTable
extends EFCTableView<SearchResult> {
    private boolean reorderEnabled = true;
    private EFCSearchResultTablePane parent;

    public EFCSearchResultTable() {
        this.setEditable(false);
        this.getStyleClass().add((Object)"efcsearchtable");
    }

    public void setParent(EFCSearchResultTablePane parent) {
        this.parent = parent;
    }

    public void setCriteriaPane(final EFCSearchCriteriaTable crit) {
        this.getColumns().addListener((ListChangeListener)new ListChangeListener<TableColumn>(){

            public void onChanged(ListChangeListener.Change<? extends TableColumn> c) {
                if (EFCSearchResultTable.this.reorderEnabled && crit != null) {
                    crit.reorder(EFCSearchResultTable.this);
                }
            }
        });
    }

    public void reorder(final EFCSearchCriteriaTable criteria) {
        this.reorderEnabled = false;
        EFCList resultColumns = new EFCList();
        EFCList newResultColumns = new EFCList();
        this.getCols().forEach(critColumn -> resultColumns.add(critColumn));
        this.getColumns().clear();
        for (TableColumn critColumn2 : criteria.getColumns()) {
            for (TableColumn resultColumn : resultColumns) {
                if (!critColumn2.getId().equalsIgnoreCase(resultColumn.getId()) || this.getColumns().contains((Object)critColumn2)) continue;
                newResultColumns.add((Object)resultColumn);
            }
        }
        TableColumn<SearchResult, String> numberColumn = this.parent.getNumberColumn();
        if (numberColumn != null) {
            this.getColumns().addAll((Object[])new TableColumn[]{numberColumn});
        }
        this.getColumns().addAll((Collection)newResultColumns);
        Supplier<IntStream> intstream = () -> this.getColumns().stream().mapToInt(Arrays.asList((TableColumn[])this.getCols().toArray((Object[])new TableColumn[this.getCols().size()]))::indexOf);
        Supplier<Stream> stream = () -> ((IntStream)intstream.get()).mapToObj(Arrays.asList((TableColumn[])this.getColumns().toArray((Object[])new TableColumn[criteria.getColumns().size()]))::get);
        if (stream.get().count() > 0L) {
            criteria.setReorderEnabled(false);
            criteria.getColumns().sort((Comparator)new Comparator<TableColumn>(){

                @Override
                public int compare(TableColumn o1, TableColumn o2) {
                    int index1 = criteria.getColumns().indexOf((Object)o1);
                    int index2 = criteria.getColumns().indexOf((Object)o2);
                    return Integer.compare(index1, index2);
                }
            });
            criteria.setReorderEnabled(true);
        }
        this.reorderEnabled = true;
    }

    public void reorderEnabled(boolean enabled) {
        this.reorderEnabled = enabled;
    }

    public final ObservableList<EFCSearchResultTableColumn<?>> getEFCColumns() {
        ObservableList list = FXCollections.observableArrayList();
        this.getColumns().forEach(column -> {
            if (column instanceof EFCSearchResultTableColumn) {
                list.add((Object)((EFCSearchResultTableColumn)column));
            }
        });
        return list;
    }

    public void selectNext() {
        if (this.getSelectionModel().getSelectedIndex() < this.getItems().size() - 1) {
            this.getSelectionModel().select(this.getSelectionModel().getSelectedIndex() + 1);
            this.scrollTo(this.getSelectionModel().getSelectedIndex());
        }
    }

    public void selectBefore() {
        if (this.getSelectionModel().getSelectedIndex() < this.getItems().size() - 1) {
            this.getSelectionModel().select(this.getSelectionModel().getSelectedIndex() - 1);
            this.scrollTo(this.getSelectionModel().getSelectedIndex());
        }
    }

    public ObservableList<TableColumn<SearchResult, ?>> getCols() {
        return this.getColumns().filtered(col -> !col.getId().equals("#"));
    }

    public TableColumn<SearchResult, ?> getColumn(String id) {
        return this.getCols().stream().filter(col -> col.getId().equalsIgnoreCase(id)).findFirst().get();
    }
}

