/*
 * Decompiled with CFR 0.152.
 */
package de.effectivecompany.gui.components.frame.searchframe.columns;

import de.effectivecompany.base.datatypes.EFCOption;
import de.effectivecompany.base.i18n.Translator;
import de.effectivecompany.gui.components.frame.searchframe.columns.components.EFCSearchOptionCell;
import java.util.Map;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.cell.MapValueFactory;
import javafx.util.Callback;

public class EFCSearchCriteriaOptionColumn
extends TableColumn<Map<String, String>, EFCSearchOptionCell.CBEntry> {
    public EFCSearchCriteriaOptionColumn(String name, String optClass) {
        super(Translator.tr((String)("FLD_" + name.toUpperCase())));
        this.setId(name);
        try {
            final Class<?> optionClass = Class.forName(optClass);
            this.setCellFactory((Callback)new Callback<TableColumn<Map<String, String>, EFCSearchOptionCell.CBEntry>, TableCell<Map<String, String>, EFCSearchOptionCell.CBEntry>>(){

                public TableCell<Map<String, String>, EFCSearchOptionCell.CBEntry> call(TableColumn<Map<String, String>, EFCSearchOptionCell.CBEntry> tableColumn) {
                    EFCSearchOptionCell cbCell = new EFCSearchOptionCell(optionClass);
                    return cbCell;
                }
            });
            this.setCellValueFactory((Callback)new MapValueFactory(name.toUpperCase()){

                public ObservableValue call(TableColumn.CellDataFeatures cdf) {
                    Object result = super.call(cdf).getValue();
                    EFCSearchOptionCell.CBEntry bResult = null;
                    if (result != null) {
                        bResult = new EFCSearchOptionCell.CBEntry(new EFCOption(optionClass, result.toString()));
                    }
                    if (bResult == null) {
                        return null;
                    }
                    return new SimpleObjectProperty(bResult);
                }
            });
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<Map<String, String>, EFCSearchOptionCell.CBEntry>>(){

            public void handle(TableColumn.CellEditEvent<Map<String, String>, EFCSearchOptionCell.CBEntry> t) {
            }
        });
        this.setPrefWidth(70.0);
        this.setSortable(false);
    }
}

